/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.ValueString;

public class ValueStringTest
extends TestCase {
    public void testConstructor1() {
        ValueString vs = new ValueString();
        ValueStringTest.assertEquals((int)2, (int)vs.getType());
        ValueStringTest.assertEquals((String)"String", (String)vs.getTypeDesc());
        ValueStringTest.assertEquals((int)-1, (int)vs.getLength());
        ValueStringTest.assertEquals((int)-1, (int)vs.getPrecision());
        ValueString vs1 = new ValueString("Boden Test");
        ValueStringTest.assertEquals((int)2, (int)vs1.getType());
        ValueStringTest.assertEquals((String)"String", (String)vs1.getTypeDesc());
        ValueStringTest.assertEquals((int)-1, (int)vs1.getLength());
        ValueStringTest.assertEquals((int)-1, (int)vs1.getPrecision());
        ValueString vs2 = new ValueString();
        vs2.setPrecision(2);
        ValueStringTest.assertEquals((int)-1, (int)vs2.getPrecision());
        vs2.setLength(10);
        ValueStringTest.assertEquals((int)10, (int)vs2.getLength());
    }

    public void testGetNullValue() {
        ValueString vs = new ValueString();
        ValueStringTest.assertNull((Object)vs.getString());
        ValueStringTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.0);
        ValueStringTest.assertNull((Object)vs.getDate());
        ValueStringTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        ValueStringTest.assertEquals((long)0L, (long)vs.getInteger());
        ValueStringTest.assertEquals(null, (Object)vs.getBigNumber());
        ValueStringTest.assertNull((Object)vs.getSerializable());
    }

    public void testGetNumericValue1() {
        ValueString vs = new ValueString("1000");
        ValueStringTest.assertEquals((String)"1000", (String)vs.getString());
        ValueStringTest.assertEquals((double)1000.0, (double)vs.getNumber(), (double)0.0);
        ValueStringTest.assertNull((Object)vs.getDate());
        ValueStringTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        ValueStringTest.assertEquals((long)1000L, (long)vs.getInteger());
        ValueStringTest.assertEquals((Object)BigDecimal.valueOf(1000L), (Object)vs.getBigNumber());
    }

    public void testGetNumericValue2() {
        ValueString vs = new ValueString("2.8");
        ValueStringTest.assertEquals((String)"2.8", (String)vs.getString());
        ValueStringTest.assertEquals((double)2.8, (double)vs.getNumber(), (double)0.0);
        ValueStringTest.assertNull((Object)vs.getDate());
        ValueStringTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        ValueStringTest.assertEquals((long)0L, (long)vs.getInteger());
        ValueStringTest.assertEquals((double)2.8, (double)vs.getBigNumber().doubleValue(), (double)0.1);
    }

    public void testGetString() {
        ValueString vs = new ValueString("Boden");
        ValueStringTest.assertEquals((String)"Boden", (String)vs.getString());
        ValueStringTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.0);
        ValueStringTest.assertNull((Object)vs.getDate());
        ValueStringTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        ValueStringTest.assertEquals((long)0L, (long)vs.getInteger());
        try {
            vs.getBigNumber();
            ValueStringTest.fail((String)"Expected a NumberFormatException");
        }
        catch (NumberFormatException ex) {
            vs = null;
        }
    }

    public void testSetString() {
        ValueString vs = new ValueString();
        vs.setString(null);
        ValueStringTest.assertNull((Object)vs.getString());
        vs.setString("");
        ValueStringTest.assertEquals((String)"", (String)vs.getString());
        vs.setString("Boden");
        ValueStringTest.assertEquals((String)"Boden", (String)vs.getString());
    }

    public void testSetNumber() {
        ValueString vs = new ValueString();
        vs.setNumber(0.0);
        ValueStringTest.assertEquals((String)"0.0", (String)vs.getString());
        vs.setNumber(1.0);
        ValueStringTest.assertEquals((String)"1.0", (String)vs.getString());
        vs.setNumber(-1.0);
        ValueStringTest.assertEquals((String)"-1.0", (String)vs.getString());
        vs.setNumber(2.5);
        ValueStringTest.assertEquals((String)"2.5", (String)vs.getString());
        vs.setNumber(2.8);
        ValueStringTest.assertEquals((String)"2.8", (String)vs.getString());
    }

    public void testSetDate() throws ParseException {
        ValueString vs = new ValueString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        try {
            vs.setDate(null);
            ValueStringTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        vs.setDate(format.parse("2006/06/07 01:02:03.004"));
        ValueStringTest.assertEquals((String)"2006/06/07 01:02:03.004", (String)vs.getString());
    }

    public void testSetBoolean() {
        ValueString vs = new ValueString();
        vs.setBoolean(false);
        ValueStringTest.assertEquals((String)"N", (String)vs.getString());
        vs.setBoolean(true);
        ValueStringTest.assertEquals((String)"Y", (String)vs.getString());
    }

    public void testSetInteger() {
        ValueString vs = new ValueString();
        vs.setInteger(-1L);
        ValueStringTest.assertEquals((String)"-1", (String)vs.getString());
        vs.setInteger(0L);
        ValueStringTest.assertEquals((String)"0", (String)vs.getString());
        vs.setInteger(1L);
        ValueStringTest.assertEquals((String)"1", (String)vs.getString());
    }

    public void testSetBigNumber() {
        ValueString vs = new ValueString();
        try {
            vs.setBigNumber(null);
            ValueStringTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        vs.setBigNumber(BigDecimal.ZERO);
        ValueStringTest.assertEquals((String)"0", (String)vs.getString());
    }

    public void testClone() {
        ValueString vs = new ValueString("Boden");
        ValueString vs1 = (ValueString)vs.clone();
        ValueStringTest.assertFalse((boolean)vs.equals(vs1));
        ValueStringTest.assertTrue((vs != vs1 ? 1 : 0) != 0);
        ValueStringTest.assertEquals((String)vs.getString(), (String)vs1.getString());
    }
}

