/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;

public class ValueTest
extends TestCase {
    public void testConstructor1() {
        Value vs = new Value();
        ValueTest.assertFalse((boolean)vs.isNull());
        ValueTest.assertTrue((boolean)vs.isEmpty());
        ValueTest.assertEquals(null, (String)vs.getName());
        ValueTest.assertEquals(null, (String)vs.getOrigin());
        ValueTest.assertEquals((int)0, (int)vs.getType());
        ValueTest.assertFalse((boolean)vs.isString());
        ValueTest.assertFalse((boolean)vs.isDate());
        ValueTest.assertFalse((boolean)vs.isNumeric());
        ValueTest.assertFalse((boolean)vs.isInteger());
        ValueTest.assertFalse((boolean)vs.isBigNumber());
        ValueTest.assertFalse((boolean)vs.isNumber());
        ValueTest.assertFalse((boolean)vs.isBoolean());
        Value vs1 = new Value("Name");
        ValueTest.assertFalse((boolean)vs1.isNull());
        ValueTest.assertTrue((boolean)vs1.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs1.getName());
        ValueTest.assertEquals(null, (String)vs1.getOrigin());
        ValueTest.assertEquals((int)0, (int)vs1.getType());
    }

    public void testConstructor2() {
        Value vs = new Value("Name", 1);
        ValueTest.assertFalse((boolean)vs.isNull());
        ValueTest.assertFalse((boolean)vs.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs.getName());
        ValueTest.assertEquals((int)1, (int)vs.getType());
        ValueTest.assertTrue((boolean)vs.isNumber());
        ValueTest.assertTrue((boolean)vs.isNumeric());
        Value vs1 = new Value("Name", 2);
        ValueTest.assertFalse((boolean)vs1.isNull());
        ValueTest.assertFalse((boolean)vs1.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs1.getName());
        ValueTest.assertEquals((int)2, (int)vs1.getType());
        ValueTest.assertTrue((boolean)vs1.isString());
        Value vs2 = new Value("Name", 3);
        ValueTest.assertFalse((boolean)vs2.isNull());
        ValueTest.assertFalse((boolean)vs2.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs2.getName());
        ValueTest.assertEquals((int)3, (int)vs2.getType());
        ValueTest.assertTrue((boolean)vs2.isDate());
        Value vs3 = new Value("Name", 4);
        ValueTest.assertFalse((boolean)vs3.isNull());
        ValueTest.assertFalse((boolean)vs3.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs3.getName());
        ValueTest.assertEquals((int)4, (int)vs3.getType());
        ValueTest.assertTrue((boolean)vs3.isBoolean());
        Value vs4 = new Value("Name", 5);
        ValueTest.assertFalse((boolean)vs4.isNull());
        ValueTest.assertFalse((boolean)vs4.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs4.getName());
        ValueTest.assertEquals((int)5, (int)vs4.getType());
        ValueTest.assertTrue((boolean)vs4.isInteger());
        ValueTest.assertTrue((boolean)vs4.isNumeric());
        Value vs5 = new Value("Name", 6);
        ValueTest.assertFalse((boolean)vs5.isNull());
        ValueTest.assertFalse((boolean)vs5.isEmpty());
        ValueTest.assertEquals((String)"Name", (String)vs5.getName());
        ValueTest.assertEquals((int)6, (int)vs5.getType());
        ValueTest.assertTrue((boolean)vs5.isBigNumber());
        ValueTest.assertTrue((boolean)vs5.isNumeric());
        Value vs6 = new Value("Name", 1000000);
        ValueTest.assertEquals((int)0, (int)vs6.getType());
    }

    public void testConstructor3() {
        Value vs = new Value("Name", 1);
        vs.setValue(10.0);
        vs.setOrigin("origin");
        vs.setLength(4, 2);
        Value copy = new Value(vs);
        ValueTest.assertEquals((int)vs.getType(), (int)copy.getType());
        ValueTest.assertEquals((double)vs.getNumber(), (double)copy.getNumber(), (double)0.1);
        ValueTest.assertEquals((int)vs.getLength(), (int)copy.getLength());
        ValueTest.assertEquals((int)vs.getPrecision(), (int)copy.getPrecision());
        ValueTest.assertEquals((boolean)vs.isNull(), (boolean)copy.isNull());
        ValueTest.assertEquals((String)vs.getOrigin(), (String)copy.getOrigin());
        ValueTest.assertEquals((String)vs.getName(), (String)copy.getName());
        copy.setName("newName");
        ValueTest.assertEquals((String)"Name", (String)vs.getName());
        ValueTest.assertEquals((String)"newName", (String)copy.getName());
        copy.setOrigin("newOrigin");
        ValueTest.assertEquals((String)"origin", (String)vs.getOrigin());
        ValueTest.assertEquals((String)"newOrigin", (String)copy.getOrigin());
        copy.setValue(11.0);
        ValueTest.assertEquals((double)10.0, (double)vs.getNumber(), (double)0.1);
        ValueTest.assertEquals((double)11.0, (double)copy.getNumber(), (double)0.1);
        Value vs1 = new Value("Name", 1);
        vs1.setName(null);
        Value copy1 = new Value(vs1);
        ValueTest.assertEquals((int)vs1.getType(), (int)copy1.getType());
        ValueTest.assertEquals((double)vs1.getNumber(), (double)copy1.getNumber(), (double)0.1);
        ValueTest.assertEquals((int)vs1.getLength(), (int)copy1.getLength());
        ValueTest.assertEquals((int)vs1.getPrecision(), (int)copy1.getPrecision());
        ValueTest.assertEquals((boolean)vs1.isNull(), (boolean)copy1.isNull());
        ValueTest.assertEquals((String)vs1.getOrigin(), (String)copy1.getOrigin());
        ValueTest.assertEquals((String)vs1.getName(), (String)copy1.getName());
        Value vs2 = new Value((Value)null);
        ValueTest.assertTrue((boolean)vs2.isNull());
        ValueTest.assertNull((Object)vs2.getName());
        ValueTest.assertNull((Object)vs2.getOrigin());
    }

    public void testConstructor4() {
        Value vs = new Value("Name", new StringBuffer("buffer"));
        ValueTest.assertEquals((int)2, (int)vs.getType());
        ValueTest.assertEquals((String)"buffer", (String)vs.getString());
    }

    public void testConstructor5() {
        Value vs = new Value("Name", 10.0);
        ValueTest.assertEquals((int)1, (int)vs.getType());
        ValueTest.assertEquals((String)"Name", (String)vs.getName());
        Value copy = new Value("newName", vs);
        ValueTest.assertEquals((String)"newName", (String)copy.getName());
        ValueTest.assertFalse((!vs.equals((Object)copy) ? 1 : 0) != 0);
        copy.setName("Name");
        ValueTest.assertTrue((boolean)vs.equals((Object)copy));
    }

    public void testToStringString() {
        String result = null;
        Value vs = new Value("Name", 2);
        vs.setValue("test string");
        result = vs.toString(true);
        ValueTest.assertEquals((String)"test string", (String)result);
        vs.setLength(20);
        result = vs.toString(true);
        ValueTest.assertEquals((String)"test string         ", (String)result);
        vs.setLength(4);
        result = vs.toString(true);
        ValueTest.assertEquals((String)"test", (String)result);
        vs.setLength(0);
        result = vs.toString(true);
        ValueTest.assertEquals((String)"test string", (String)result);
        result = vs.toString(false);
        ValueTest.assertEquals((String)"test string", (String)result);
        vs.setLength(20);
        result = vs.toString(false);
        ValueTest.assertEquals((String)"test string", (String)result);
        vs.setLength(4);
        result = vs.toString(false);
        ValueTest.assertEquals((String)"test string", (String)result);
        vs.setLength(0);
        result = vs.toString(false);
        ValueTest.assertEquals((String)"test string", (String)result);
        vs.setLength(4);
        vs.setNull();
        result = vs.toString(false);
        ValueTest.assertEquals((String)"", (String)result);
        Value vs1 = new Value("Name", 2);
        ValueTest.assertEquals((String)"", (String)vs1.toString());
        Value vs2 = new Value("Name", 0);
        ValueTest.assertEquals((String)"", (String)vs2.toString());
    }

    public void testToStringNumber() {
        Value vs1 = new Value("Name", 1);
        ValueTest.assertEquals((String)(" 0" + Const.DEFAULT_DECIMAL_SEPARATOR + "0"), (String)vs1.toString(true));
        Value vs2 = new Value("Name", 1);
        vs2.setNull();
        ValueTest.assertEquals((String)"", (String)vs2.toString(true));
        Value vs3 = new Value("Name", 1);
        vs3.setValue(100.0);
        vs3.setLength(6);
        vs3.setNull();
        ValueTest.assertEquals((String)"      ", (String)vs3.toString(true));
        Value vs4 = new Value("Name", 1);
        vs4.setValue(100.0);
        vs4.setLength(6);
        ValueTest.assertEquals((String)(" 000100" + Const.DEFAULT_DECIMAL_SEPARATOR + "00"), (String)vs4.toString(true));
        Value vs5 = new Value("Name", 1);
        vs5.setValue(100.5);
        vs5.setLength(-1);
        vs5.setPrecision(-1);
        ValueTest.assertEquals((String)(" 100" + Const.DEFAULT_DECIMAL_SEPARATOR + "5"), (String)vs5.toString(true));
        Value vs6 = new Value("Name", 1);
        vs6.setValue(100.5);
        vs6.setLength(8);
        vs6.setPrecision(-1);
        ValueTest.assertEquals((String)(" 00000100" + Const.DEFAULT_DECIMAL_SEPARATOR + "50"), (String)vs6.toString(true));
        Value vs7 = new Value("Name", 1);
        vs7.setValue(100.5);
        vs7.setLength(0);
        vs7.setPrecision(3);
        ValueTest.assertEquals((String)(" 100" + Const.DEFAULT_DECIMAL_SEPARATOR + "5"), (String)vs7.toString(true));
        Value vs8 = new Value("Name", 1);
        vs8.setValue(100.5);
        vs8.setLength(5);
        vs8.setPrecision(3);
        ValueTest.assertEquals((String)"100.5", (String)vs8.toString(false));
        Value vs9 = new Value("Name", 1);
        vs9.setValue(100.0);
        vs9.setLength(6);
        ValueTest.assertEquals((String)"100.0", (String)vs9.toString(false));
        Value vs10 = new Value("Name", 1);
        vs10.setValue(100.5);
        vs10.setLength(-1);
        vs10.setPrecision(-1);
        ValueTest.assertEquals((String)"100.5", (String)vs10.toString(false));
        Value vs11 = new Value("Name", 1);
        vs11.setValue(100.5);
        vs11.setLength(8);
        vs11.setPrecision(-1);
        ValueTest.assertEquals((String)"100.5", (String)vs11.toString(false));
        Value vs12 = new Value("Name", 1);
        vs12.setValue(100.5);
        vs12.setLength(0);
        vs12.setPrecision(3);
        ValueTest.assertEquals((String)"100.5", (String)vs12.toString(false));
        Value vs13 = new Value("Name", 1);
        vs13.setValue(100.5);
        vs13.setLength(5);
        vs13.setPrecision(3);
        ValueTest.assertEquals((String)"100.5", (String)vs13.toString(false));
        Value vs14 = new Value("Name", 1);
        vs14.setValue(100.5);
        vs14.setLength(5);
        vs14.setPrecision(3);
        ValueTest.assertEquals((String)(" 100" + Const.DEFAULT_DECIMAL_SEPARATOR + "500"), (String)vs14.toString(true));
    }

    public void testToIntegerNumber() {
        Value vs1 = new Value("Name", 5);
        ValueTest.assertEquals((String)" 0", (String)vs1.toString(true));
        Value vs2 = new Value("Name", 5);
        vs2.setNull();
        ValueTest.assertEquals((String)"", (String)vs2.toString(true));
        Value vs3 = new Value("Name", 5);
        vs3.setValue(100);
        vs3.setLength(6);
        vs3.setNull();
        ValueTest.assertEquals((String)"      ", (String)vs3.toString(true));
        Value vs4 = new Value("Name", 5);
        vs4.setValue(100);
        vs4.setLength(6);
        ValueTest.assertEquals((String)" 000100", (String)vs4.toString(true));
        Value vs5 = new Value("Name", 5);
        vs5.setValue(100);
        vs5.setLength(-1);
        vs5.setPrecision(-1);
        ValueTest.assertEquals((String)" 100", (String)vs5.toString(true));
        Value vs6 = new Value("Name", 5);
        vs6.setValue(105);
        vs6.setLength(8);
        vs6.setPrecision(-1);
        ValueTest.assertEquals((String)" 00000105", (String)vs6.toString(true));
        Value vs7 = new Value("Name", 5);
        vs7.setValue(100);
        vs7.setLength(0);
        vs7.setPrecision(3);
        ValueTest.assertEquals((String)" 100", (String)vs7.toString(true));
        Value vs8 = new Value("Name", 5);
        vs8.setValue(100);
        vs8.setLength(5);
        vs8.setPrecision(3);
        ValueTest.assertEquals((String)"100", (String)vs8.toString(false));
        Value vs9 = new Value("Name", 5);
        vs9.setValue(100);
        vs9.setLength(6);
        ValueTest.assertEquals((String)"100", (String)vs9.toString(false));
        Value vs10 = new Value("Name", 5);
        vs10.setValue(100);
        vs10.setLength(-1);
        vs10.setPrecision(-1);
        ValueTest.assertEquals((String)" 100", (String)vs10.toString(false));
        Value vs11 = new Value("Name", 5);
        vs11.setValue(100);
        vs11.setLength(8);
        vs11.setPrecision(-1);
        ValueTest.assertEquals((String)"100", (String)vs11.toString(false));
        Value vs12 = new Value("Name", 5);
        vs12.setValue(100);
        vs12.setLength(0);
        vs12.setPrecision(3);
        ValueTest.assertEquals((String)" 100", (String)vs12.toString(false));
        Value vs13 = new Value("Name", 5);
        vs13.setValue(100);
        vs13.setLength(5);
        vs13.setPrecision(3);
        ValueTest.assertEquals((String)"100", (String)vs13.toString(false));
        Value vs14 = new Value("Name", 5);
        vs14.setValue(100);
        vs14.setLength(5);
        vs14.setPrecision(3);
        ValueTest.assertEquals((String)" 00100", (String)vs14.toString(true));
    }

    public void testToStringBoolean() {
        String result = null;
        Value vs = new Value("Name", 4);
        vs.setValue(true);
        result = vs.toString(true);
        ValueTest.assertEquals((String)"true", (String)result);
        Value vs1 = new Value("Name", 4);
        vs1.setValue(false);
        result = vs1.toString(true);
        ValueTest.assertEquals((String)"false", (String)result);
        Value vs2 = new Value("Name", 4);
        vs2.setValue(true);
        vs2.setNull();
        result = vs2.toString(true);
        ValueTest.assertEquals((String)"", (String)result);
        Value vs3 = new Value("Name", 4);
        vs3.setValue(false);
        vs3.setNull();
        result = vs3.toString(true);
        ValueTest.assertEquals((String)"", (String)result);
        Value vs4 = new Value("Name", 4);
        vs4.setValue(true);
        vs4.setLength(1);
        result = vs4.toString(true);
        ValueTest.assertEquals((String)"true", (String)result);
        Value vs5 = new Value("Name", 4);
        vs5.setValue(false);
        vs5.setLength(1);
        result = vs5.toString(true);
        ValueTest.assertEquals((String)"false", (String)result);
        Value vs6 = new Value("Name", 4);
        vs6.setValue(true);
        vs6.setLength(3);
        result = vs6.toString(true);
        ValueTest.assertEquals((String)"true", (String)result);
        Value vs7 = new Value("Name", 4);
        vs7.setValue(false);
        vs7.setLength(3);
        result = vs7.toString(true);
        ValueTest.assertEquals((String)"false", (String)result);
    }

    public void testToStringDate() {
        String result = null;
        Value vs1 = new Value("Name", 3);
        result = vs1.toString(true);
        ValueTest.assertEquals((String)"", (String)result);
        Value vs2 = new Value("Name", 3);
        vs2.setNull(true);
        result = vs2.toString(true);
        ValueTest.assertEquals((String)"", (String)result);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date dt = df.parse("2006/03/01 17:01:02.005", new ParsePosition(0));
        Value vs3 = new Value("Name", 3);
        vs3.setValue(dt);
        result = vs3.toString(true);
        ValueTest.assertEquals((String)"2006/03/01 17:01:02.005", (String)result);
        Value vs4 = new Value("Name", 3);
        vs4.setNull(true);
        vs4.setLength(2);
        result = vs4.toString(true);
        ValueTest.assertEquals((String)"", (String)result);
        Value vs5 = new Value("Name", 3);
        vs3.setValue(dt);
        vs5.setLength(10);
        result = vs5.toString(true);
        ValueTest.assertEquals((String)"", (String)result);
    }

    public void testToStringMeta() {
        String result = null;
        Value vs = new Value("Name", 2);
        vs.setValue("test");
        result = vs.toStringMeta();
        ValueTest.assertEquals((String)"String", (String)result);
        Value vs1 = new Value("Name", 2);
        vs1.setValue("test");
        vs1.setLength(0);
        result = vs1.toStringMeta();
        ValueTest.assertEquals((String)"String", (String)result);
        Value vs2 = new Value("Name", 2);
        vs2.setValue("test");
        vs2.setLength(4);
        result = vs2.toStringMeta();
        ValueTest.assertEquals((String)"String(4)", (String)result);
        Value vs3 = new Value("Name", 4);
        vs3.setValue(false);
        result = vs3.toStringMeta();
        ValueTest.assertEquals((String)"Boolean", (String)result);
        Value vs4 = new Value("Name", 4);
        vs4.setValue(false);
        vs4.setLength(0);
        result = vs4.toStringMeta();
        ValueTest.assertEquals((String)"Boolean", (String)result);
        Value vs5 = new Value("Name", 4);
        vs5.setValue(false);
        vs5.setLength(4);
        result = vs5.toStringMeta();
        ValueTest.assertEquals((String)"Boolean", (String)result);
        Value vs6 = new Value("Name", 5);
        vs6.setValue(10);
        result = vs6.toStringMeta();
        ValueTest.assertEquals((String)"Integer", (String)result);
        Value vs7 = new Value("Name", 5);
        vs7.setValue(10);
        vs7.setLength(0);
        result = vs7.toStringMeta();
        ValueTest.assertEquals((String)"Integer", (String)result);
        Value vs8 = new Value("Name", 5);
        vs8.setValue(10);
        vs8.setLength(4);
        result = vs8.toStringMeta();
        ValueTest.assertEquals((String)"Integer(4)", (String)result);
        Value vs9 = new Value("Name", 1);
        vs9.setValue(10.0);
        result = vs9.toStringMeta();
        ValueTest.assertEquals((String)"Number", (String)result);
        Value vs10 = new Value("Name", 1);
        vs10.setValue(10.0);
        vs10.setLength(0);
        result = vs10.toStringMeta();
        ValueTest.assertEquals((String)"Number", (String)result);
        Value vs11 = new Value("Name", 1);
        vs11.setValue(10.0);
        vs11.setLength(4);
        result = vs11.toStringMeta();
        ValueTest.assertEquals((String)"Number(4)", (String)result);
        Value vs12 = new Value("Name", 1);
        vs12.setValue(10.0);
        vs12.setLength(4);
        vs12.setPrecision(2);
        result = vs12.toStringMeta();
        ValueTest.assertEquals((String)"Number(4, 2)", (String)result);
        Value vs13 = new Value("Name", 6);
        vs13.setValue(new BigDecimal(10));
        result = vs13.toStringMeta();
        ValueTest.assertEquals((String)"BigNumber", (String)result);
        Value vs14 = new Value("Name", 6);
        vs14.setValue(new BigDecimal(10));
        vs14.setLength(0);
        result = vs14.toStringMeta();
        ValueTest.assertEquals((String)"BigNumber", (String)result);
        Value vs15 = new Value("Name", 6);
        vs15.setValue(new BigDecimal(10));
        vs15.setLength(4);
        result = vs15.toStringMeta();
        ValueTest.assertEquals((String)"BigNumber(4)", (String)result);
        Value vs16 = new Value("Name", 6);
        vs16.setValue(new BigDecimal(10));
        vs16.setLength(4);
        vs16.setPrecision(2);
        result = vs16.toStringMeta();
        ValueTest.assertEquals((String)"BigNumber(4, 2)", (String)result);
        Value vs17 = new Value("Name", 3);
        vs17.setValue(new Date());
        result = vs17.toStringMeta();
        ValueTest.assertEquals((String)"Date", (String)result);
        Value vs18 = new Value("Name", 3);
        vs18.setValue(new Date());
        vs18.setLength(0);
        result = vs18.toStringMeta();
        ValueTest.assertEquals((String)"Date", (String)result);
        Value vs19 = new Value("Name", 3);
        vs19.setValue(new Date());
        vs19.setLength(4);
        result = vs19.toStringMeta();
        ValueTest.assertEquals((String)"Date", (String)result);
        Value vs20 = new Value("Name", 3);
        vs20.setValue(new Date());
        vs20.setLength(4);
        vs20.setPrecision(2);
        result = vs20.toStringMeta();
        ValueTest.assertEquals((String)"Date", (String)result);
    }

    public void testClone1() {
        Value vs = new Value("Name", 1);
        vs.setValue(10.0);
        vs.setOrigin("origin");
        vs.setLength(4, 2);
        Value copy = vs.Clone();
        ValueTest.assertEquals((int)vs.getType(), (int)copy.getType());
        ValueTest.assertEquals((double)vs.getNumber(), (double)copy.getNumber(), (double)0.1);
        ValueTest.assertEquals((int)vs.getLength(), (int)copy.getLength());
        ValueTest.assertEquals((int)vs.getPrecision(), (int)copy.getPrecision());
        ValueTest.assertEquals((boolean)vs.isNull(), (boolean)copy.isNull());
        ValueTest.assertEquals((String)vs.getOrigin(), (String)copy.getOrigin());
        ValueTest.assertEquals((String)vs.getName(), (String)copy.getName());
        copy.setName("newName");
        ValueTest.assertEquals((String)"Name", (String)vs.getName());
        ValueTest.assertEquals((String)"newName", (String)copy.getName());
        copy.setOrigin("newOrigin");
        ValueTest.assertEquals((String)"origin", (String)vs.getOrigin());
        ValueTest.assertEquals((String)"newOrigin", (String)copy.getOrigin());
        copy.setValue(11.0);
        ValueTest.assertEquals((double)10.0, (double)vs.getNumber(), (double)0.1);
        ValueTest.assertEquals((double)11.0, (double)copy.getNumber(), (double)0.1);
        Value vs1 = new Value("Name", 1);
        vs1.setName(null);
        Value copy1 = new Value(vs1);
        ValueTest.assertEquals((int)vs1.getType(), (int)copy1.getType());
        ValueTest.assertEquals((double)vs1.getNumber(), (double)copy1.getNumber(), (double)0.1);
        ValueTest.assertEquals((int)vs1.getLength(), (int)copy1.getLength());
        ValueTest.assertEquals((int)vs1.getPrecision(), (int)copy1.getPrecision());
        ValueTest.assertEquals((boolean)vs1.isNull(), (boolean)copy1.isNull());
        ValueTest.assertEquals((String)vs1.getOrigin(), (String)copy1.getOrigin());
        ValueTest.assertEquals((String)vs1.getName(), (String)copy1.getName());
        Value vs2 = new Value((Value)null);
        ValueTest.assertTrue((boolean)vs2.isNull());
        ValueTest.assertNull((Object)vs2.getName());
        ValueTest.assertNull((Object)vs2.getOrigin());
    }

    public void testGetStringLength() {
        int result = 0;
        Value vs1 = new Value("Name", 2);
        result = vs1.getStringLength();
        ValueTest.assertEquals((int)0, (int)result);
        Value vs2 = new Value("Name", 2);
        vs2.setNull();
        result = vs2.getStringLength();
        ValueTest.assertEquals((int)0, (int)result);
        Value vs3 = new Value("Name", 2);
        vs3.setValue("stringlength");
        result = vs3.getStringLength();
        ValueTest.assertEquals((int)12, (int)result);
    }

    public void testGetXML() {
        String result = null;
        Value vs1 = new Value("Name", 2);
        vs1.setValue("test");
        vs1.setLength(4);
        vs1.setPrecision(2);
        result = vs1.getXML();
        ValueTest.assertEquals((String)"<value><name>Name</name><type>String</type><text>test</text><length>4</length><precision>-1</precision><isnull>N</isnull></value>", (String)result);
        Value vs2 = new Value("Name", 4);
        vs2.setValue(false);
        vs2.setLength(4);
        vs2.setPrecision(2);
        result = vs2.getXML();
        ValueTest.assertEquals((String)"<value><name>Name</name><type>Boolean</type><text>false</text><length>-1</length><precision>-1</precision><isnull>N</isnull></value>", (String)result);
        Value vs3 = new Value("Name", 5);
        vs3.setValue(10);
        vs3.setLength(4);
        vs3.setPrecision(2);
        result = vs3.getXML();
        ValueTest.assertEquals((String)"<value><name>Name</name><type>Integer</type><text>10</text><length>4</length><precision>0</precision><isnull>N</isnull></value>", (String)result);
        Value vs4 = new Value("Name", 1);
        vs4.setValue(10.0);
        vs4.setLength(4);
        vs4.setPrecision(2);
        result = vs4.getXML();
        ValueTest.assertEquals((String)"<value><name>Name</name><type>Number</type><text>10.0</text><length>4</length><precision>2</precision><isnull>N</isnull></value>", (String)result);
        Value vs5 = new Value("Name", 6);
        vs5.setValue(new BigDecimal(10));
        vs5.setLength(4);
        vs5.setPrecision(2);
        result = vs5.getXML();
        ValueTest.assertEquals((String)"<value><name>Name</name><type>BigNumber</type><text>10</text><length>4</length><precision>2</precision><isnull>N</isnull></value>", (String)result);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date dt = df.parse("2006/03/01 17:01:02.005", new ParsePosition(0));
        Value vs6 = new Value("Name", 3);
        vs6.setValue(dt);
        vs6.setLength(4);
        vs6.setPrecision(2);
        result = vs6.getXML();
        ValueTest.assertEquals((String)"<value><name>Name</name><type>Date</type><text>2006&#47;03&#47;01 17:01:02.005</text><length>-1</length><precision>2</precision><isnull>N</isnull></value>", (String)result);
    }

    public void testSetValue() {
        Value vs = new Value("Name", 5);
        vs.setValue(100L);
        vs.setOrigin("origin");
        Value vs1 = new Value((Value)null);
        ValueTest.assertTrue((boolean)vs1.isNull());
        ValueTest.assertTrue((boolean)vs1.isEmpty());
        ValueTest.assertNull((Object)vs1.getName());
        ValueTest.assertNull((Object)vs1.getOrigin());
        ValueTest.assertEquals((int)0, (int)vs1.getType());
        Value vs2 = new Value("newName", 5);
        vs2.setOrigin("origin1");
        vs2.setValue(vs);
        ValueTest.assertEquals((String)"origin", (String)vs2.getOrigin());
        ValueTest.assertEquals((long)vs.getInteger(), (long)vs2.getInteger());
        Value vs3 = new Value("newName", 5);
        vs3.setValue(new StringBuffer("Sven"));
        ValueTest.assertEquals((int)2, (int)vs3.getType());
        ValueTest.assertEquals((String)"Sven", (String)vs3.getString());
        Value vs4 = new Value("newName", 2);
        vs4.setValue(new StringBuffer("Test"));
        vs4.setValue(new StringBuffer("Sven"));
        ValueTest.assertEquals((int)2, (int)vs4.getType());
        ValueTest.assertEquals((String)"Sven", (String)vs4.getString());
        Value vs5 = new Value("Name", 5);
        vs5.setValue((byte)4);
        ValueTest.assertEquals((long)4L, (long)vs5.getInteger());
        Value vs6 = new Value("Name", 5);
        vs6.setValue((Value)null);
        ValueTest.assertFalse((boolean)vs6.isNull());
        ValueTest.assertNull((Object)vs6.getName());
        ValueTest.assertNull((Object)vs6.getOrigin());
        ValueTest.assertEquals((int)0, (int)vs6.getType());
    }

    public void testIsNumeric() {
        ValueTest.assertEquals((boolean)false, (boolean)Value.isNumeric((int)0));
        ValueTest.assertEquals((boolean)true, (boolean)Value.isNumeric((int)1));
        ValueTest.assertEquals((boolean)false, (boolean)Value.isNumeric((int)2));
        ValueTest.assertEquals((boolean)false, (boolean)Value.isNumeric((int)3));
        ValueTest.assertEquals((boolean)false, (boolean)Value.isNumeric((int)4));
        ValueTest.assertEquals((boolean)true, (boolean)Value.isNumeric((int)5));
        ValueTest.assertEquals((boolean)true, (boolean)Value.isNumeric((int)6));
        ValueTest.assertEquals((boolean)false, (boolean)Value.isNumeric((int)7));
    }

    public void testIsEqualTo() {
        Value vs1 = new Value("Name", 2);
        vs1.setValue("test");
        ValueTest.assertTrue((boolean)vs1.isEqualTo("test"));
        ValueTest.assertFalse((boolean)vs1.isEqualTo("test1"));
        Value vs2 = new Value("Name", 2);
        vs2.setValue(BigDecimal.ONE);
        ValueTest.assertTrue((boolean)vs2.isEqualTo(BigDecimal.ONE));
        ValueTest.assertFalse((boolean)vs2.isEqualTo(BigDecimal.valueOf(2.0)));
        Value vs3 = new Value("Name", 1);
        vs3.setValue(10.0);
        ValueTest.assertTrue((boolean)vs3.isEqualTo(10.0));
        ValueTest.assertFalse((boolean)vs3.isEqualTo(11.0));
        Value vs4 = new Value("Name", 5);
        vs4.setValue(10L);
        ValueTest.assertTrue((boolean)vs4.isEqualTo(10L));
        ValueTest.assertFalse((boolean)vs4.isEqualTo(11L));
        Value vs5 = new Value("Name", 5);
        vs5.setValue(10);
        ValueTest.assertTrue((boolean)vs5.isEqualTo(10));
        ValueTest.assertFalse((boolean)vs5.isEqualTo(11));
        Value vs6 = new Value("Name", 5);
        vs6.setValue((byte)10);
        ValueTest.assertTrue((boolean)vs6.isEqualTo(10));
        ValueTest.assertFalse((boolean)vs6.isEqualTo(11));
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date dt = df.parse("2006/03/01 17:01:02.005", new ParsePosition(0));
        Value vs7 = new Value("Name", 3);
        vs7.setValue(dt);
        ValueTest.assertTrue((boolean)vs7.isEqualTo(dt));
        ValueTest.assertFalse((boolean)vs7.isEqualTo(new Date()));
    }

    public void testBooleanOperators() {
        Value vs1 = new Value("Name", 4);
        Value vs2 = new Value("Name", 4);
        vs1.setValue(false);
        vs2.setValue(false);
        vs1.bool_and(vs2);
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(false);
        vs2.setValue(true);
        vs1.bool_and(vs2);
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs2.setValue(false);
        vs1.bool_and(vs2);
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs2.setValue(true);
        vs1.bool_and(vs2);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        vs1.setValue(false);
        vs2.setValue(false);
        vs1.bool_or(vs2);
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(false);
        vs2.setValue(true);
        vs1.bool_or(vs2);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs2.setValue(false);
        vs1.bool_or(vs2);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs2.setValue(true);
        vs1.bool_or(vs2);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        vs1.setValue(false);
        vs2.setValue(false);
        vs1.bool_xor(vs2);
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(false);
        vs2.setValue(true);
        vs1.bool_xor(vs2);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs2.setValue(false);
        vs1.bool_xor(vs2);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs2.setValue(true);
        vs1.bool_xor(vs2);
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(true);
        vs1.bool_not();
        ValueTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        vs1.setValue(false);
        vs1.bool_not();
        ValueTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
    }

    public void testBooleanOperators1() {
        Value vs1 = new Value("Name", 5);
        Value vs2 = new Value("Name", 5);
        vs1.setValue(255L);
        vs2.setValue(255L);
        vs1.and(vs2);
        ValueTest.assertEquals((long)255L, (long)vs1.getInteger());
        vs1.setValue(255L);
        vs2.setValue(0L);
        vs1.and(vs2);
        ValueTest.assertEquals((long)0L, (long)vs1.getInteger());
        vs1.setValue(0L);
        vs2.setValue(255L);
        vs1.and(vs2);
        ValueTest.assertEquals((long)0L, (long)vs1.getInteger());
        vs1.setValue(0L);
        vs2.setValue(0L);
        vs1.and(vs2);
        ValueTest.assertEquals((long)0L, (long)vs1.getInteger());
        vs1.setValue(255L);
        vs2.setValue(255L);
        vs1.or(vs2);
        ValueTest.assertEquals((long)255L, (long)vs1.getInteger());
        vs1.setValue(255L);
        vs2.setValue(0L);
        vs1.or(vs2);
        ValueTest.assertEquals((long)255L, (long)vs1.getInteger());
        vs1.setValue(0L);
        vs2.setValue(255L);
        vs1.or(vs2);
        ValueTest.assertEquals((long)255L, (long)vs1.getInteger());
        vs1.setValue(0L);
        vs2.setValue(0L);
        vs1.or(vs2);
        ValueTest.assertEquals((long)0L, (long)vs1.getInteger());
        vs1.setValue(255L);
        vs2.setValue(255L);
        vs1.xor(vs2);
        ValueTest.assertEquals((long)0L, (long)vs1.getInteger());
        vs1.setValue(255L);
        vs2.setValue(0L);
        vs1.xor(vs2);
        ValueTest.assertEquals((long)255L, (long)vs1.getInteger());
        vs1.setValue(0L);
        vs2.setValue(255L);
        vs1.xor(vs2);
        ValueTest.assertEquals((long)255L, (long)vs1.getInteger());
        vs1.setValue(0L);
        vs2.setValue(0L);
        vs1.xor(vs2);
        ValueTest.assertEquals((long)0L, (long)vs1.getInteger());
    }

    public void testComparators() {
        Value vs1 = new Value("Name", 5);
        Value vs2 = new Value("Name", 5);
        Value vs3 = new Value("Name", 5);
        vs1.setValue(128L);
        vs2.setValue(100L);
        vs3.setValue(128L);
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().greater_equal(vs2).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().greater_equal(vs3).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs2.Clone().greater_equal(vs1).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().smaller_equal(vs2).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().smaller_equal(vs3).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs2.Clone().smaller_equal(vs1).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().different(vs2).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().different(vs3).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().equal(vs2).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().equal(vs3).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().greater(vs2).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().greater(vs3).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs2.Clone().greater(vs1).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().smaller(vs2).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().smaller(vs3).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs2.Clone().smaller(vs1).getBoolean());
    }

    public void testTrim() {
        Value vs1 = new Value("Name1", 5);
        Value vs2 = new Value("Name2", 2);
        vs1.setValue(128L);
        vs1.setNull();
        ValueTest.assertNull((Object)vs1.Clone().ltrim().getString());
        ValueTest.assertNull((Object)vs1.Clone().rtrim().getString());
        ValueTest.assertNull((Object)vs1.Clone().trim().getString());
        vs1.setValue(128L);
        ValueTest.assertEquals((String)"128", (String)vs1.Clone().ltrim().getString());
        ValueTest.assertEquals((String)" 128", (String)vs1.Clone().rtrim().getString());
        ValueTest.assertEquals((String)"128", (String)vs1.Clone().trim().getString());
        vs2.setValue("    Sven Boden trim test    ");
        ValueTest.assertEquals((String)"Sven Boden trim test    ", (String)vs2.Clone().ltrim().getString());
        ValueTest.assertEquals((String)"    Sven Boden trim test", (String)vs2.Clone().rtrim().getString());
        ValueTest.assertEquals((String)"Sven Boden trim test", (String)vs2.Clone().trim().getString());
        vs2.setValue("");
        ValueTest.assertEquals((String)"", (String)vs2.Clone().ltrim().getString());
        ValueTest.assertEquals((String)"", (String)vs2.Clone().rtrim().getString());
        ValueTest.assertEquals((String)"", (String)vs2.Clone().trim().getString());
        vs2.setValue("   ");
        ValueTest.assertEquals((String)"", (String)vs2.Clone().ltrim().getString());
        ValueTest.assertEquals((String)"", (String)vs2.Clone().rtrim().getString());
        ValueTest.assertEquals((String)"", (String)vs2.Clone().trim().getString());
    }

    public void testHexToByteDecode() throws KettleValueException {
        Value vs1 = new Value("Name1", 5);
        vs1.setValue("6120622063");
        vs1.hexToByteDecode();
        ValueTest.assertEquals((String)"a b c", (String)vs1.getString());
        vs1.setValue("4161426243643039207A5A2E3F2F");
        vs1.hexToByteDecode();
        ValueTest.assertEquals((String)"AaBbCd09 zZ.?/", (String)vs1.getString());
        vs1.setValue("4161426243643039207a5a2e3f2f");
        vs1.hexToByteDecode();
        ValueTest.assertEquals((String)"AaBbCd09 zZ.?/", (String)vs1.getString());
        vs1.setValue("F6120622063");
        vs1.hexToByteDecode();
        ValueTest.assertEquals((String)"\u000fa b c", (String)vs1.getString());
        try {
            vs1.setValue("g");
            vs1.hexToByteDecode();
            ValueTest.fail((String)"Expected KettleValueException");
        }
        catch (KettleValueException kettleValueException) {
            // empty catch block
        }
    }

    public void testByteToHexEncode() {
        Value vs1 = new Value("Name1", 5);
        vs1.setValue("AaBbCd09 zZ.?/");
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"4161426243643039207A5A2E3F2F", (String)vs1.getString());
        vs1.setValue("1234567890");
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"31323334353637383930", (String)vs1.getString());
        vs1.setNull();
        vs1.byteToHexEncode();
        ValueTest.assertNull((Object)vs1.getString());
    }

    public void testHexByteRegression() throws KettleValueException {
        Value vs1 = new Value("Name1", 5);
        vs1.setValue("9B");
        vs1.hexToByteDecode();
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"9B", (String)vs1.getString());
        vs1.setValue("A7");
        vs1.hexToByteDecode();
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"A7", (String)vs1.getString());
        vs1.setValue("74792121212121212121212121C2A7");
        vs1.hexToByteDecode();
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"74792121212121212121212121C2A7", (String)vs1.getString());
        vs1.setValue("70616E2D6C656FC5A1");
        vs1.hexToByteDecode();
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"70616E2D6C656FC5A1", (String)vs1.getString());
        vs1.setValue("736B76C49B6C6520");
        vs1.hexToByteDecode();
        vs1.byteToHexEncode();
        ValueTest.assertEquals((String)"736B76C49B6C6520", (String)vs1.getString());
    }

    public void testHexCharTest() throws KettleValueException {
        Value vs1 = new Value("Name1", 5);
        vs1.setValue("009B");
        vs1.hexToCharDecode();
        vs1.charToHexEncode();
        ValueTest.assertEquals((String)"009B", (String)vs1.getString());
        vs1.setValue("007400790021002100C200A7");
        vs1.hexToCharDecode();
        vs1.charToHexEncode();
        ValueTest.assertEquals((String)"007400790021002100C200A7", (String)vs1.getString());
        vs1.setValue("FFFF00FFFF000F0FF0F0");
        vs1.hexToCharDecode();
        vs1.charToHexEncode();
        ValueTest.assertEquals((String)"FFFF00FFFF000F0FF0F0", (String)vs1.getString());
    }

    public void testLike() {
        Value vs1 = new Value("Name1", 2);
        Value vs2 = new Value("Name2", 2);
        Value vs3 = new Value("Name3", 2);
        vs1.setValue("This is a test");
        vs2.setValue("is a");
        vs3.setValue("not");
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().like(vs2).getBoolean());
        ValueTest.assertEquals((boolean)true, (boolean)vs1.Clone().like(vs1).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs1.Clone().like(vs3).getBoolean());
        ValueTest.assertEquals((boolean)false, (boolean)vs3.Clone().like(vs1).getBoolean());
    }

    public void testLooseEnds() {
        ValueTest.assertEquals((int)0, (int)Value.getType((String)"INVALID_TYPE"));
        ValueTest.assertEquals((String)"String", (String)Value.getTypeDesc((int)2));
    }

    public void testClone2() {
        Value vs = new Value("Name", 1);
        vs.setValue(10.0);
        vs.setOrigin("origin");
        vs.setLength(4, 2);
        Value copy = (Value)vs.clone();
        ValueTest.assertEquals((int)vs.getType(), (int)copy.getType());
        ValueTest.assertEquals((double)vs.getNumber(), (double)copy.getNumber(), (double)0.1);
        ValueTest.assertEquals((int)vs.getLength(), (int)copy.getLength());
        ValueTest.assertEquals((int)vs.getPrecision(), (int)copy.getPrecision());
        ValueTest.assertEquals((boolean)vs.isNull(), (boolean)copy.isNull());
        ValueTest.assertEquals((String)vs.getOrigin(), (String)copy.getOrigin());
        ValueTest.assertEquals((String)vs.getName(), (String)copy.getName());
        copy.setName("newName");
        ValueTest.assertEquals((String)"Name", (String)vs.getName());
        ValueTest.assertEquals((String)"newName", (String)copy.getName());
        copy.setOrigin("newOrigin");
        ValueTest.assertEquals((String)"origin", (String)vs.getOrigin());
        ValueTest.assertEquals((String)"newOrigin", (String)copy.getOrigin());
        copy.setValue(11.0);
        ValueTest.assertEquals((double)10.0, (double)vs.getNumber(), (double)0.1);
        ValueTest.assertEquals((double)11.0, (double)copy.getNumber(), (double)0.1);
        Value vs1 = new Value("Name", 1);
        vs1.setName(null);
        Value copy1 = new Value(vs1);
        ValueTest.assertEquals((int)vs1.getType(), (int)copy1.getType());
        ValueTest.assertEquals((double)vs1.getNumber(), (double)copy1.getNumber(), (double)0.1);
        ValueTest.assertEquals((int)vs1.getLength(), (int)copy1.getLength());
        ValueTest.assertEquals((int)vs1.getPrecision(), (int)copy1.getPrecision());
        ValueTest.assertEquals((boolean)vs1.isNull(), (boolean)copy1.isNull());
        ValueTest.assertEquals((String)vs1.getOrigin(), (String)copy1.getOrigin());
        ValueTest.assertEquals((String)vs1.getName(), (String)copy1.getName());
        Value vs2 = new Value((Value)null);
        ValueTest.assertTrue((boolean)vs2.isNull());
        ValueTest.assertNull((Object)vs2.getName());
        ValueTest.assertNull((Object)vs2.getOrigin());
    }
}

