/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import junit.framework.TestCase;
import org.pentaho.di.core.BlockingBatchingRowSet;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class BlockingBatchingRowSetTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ROWNR", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public void testBasicCreation() {
        BlockingBatchingRowSet set = new BlockingBatchingRowSet(10);
        BlockingBatchingRowSetTest.assertTrue((!set.isDone() ? 1 : 0) != 0);
        BlockingBatchingRowSetTest.assertEquals((int)0, (int)set.size());
    }

    public void testFuntionality1() {
        BlockingBatchingRowSet set = new BlockingBatchingRowSet(10);
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L)};
        Object[] r2 = new Object[]{new Long(2L)};
        Object[] r3 = new Object[]{new Long(3L)};
        BlockingBatchingRowSetTest.assertEquals((int)0, (int)set.size());
        set.putRow(rm, r1);
        BlockingBatchingRowSetTest.assertEquals((int)1, (int)set.size());
        set.putRow(rm, r2);
        BlockingBatchingRowSetTest.assertEquals((int)2, (int)set.size());
        Object[] r = set.getRow();
        BlockingBatchingRowSetTest.assertNull((Object)r);
        set.putRow(rm, r3);
        BlockingBatchingRowSetTest.assertEquals((int)3, (int)set.size());
        set.setDone();
        BlockingBatchingRowSetTest.assertTrue((boolean)set.isDone());
        r = set.getRow();
        BlockingBatchingRowSetTest.assertNotNull((Object)r);
        BlockingBatchingRowSetTest.assertEquals((int)2, (int)set.size());
        BlockingBatchingRowSetTest.assertEquals((Object)r[0], (Object)r1[0]);
        r = set.getRow();
        BlockingBatchingRowSetTest.assertNotNull((Object)r);
        BlockingBatchingRowSetTest.assertEquals((int)1, (int)set.size());
        BlockingBatchingRowSetTest.assertEquals((Object)r[0], (Object)r2[0]);
        r = set.getRow();
        BlockingBatchingRowSetTest.assertNotNull((Object)r);
        BlockingBatchingRowSetTest.assertEquals((int)0, (int)set.size());
        BlockingBatchingRowSetTest.assertEquals((Object)r[0], (Object)r3[0]);
    }
}

