/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import junit.framework.TestCase;
import org.pentaho.di.core.Const;

public class ConstTest
extends TestCase {
    private boolean isArraySorted(String[] arr) {
        if (arr.length < 2) {
            return true;
        }
        for (int idx = 0; idx < arr.length - 1; ++idx) {
            if (arr[idx].compareTo(arr[idx + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public void testInitCap() {
        ConstTest.assertEquals((String)"Sven", (String)Const.initCap((String)"Sven"));
        ConstTest.assertEquals((String)"Matt", (String)Const.initCap((String)"MATT"));
        ConstTest.assertEquals((String)"Sven Boden", (String)Const.initCap((String)"sven boden"));
        ConstTest.assertEquals((String)"Sven  Boden ", (String)Const.initCap((String)"sven  boden "));
        ConstTest.assertEquals((String)"Sven Boden Was Here", (String)Const.initCap((String)"sven boden was here"));
        ConstTest.assertEquals((String)"K\u00f6nnen", (String)Const.initCap((String)"k\u00f6nnen"));
    }

    public void testSortStrings() {
        String[] arr1 = new String[]{"Red", "Blue", "Black", "Black", "Green"};
        String[] arr2 = new String[]{"aaa", "zzz", "yyy", "sss", "ttt", "t"};
        String[] arr3 = new String[]{"A", "B", "C", "D"};
        String[] results = Const.sortStrings((String[])arr1);
        ConstTest.assertTrue((boolean)this.isArraySorted(arr1));
        ConstTest.assertTrue((boolean)this.isArraySorted(results));
        results = Const.sortStrings((String[])arr2);
        ConstTest.assertTrue((boolean)this.isArraySorted(arr2));
        ConstTest.assertTrue((boolean)this.isArraySorted(results));
        results = Const.sortStrings((String[])arr3);
        ConstTest.assertTrue((boolean)this.isArraySorted(arr3));
        ConstTest.assertTrue((boolean)this.isArraySorted(results));
    }

    public void testIsEmpty() {
        ConstTest.assertEquals((boolean)true, (boolean)Const.isEmpty((String)null));
        ConstTest.assertEquals((boolean)true, (boolean)Const.isEmpty((String)""));
        ConstTest.assertEquals((boolean)false, (boolean)Const.isEmpty((String)"test"));
    }

    public void testIsEmptyStringBuffer() {
        ConstTest.assertEquals((boolean)true, (boolean)Const.isEmpty((StringBuffer)null));
        ConstTest.assertEquals((boolean)true, (boolean)Const.isEmpty((StringBuffer)new StringBuffer("")));
        ConstTest.assertEquals((boolean)false, (boolean)Const.isEmpty((StringBuffer)new StringBuffer("test")));
    }

    public void testNVL() {
        ConstTest.assertNull((Object)Const.NVL(null, null));
        ConstTest.assertEquals((String)"test", (String)Const.NVL((String)"test", (String)"test1"));
        ConstTest.assertEquals((String)"test", (String)Const.NVL((String)"test", null));
        ConstTest.assertEquals((String)"test1", (String)Const.NVL(null, (String)"test1"));
    }

    public void testNrSpacesBefore() {
        try {
            Const.nrSpacesBefore(null);
            ConstTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ConstTest.assertEquals((int)0, (int)Const.nrSpacesBefore((String)""));
        ConstTest.assertEquals((int)1, (int)Const.nrSpacesBefore((String)" "));
        ConstTest.assertEquals((int)3, (int)Const.nrSpacesBefore((String)"   "));
        ConstTest.assertEquals((int)0, (int)Const.nrSpacesBefore((String)"test"));
        ConstTest.assertEquals((int)0, (int)Const.nrSpacesBefore((String)"test  "));
        ConstTest.assertEquals((int)3, (int)Const.nrSpacesBefore((String)"   test"));
        ConstTest.assertEquals((int)4, (int)Const.nrSpacesBefore((String)"    test  "));
    }

    public void testNrSpacesAfter() {
        try {
            Const.nrSpacesAfter(null);
            ConstTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ConstTest.assertEquals((int)0, (int)Const.nrSpacesAfter((String)""));
        ConstTest.assertEquals((int)1, (int)Const.nrSpacesAfter((String)" "));
        ConstTest.assertEquals((int)3, (int)Const.nrSpacesAfter((String)"   "));
        ConstTest.assertEquals((int)0, (int)Const.nrSpacesAfter((String)"test"));
        ConstTest.assertEquals((int)2, (int)Const.nrSpacesAfter((String)"test  "));
        ConstTest.assertEquals((int)0, (int)Const.nrSpacesAfter((String)"   test"));
        ConstTest.assertEquals((int)2, (int)Const.nrSpacesAfter((String)"    test  "));
    }

    public void testLtrim() {
        ConstTest.assertEquals(null, (String)Const.ltrim(null));
        ConstTest.assertEquals((String)"", (String)Const.ltrim((String)""));
        ConstTest.assertEquals((String)"", (String)Const.ltrim((String)"  "));
        ConstTest.assertEquals((String)"test ", (String)Const.ltrim((String)"test "));
        ConstTest.assertEquals((String)"test ", (String)Const.ltrim((String)"  test "));
    }

    public void testRtrim() {
        ConstTest.assertEquals(null, (String)Const.rtrim(null));
        ConstTest.assertEquals((String)"", (String)Const.rtrim((String)""));
        ConstTest.assertEquals((String)"", (String)Const.rtrim((String)"  "));
        ConstTest.assertEquals((String)"test", (String)Const.rtrim((String)"test "));
        ConstTest.assertEquals((String)"test ", (String)Const.ltrim((String)"  test "));
    }

    public void testTrim() {
        ConstTest.assertEquals(null, (String)Const.trim(null));
        ConstTest.assertEquals((String)"", (String)Const.trim((String)""));
        ConstTest.assertEquals((String)"", (String)Const.trim((String)"  "));
        ConstTest.assertEquals((String)"test", (String)Const.trim((String)"test "));
        ConstTest.assertEquals((String)"test", (String)Const.trim((String)"  test "));
    }

    public void testOnlySpaces() {
        try {
            Const.onlySpaces(null);
            ConstTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ConstTest.assertEquals((boolean)true, (boolean)Const.onlySpaces((String)""));
        ConstTest.assertEquals((boolean)true, (boolean)Const.onlySpaces((String)"  "));
        ConstTest.assertEquals((boolean)false, (boolean)Const.onlySpaces((String)"   test "));
    }

    public void testSplitString() {
        ConstTest.assertEquals((int)0, (int)Const.splitString((String)"", (String)";").length);
        ConstTest.assertEquals((int)0, (int)Const.splitString(null, (String)";").length);
        String[] a = Const.splitString((String)";;", (String)";");
        ConstTest.assertEquals((int)2, (int)a.length);
        ConstTest.assertEquals((String)"", (String)a[0]);
        ConstTest.assertEquals((String)"", (String)a[1]);
        a = Const.splitString((String)"a;b;c;d", (String)";");
        ConstTest.assertEquals((int)4, (int)a.length);
        ConstTest.assertEquals((String)"a", (String)a[0]);
        ConstTest.assertEquals((String)"b", (String)a[1]);
        ConstTest.assertEquals((String)"c", (String)a[2]);
        ConstTest.assertEquals((String)"d", (String)a[3]);
        a = Const.splitString((String)"a;b;c;d;", (String)";");
        ConstTest.assertEquals((int)4, (int)a.length);
        ConstTest.assertEquals((String)"a", (String)a[0]);
        ConstTest.assertEquals((String)"b", (String)a[1]);
        ConstTest.assertEquals((String)"c", (String)a[2]);
        ConstTest.assertEquals((String)"d", (String)a[3]);
        a = Const.splitString((String)"a;b;c;d;;", (String)";");
        ConstTest.assertEquals((int)5, (int)a.length);
        ConstTest.assertEquals((String)"a", (String)a[0]);
        ConstTest.assertEquals((String)"b", (String)a[1]);
        ConstTest.assertEquals((String)"c", (String)a[2]);
        ConstTest.assertEquals((String)"d", (String)a[3]);
        ConstTest.assertEquals((String)"", (String)a[4]);
        a = Const.splitString((String)"AACCAADAaAADD", (String)"AA");
        ConstTest.assertEquals((int)4, (int)a.length);
        ConstTest.assertEquals((String)"", (String)a[0]);
        ConstTest.assertEquals((String)"CC", (String)a[1]);
        ConstTest.assertEquals((String)"DA", (String)a[2]);
        ConstTest.assertEquals((String)"ADD", (String)a[3]);
        a = Const.splitString((String)"CCAABBAA", (String)"AA");
        ConstTest.assertEquals((int)2, (int)a.length);
        ConstTest.assertEquals((String)"CC", (String)a[0]);
        ConstTest.assertEquals((String)"BB", (String)a[1]);
    }

    public void testSplitStringChar() {
        ConstTest.assertEquals((int)0, (int)Const.splitString((String)"", (char)';').length);
        ConstTest.assertEquals((int)0, (int)Const.splitString(null, (char)';').length);
        String[] a = Const.splitString((String)";;", (char)';');
        ConstTest.assertEquals((int)2, (int)a.length);
        ConstTest.assertEquals((String)"", (String)a[0]);
        ConstTest.assertEquals((String)"", (String)a[1]);
        a = Const.splitString((String)"a;b;c;d", (char)';');
        ConstTest.assertEquals((int)4, (int)a.length);
        ConstTest.assertEquals((String)"a", (String)a[0]);
        ConstTest.assertEquals((String)"b", (String)a[1]);
        ConstTest.assertEquals((String)"c", (String)a[2]);
        ConstTest.assertEquals((String)"d", (String)a[3]);
        a = Const.splitString((String)"a;b;c;d;", (char)';');
        ConstTest.assertEquals((int)4, (int)a.length);
        ConstTest.assertEquals((String)"a", (String)a[0]);
        ConstTest.assertEquals((String)"b", (String)a[1]);
        ConstTest.assertEquals((String)"c", (String)a[2]);
        ConstTest.assertEquals((String)"d", (String)a[3]);
        a = Const.splitString((String)"a;b;c;d;;", (char)';');
        ConstTest.assertEquals((int)5, (int)a.length);
        ConstTest.assertEquals((String)"a", (String)a[0]);
        ConstTest.assertEquals((String)"b", (String)a[1]);
        ConstTest.assertEquals((String)"c", (String)a[2]);
        ConstTest.assertEquals((String)"d", (String)a[3]);
        ConstTest.assertEquals((String)"", (String)a[4]);
        a = Const.splitString((String)";CC;DA;ADD", (char)';');
        ConstTest.assertEquals((int)4, (int)a.length);
        ConstTest.assertEquals((String)"", (String)a[0]);
        ConstTest.assertEquals((String)"CC", (String)a[1]);
        ConstTest.assertEquals((String)"DA", (String)a[2]);
        ConstTest.assertEquals((String)"ADD", (String)a[3]);
        a = Const.splitString((String)"CC;BB;", (char)';');
        ConstTest.assertEquals((int)2, (int)a.length);
        ConstTest.assertEquals((String)"CC", (String)a[0]);
        ConstTest.assertEquals((String)"BB", (String)a[1]);
    }

    public void testSplitPath() {
        String[] a = Const.splitPath((String)"", (String)"/");
        ConstTest.assertEquals((int)0, (int)a.length);
        a = Const.splitPath(null, (String)"/");
        ConstTest.assertEquals((int)0, (int)a.length);
        a = Const.splitPath((String)"/", (String)"/");
        ConstTest.assertEquals((int)0, (int)a.length);
        a = Const.splitPath((String)"/level1", (String)"/");
        ConstTest.assertEquals((int)1, (int)a.length);
        ConstTest.assertEquals((String)"level1", (String)a[0]);
        a = Const.splitPath((String)"level1", (String)"/");
        ConstTest.assertEquals((int)1, (int)a.length);
        ConstTest.assertEquals((String)"level1", (String)a[0]);
        a = Const.splitPath((String)"/level1/level2", (String)"/");
        ConstTest.assertEquals((int)2, (int)a.length);
        ConstTest.assertEquals((String)"level1", (String)a[0]);
        ConstTest.assertEquals((String)"level2", (String)a[1]);
        a = Const.splitPath((String)"level1/level2", (String)"/");
        ConstTest.assertEquals((int)2, (int)a.length);
        ConstTest.assertEquals((String)"level1", (String)a[0]);
        ConstTest.assertEquals((String)"level2", (String)a[1]);
        a = Const.splitPath((String)"/level1/level2/lvl3", (String)"/");
        ConstTest.assertEquals((int)3, (int)a.length);
        ConstTest.assertEquals((String)"level1", (String)a[0]);
        ConstTest.assertEquals((String)"level2", (String)a[1]);
        ConstTest.assertEquals((String)"lvl3", (String)a[2]);
        a = Const.splitPath((String)"level1/level2/lvl3", (String)"/");
        ConstTest.assertEquals((int)3, (int)a.length);
        ConstTest.assertEquals((String)"level1", (String)a[0]);
        ConstTest.assertEquals((String)"level2", (String)a[1]);
        ConstTest.assertEquals((String)"lvl3", (String)a[2]);
    }
}

