/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;

public class KettleEnvironmentTest {
    private static final AtomicBoolean environmentInitCalled = new AtomicBoolean(false);
    private static final String pluginId = "MockLifecycleListener";

    private void resetKettleEnvironmentInitializationFlag() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = KettleEnvironment.class.getDeclaredField("initialized");
        f.setAccessible(true);
        f.set(KettleEnvironment.class, null);
    }

    @Test
    public void lifecycleListenerEnvironmentInitCallback() throws Exception {
        this.resetKettleEnvironmentInitializationFlag();
        Assert.assertFalse((String)"This test only works if the Kettle Environment is not yet initialized", (boolean)KettleEnvironment.isInitialized());
        System.setProperty("KETTLE_PLUGIN_CLASSES", MockLifecycleListener.class.getName());
        KettleEnvironment.init();
        PluginInterface pi = PluginRegistry.getInstance().findPluginWithId(KettleLifecyclePluginType.class, pluginId);
        MockLifecycleListener l = (MockLifecycleListener)PluginRegistry.getInstance().loadClass(pi, KettleLifecycleListener.class);
        Assert.assertNotNull((String)"Test plugin not registered properly", (Object)l);
        Assert.assertTrue((boolean)environmentInitCalled.get());
    }

    @Test
    public void lifecycleListenerEnvironmentInitCallback_exception_thrown() throws Exception {
        this.resetKettleEnvironmentInitializationFlag();
        Assert.assertFalse((String)"This test only works if the Kettle Environment is not yet initialized", (boolean)KettleEnvironment.isInitialized());
        System.setProperty("KETTLE_PLUGIN_CLASSES", FailingMockLifecycleListener.class.getName());
        KettleEnvironment.init();
        PluginInterface pi = PluginRegistry.getInstance().findPluginWithId(KettleLifecyclePluginType.class, pluginId);
        MockLifecycleListener l = (MockLifecycleListener)PluginRegistry.getInstance().loadClass(pi, KettleLifecycleListener.class);
        Assert.assertNotNull((String)"Test plugin not registered properly", (Object)l);
        Assert.assertTrue((boolean)environmentInitCalled.get());
        Assert.assertTrue((boolean)KettleEnvironment.isInitialized());
    }

    @Test
    public void lifecycleListenerEnvironmentInitCallback_exception_thrown_severe() throws Exception {
        this.resetKettleEnvironmentInitializationFlag();
        Assert.assertFalse((String)"This test only works if the Kettle Environment is not yet initialized", (boolean)KettleEnvironment.isInitialized());
        System.setProperty("KETTLE_PLUGIN_CLASSES", SevereFailingMockLifecycleListener.class.getName());
        try {
            KettleEnvironment.init();
            Assert.fail((String)"Expected exception");
        }
        catch (KettleException ex) {
            Assert.assertEquals(LifecycleException.class, ex.getCause().getClass());
        }
        Assert.assertFalse((boolean)KettleEnvironment.isInitialized());
    }

    @Test
    public void lifecycleListenerEnvironmentInitCallback_throwable_thrown() throws Exception {
        this.resetKettleEnvironmentInitializationFlag();
        Assert.assertFalse((String)"This test only works if the Kettle Environment is not yet initialized", (boolean)KettleEnvironment.isInitialized());
        System.setProperty("KETTLE_PLUGIN_CLASSES", ThrowableFailingMockLifecycleListener.class.getName());
        try {
            KettleEnvironment.init();
            Assert.fail((String)"Expected exception");
        }
        catch (KettleException ex) {
            Assert.assertEquals(AbstractMethodError.class, ex.getCause().getClass());
        }
        Assert.assertFalse((boolean)KettleEnvironment.isInitialized());
    }

    @KettleLifecyclePlugin(id="MockLifecycleListener")
    public static class ThrowableFailingMockLifecycleListener
    extends MockLifecycleListener {
        public void onEnvironmentInit() throws LifecycleException {
            throw new AbstractMethodError();
        }
    }

    @KettleLifecyclePlugin(id="MockLifecycleListener")
    public static class SevereFailingMockLifecycleListener
    extends MockLifecycleListener {
        public void onEnvironmentInit() throws LifecycleException {
            throw new LifecycleException(true);
        }
    }

    @KettleLifecyclePlugin(id="MockLifecycleListener")
    public static class FailingMockLifecycleListener
    extends MockLifecycleListener {
        public void onEnvironmentInit() throws LifecycleException {
            throw new LifecycleException(false);
        }
    }

    @KettleLifecyclePlugin(id="MockLifecycleListener")
    public static class MockLifecycleListener
    implements KettleLifecycleListener {
        public void onEnvironmentInit() throws LifecycleException {
            environmentInitCalled.set(true);
        }

        public void onEnvironmentShutdown() {
        }
    }
}

