/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import junit.framework.TestCase;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class RowSetTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ROWNR", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public void testBasicCreation() {
        BlockingRowSet set = new BlockingRowSet(10);
        RowSetTest.assertTrue((!set.isDone() ? 1 : 0) != 0);
        RowSetTest.assertEquals((int)0, (int)set.size());
    }

    public void testFuntionality1() {
        BlockingRowSet set = new BlockingRowSet(3);
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L)};
        Object[] r2 = new Object[]{new Long(2L)};
        Object[] r3 = new Object[]{new Long(3L)};
        Object[] r4 = new Object[]{new Long(4L)};
        Object[] r5 = new Object[]{new Long(5L)};
        RowSetTest.assertEquals((int)0, (int)set.size());
        set.putRow(rm, r1);
        RowSetTest.assertEquals((int)1, (int)set.size());
        set.putRow(rm, r2);
        RowSetTest.assertEquals((int)2, (int)set.size());
        Object[] r = set.getRow();
        int i = rm.indexOfValue("ROWNR");
        RowSetTest.assertEquals((long)1L, (long)((Long)r[i]));
        RowSetTest.assertEquals((int)1, (int)set.size());
        set.putRow(rm, r3);
        RowSetTest.assertEquals((int)2, (int)set.size());
        set.putRow(rm, r4);
        RowSetTest.assertEquals((int)3, (int)set.size());
        r = set.getRow();
        i = rm.indexOfValue("ROWNR");
        RowSetTest.assertEquals((long)2L, (long)((Long)r[i]));
        RowSetTest.assertEquals((int)2, (int)set.size());
        set.putRow(rm, r5);
        RowSetTest.assertEquals((int)3, (int)set.size());
        r = set.getRow();
        i = rm.indexOfValue("ROWNR");
        RowSetTest.assertEquals((long)3L, (long)((Long)r[i]));
        RowSetTest.assertEquals((int)2, (int)set.size());
        r = set.getRow();
        i = rm.indexOfValue("ROWNR");
        RowSetTest.assertEquals((long)4L, (long)((Long)r[i]));
        RowSetTest.assertEquals((int)1, (int)set.size());
        r = set.getRow();
        i = rm.indexOfValue("ROWNR");
        RowSetTest.assertEquals((long)5L, (long)((Long)r[i]));
        RowSetTest.assertEquals((int)0, (int)set.size());
    }

    public void testNames() {
        BlockingRowSet set = new BlockingRowSet(3);
        set.setThreadNameFromToCopy("from", 2, "to", 3);
        RowSetTest.assertEquals((String)"from", (String)set.getOriginStepName());
        RowSetTest.assertEquals((int)2, (int)set.getOriginStepCopy());
        RowSetTest.assertEquals((String)"to", (String)set.getDestinationStepName());
        RowSetTest.assertEquals((int)3, (int)set.getDestinationStepCopy());
        RowSetTest.assertEquals((String)set.toString(), (String)set.getName());
        RowSetTest.assertEquals((String)"from.2 - to.3", (String)set.getName());
    }
}

