/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;

public class DatabaseTest
extends TestCase {
    public static final String[] databasesXML = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>db</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database setupDatabase() throws Exception {
        Database database = null;
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        database = new Database((LoggingObjectInterface)transMeta, dbInfo);
        database.connect();
        return database;
    }

    public void testDatabaseCasing() throws Exception {
        String tableName = "mIxCaSiNG";
        Database db = this.setupDatabase();
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ID", 5), new ValueMeta("DLR_CD", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            valuesMeta[i].setLength(8);
            valuesMeta[i].setPrecision(0);
            rm.addValueMeta(valuesMeta[i]);
        }
        String createStatement = db.getCreateTableStatement(tableName, (RowMetaInterface)rm, null, false, null, true);
        db.execStatement(createStatement);
        DatabaseTest.assertFalse((boolean)tableName.equals(tableName.toLowerCase()));
        DatabaseTest.assertTrue((boolean)db.checkTableExists(tableName));
        DatabaseTest.assertEquals((boolean)false, (boolean)db.checkTableExists("unknown"));
        DatabaseTest.assertTrue((boolean)db.checkTableExists(tableName.toLowerCase()));
        db.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuoting() throws Exception {
        Database database = null;
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        database = new Database((LoggingObjectInterface)transMeta, dbInfo);
        database.connect();
        DatabaseTest.assertNull((Object)dbInfo.quoteField(null));
        DatabaseTest.assertEquals((String)"table1", (String)dbInfo.quoteField("table1"));
        DatabaseTest.assertEquals((String)"\"table 1\"", (String)dbInfo.quoteField("table 1"));
        DatabaseTest.assertEquals((String)"\"table-1\"", (String)dbInfo.quoteField("table-1"));
        DatabaseTest.assertEquals((String)"\"table+1\"", (String)dbInfo.quoteField("table+1"));
        DatabaseTest.assertEquals((String)"\"table.1\"", (String)dbInfo.quoteField("table.1"));
        DatabaseTest.assertNull((Object)dbInfo.getQuotedSchemaTableCombination(null, null));
        DatabaseTest.assertEquals((String)"table1", (String)dbInfo.getQuotedSchemaTableCombination(null, "table1"));
        DatabaseTest.assertEquals((String)"\"table 1\"", (String)dbInfo.getQuotedSchemaTableCombination(null, "table 1"));
        DatabaseTest.assertEquals((String)"\"table-1\"", (String)dbInfo.getQuotedSchemaTableCombination(null, "table-1"));
        DatabaseTest.assertEquals((String)"\"table+1\"", (String)dbInfo.getQuotedSchemaTableCombination(null, "table+1"));
        DatabaseTest.assertEquals((String)"\"table.1\"", (String)dbInfo.getQuotedSchemaTableCombination(null, "table.1"));
        DatabaseTest.assertEquals((String)"\"schema1\".\"null\"", (String)dbInfo.getQuotedSchemaTableCombination("schema1", null));
        DatabaseTest.assertEquals((String)"\"schema1\".\"table1\"", (String)dbInfo.getQuotedSchemaTableCombination("schema1", "table1"));
        DatabaseTest.assertEquals((String)"\"schema 1\".\"table 1\"", (String)dbInfo.getQuotedSchemaTableCombination("schema 1", "table 1"));
        DatabaseTest.assertEquals((String)"\"schema1\".\"table1\"", (String)dbInfo.getQuotedSchemaTableCombination("schema1", "\"table1\""));
        database.disconnect();
    }
}

