/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.exception.KettleFileException;

public class SQLStatementParserTest
extends TestCase {
    public void testParseStatements_simple() {
        BaseDatabaseMetaForTest dbMeta = new BaseDatabaseMetaForTest();
        String sqlScript = "SELECT FROM table;";
        List statements = dbMeta.parseStatements(sqlScript);
        SQLStatementParserTest.assertEquals((int)1, (int)statements.size());
        SQLStatementParserTest.assertEquals((String)sqlScript, (String)((String)statements.get(0)));
    }

    public void testParseStatements_simple_multiple() {
        BaseDatabaseMetaForTest dbMeta = new BaseDatabaseMetaForTest();
        String statement1 = "SELECT * FROM table";
        String statement2 = "SELECT * FROM table2";
        String sqlScript = statement1 + ";" + Const.CR + statement2 + "; ";
        List statements = dbMeta.parseStatements(sqlScript);
        SQLStatementParserTest.assertEquals((int)2, (int)statements.size());
        SQLStatementParserTest.assertEquals((String)statement1, (String)((String)statements.get(0)));
        SQLStatementParserTest.assertEquals((String)statement2, (String)((String)statements.get(1)));
    }

    public void testParseStatements_appostrophy_in_backticks() throws KettleFileException {
        BaseDatabaseMetaForTest dbMeta = new BaseDatabaseMetaForTest();
        String sqlScript = "CREATE TABLE sfdcom_test ( `Rep's Scoring` VARCHAR(255) );";
        List statements = dbMeta.parseStatements(sqlScript);
        SQLStatementParserTest.assertEquals((int)1, (int)statements.size());
        SQLStatementParserTest.assertEquals((String)sqlScript, (String)((String)statements.get(0)));
    }

    private class BaseDatabaseMetaForTest
    extends BaseDatabaseMeta {
        private BaseDatabaseMetaForTest() {
        }

        public int[] getAccessTypeList() {
            return null;
        }
    }
}

