/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.database.SqlCommentScrubber;

public class SqlCommentScrubberTest {
    String[][] testAndResultString = new String[][]{{"SELECT * FROM MYTABLE", "SELECT * FROM MYTABLE"}, {"SELECT * FROM\n-- Test 1\n MYTABLE;", "SELECT * FROM\n MYTABLE;"}, {"/* This \n is \n a multiline \n comment \n*/\nSELECT 1 FROM DUAL", "\nSELECT 1 FROM DUAL"}, {"SELECT 1 FROM\n/* This \n is \n a multiline \n comment \n*/\nDUAL", "SELECT 1 FROM\n\nDUAL"}, {"UPDATE table1 SET col1 = '----' WHERE col1 IS NULL;\nUPDATE table1 SET col2 = '-----' WHERE col2 IS NULL;\nUPDATE table1 SET col3 = '-----' WHERE col3 IS NULL;", "UPDATE table1 SET col1 = '----' WHERE col1 IS NULL;\nUPDATE table1 SET col2 = '-----' WHERE col2 IS NULL;\nUPDATE table1 SET col3 = '-----' WHERE col3 IS NULL;"}, {"TEST '/* comment in string */'", "TEST '/* comment in string */'"}, {"SELECT 'value-1' AS v1, 'value--1' AS v2;", "SELECT 'value-1' AS v1, 'value--1' AS v2;"}, {"SELECT \"value-1\" AS v1, \"value--1\" AS v2;", "SELECT \"value-1\" AS v1, \"value--1\" AS v2;"}, {"select transname \"Doesn't w--'ork\" from logs.log_trans limit 0,20000;", "select transname \"Doesn't w--'ork\" from logs.log_trans limit 0,20000;"}, {"select transname '\"hello--world\"' from --logs.log_trans", "select transname '\"hello--world\"' from "}, {"/* my comment which may have sql keywords in it such as function, procedure etc. Seems to cause issues within\ncomments.\n*/\n\nif exists ( some query)\ndrop view myView;\n\ncreate view myView as\nselect query here ", "\n\nif exists ( some query)\ndrop view myView;\n\ncreate view myView as\nselect query here "}, {"/*\n' my comment\n' more comment\n' a third line of the comment.\n*/", ""}, {null, null}, {"", ""}};

    @Test
    public void testRemoveComments() {
        for (String[] testSet : this.testAndResultString) {
            Assert.assertEquals((Object)SqlCommentScrubber.removeComments((String)testSet[0]), (Object)testSet[1]);
        }
    }
}

