/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.encryption;

import junit.framework.TestCase;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleValueException;

public class EncrTest
extends TestCase {
    public void testEncryptPassword() throws KettleValueException {
        String encryption = Encr.encryptPassword(null);
        EncrTest.assertTrue((boolean)"".equals(encryption));
        encryption = Encr.encryptPassword((String)"");
        EncrTest.assertTrue((boolean)"".equals(encryption));
        encryption = Encr.encryptPassword((String)"     ");
        EncrTest.assertTrue((boolean)"2be98afc86aa7f2e4cb79ce309ed2ef9a".equals(encryption));
        encryption = Encr.encryptPassword((String)"Test of different encryptions!!@#$%");
        EncrTest.assertTrue((boolean)"54657374206f6620646966666572656e742067d0fbddb11ad39b8ba50aef31fed1eb9f".equals(encryption));
        encryption = Encr.encryptPassword((String)"  Spaces left");
        EncrTest.assertTrue((boolean)"2be98afe84af48285a81cbd30d297a9ce".equals(encryption));
        encryption = Encr.encryptPassword((String)"Spaces right");
        EncrTest.assertTrue((boolean)"2be98afc839d79387ae0aee62d795a7ce".equals(encryption));
        encryption = Encr.encryptPassword((String)"     Spaces  ");
        EncrTest.assertTrue((boolean)"2be98afe84a87d2c49809af73db81ef9a".equals(encryption));
        encryption = Encr.encryptPassword((String)"1234567890");
        EncrTest.assertTrue((boolean)"2be98afc86aa7c3d6f84dfb2689caf68a".equals(encryption));
    }

    public void testDecryptPassword() throws KettleValueException {
        String encryption = Encr.encryptPassword(null);
        String decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"".equals(decryption));
        encryption = Encr.encryptPassword((String)"");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"".equals(decryption));
        encryption = Encr.encryptPassword((String)"     ");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"     ".equals(decryption));
        encryption = Encr.encryptPassword((String)"Test of different encryptions!!@#$%");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"Test of different encryptions!!@#$%".equals(decryption));
        encryption = Encr.encryptPassword((String)"  Spaces left");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"  Spaces left".equals(decryption));
        encryption = Encr.encryptPassword((String)"Spaces right");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"Spaces right".equals(decryption));
        encryption = Encr.encryptPassword((String)"     Spaces  ");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"     Spaces  ".equals(decryption));
        encryption = Encr.encryptPassword((String)"1234567890");
        decryption = Encr.decryptPassword((String)encryption);
        EncrTest.assertTrue((boolean)"1234567890".equals(decryption));
    }

    public void testEncryptPasswordIfNotUsingVariables() throws KettleValueException {
        String encryption = Encr.encryptPasswordIfNotUsingVariables(null);
        EncrTest.assertTrue((boolean)"Encrypted ".equals(encryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)"");
        EncrTest.assertTrue((boolean)"Encrypted ".equals(encryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)"String");
        EncrTest.assertTrue((boolean)"Encrypted 2be98afc86aa7f2e4cb799d64cc9ba1dd".equals(encryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)" ${VAR} String");
        EncrTest.assertTrue((boolean)" ${VAR} String".equals(encryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)" %%VAR%% String");
        EncrTest.assertTrue((boolean)" %%VAR%% String".equals(encryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)" %% VAR String");
        EncrTest.assertTrue((boolean)"Encrypted 2be988fed4f87a4a599599d64cc9ba1dd".equals(encryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)"${%%$$$$");
        EncrTest.assertTrue((boolean)"Encrypted 2be98afc86aa7f2e4ef02eb359ad6eb9e".equals(encryption));
    }

    public void testDecryptPasswordIfNotUsingVariables() throws KettleValueException {
        String encryption = Encr.encryptPasswordIfNotUsingVariables(null);
        String decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)"".equals(decryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)"");
        decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)"".equals(decryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)"String");
        decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)"String".equals(decryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)" ${VAR} String");
        decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)" ${VAR} String".equals(decryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)" %%VAR%% String");
        decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)" %%VAR%% String".equals(decryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)" %% VAR String");
        decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)" %% VAR String".equals(decryption));
        encryption = Encr.encryptPasswordIfNotUsingVariables((String)"${%%$$$$");
        decryption = Encr.decryptPasswordOptionallyEncrypted((String)encryption);
        EncrTest.assertTrue((boolean)"${%%$$$$".equals(decryption));
    }
}

