/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.logging.KettleLogChannelAppender;
import org.pentaho.di.core.logging.Log4jKettleLayout;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;

public class KettleLogChannelAppenderTest {
    @Test(expected=NullPointerException.class)
    public void instantiation_null_logging_channel() {
        new KettleLogChannelAppender(null, (Layout)new Log4jKettleLayout());
    }

    @Test(expected=NullPointerException.class)
    public void instantiation_null_layout() {
        new KettleLogChannelAppender((LogChannelInterface)new MockLoggingChannel(), null);
    }

    @Test
    public void requiresLayout() {
        KettleLogChannelAppender appender = new KettleLogChannelAppender((LogChannelInterface)new MockLoggingChannel());
        Assert.assertTrue((boolean)appender.requiresLayout());
    }

    @Test
    public void append_basic() {
        MockLoggingChannel log = new MockLoggingChannel();
        KettleLogChannelAppender appender = new KettleLogChannelAppender((LogChannelInterface)log);
        Logger testLogger = Logger.getLogger(this.getClass());
        testLogger.setLevel(Level.ALL);
        Log4jKettleLayout layout = new Log4jKettleLayout();
        LoggingEvent infoEvent = new LoggingEvent("org.test", (Category)testLogger, Priority.INFO, (Object)"Testing Info", null);
        LoggingEvent warnEvent = new LoggingEvent("org.test", (Category)testLogger, Priority.WARN, (Object)"Testing Warning", null);
        LoggingEvent allEvent = new LoggingEvent("org.test", (Category)testLogger, Priority.toPriority((int)Integer.MIN_VALUE), (Object)"Testing All", null);
        appender.doAppend(infoEvent);
        appender.doAppend(warnEvent);
        appender.doAppend(allEvent);
        Assert.assertEquals((long)0L, (long)log.getDebugMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDetailedMessages().size());
        Assert.assertEquals((long)0L, (long)log.getErrorMessages().size());
        Assert.assertEquals((long)0L, (long)log.getMinimalMessages().size());
        Assert.assertEquals((long)0L, (long)log.getRowLevelMessages().size());
        Assert.assertEquals((long)3L, (long)log.getBasicMessages().size());
        Assert.assertEquals((Object)layout.format(infoEvent), (Object)log.getBasicMessages().get(0).getMessage());
        Assert.assertEquals((Object)layout.format(warnEvent), (Object)log.getBasicMessages().get(1).getMessage());
        Assert.assertEquals((Object)layout.format(allEvent), (Object)log.getBasicMessages().get(2).getMessage());
    }

    @Test
    public void append_debug() {
        MockLoggingChannel log = new MockLoggingChannel();
        KettleLogChannelAppender appender = new KettleLogChannelAppender((LogChannelInterface)log);
        Logger testLogger = Logger.getLogger(this.getClass());
        testLogger.setLevel(Level.ALL);
        Log4jKettleLayout layout = new Log4jKettleLayout();
        LoggingEvent event = new LoggingEvent("org.test", (Category)testLogger, Priority.DEBUG, (Object)"debug test!", null);
        appender.doAppend(event);
        Assert.assertEquals((long)0L, (long)log.getBasicMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDetailedMessages().size());
        Assert.assertEquals((long)0L, (long)log.getErrorMessages().size());
        Assert.assertEquals((long)0L, (long)log.getMinimalMessages().size());
        Assert.assertEquals((long)0L, (long)log.getRowLevelMessages().size());
        Assert.assertEquals((long)1L, (long)log.getDebugMessages().size());
        Assert.assertEquals((Object)layout.format(event), (Object)log.getDebugMessages().get(0).getMessage());
    }

    @Test
    public void append_trace() {
        MockLoggingChannel log = new MockLoggingChannel();
        KettleLogChannelAppender appender = new KettleLogChannelAppender((LogChannelInterface)log);
        Logger testLogger = Logger.getLogger(this.getClass());
        testLogger.setLevel(Level.ALL);
        Log4jKettleLayout layout = new Log4jKettleLayout();
        LoggingEvent event = new LoggingEvent("org.test", (Category)testLogger, Priority.toPriority((int)5000), (Object)"trace test!", null);
        appender.doAppend(event);
        Assert.assertEquals((long)0L, (long)log.getBasicMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDetailedMessages().size());
        Assert.assertEquals((long)0L, (long)log.getErrorMessages().size());
        Assert.assertEquals((long)0L, (long)log.getMinimalMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDebugMessages().size());
        Assert.assertEquals((long)1L, (long)log.getRowLevelMessages().size());
        Assert.assertEquals((Object)layout.format(event), (Object)log.getRowLevelMessages().get(0).getMessage());
    }

    @Test
    public void append_off() {
        MockLoggingChannel log = new MockLoggingChannel();
        KettleLogChannelAppender appender = new KettleLogChannelAppender((LogChannelInterface)log);
        Logger testLogger = Logger.getLogger(this.getClass());
        testLogger.setLevel(Level.ALL);
        Log4jKettleLayout layout = new Log4jKettleLayout();
        LoggingEvent event = new LoggingEvent("org.test", (Category)testLogger, Priority.toPriority((int)Integer.MAX_VALUE), (Object)"off test!", null);
        appender.doAppend(event);
        Assert.assertEquals((long)0L, (long)log.getBasicMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDetailedMessages().size());
        Assert.assertEquals((long)0L, (long)log.getErrorMessages().size());
        Assert.assertEquals((long)0L, (long)log.getRowLevelMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDebugMessages().size());
        Assert.assertEquals((long)1L, (long)log.getMinimalMessages().size());
        Assert.assertEquals((Object)layout.format(event), (Object)log.getMinimalMessages().get(0).getMessage());
    }

    @Test
    public void append_error() {
        MockLoggingChannel log = new MockLoggingChannel();
        KettleLogChannelAppender appender = new KettleLogChannelAppender((LogChannelInterface)log);
        Logger testLogger = Logger.getLogger(this.getClass());
        testLogger.setLevel(Level.ALL);
        Log4jKettleLayout layout = new Log4jKettleLayout();
        LoggingEvent errorEvent1 = new LoggingEvent("org.test", (Category)testLogger, Priority.ERROR, (Object)"Testing", null);
        Exception errorException = new Exception("something went wrong!");
        LoggingEvent errorEvent2 = new LoggingEvent("org.test", (Category)testLogger, Priority.ERROR, (Object)"Testing", (Throwable)errorException);
        LoggingEvent fatalEvent1 = new LoggingEvent("org.test", (Category)testLogger, Priority.FATAL, (Object)"Testing", null);
        Exception fatalException = new Exception("something went fatally wrong!");
        LoggingEvent fatalEvent2 = new LoggingEvent("org.test", (Category)testLogger, Priority.FATAL, (Object)"Testing", (Throwable)fatalException);
        appender.doAppend(errorEvent1);
        appender.doAppend(errorEvent2);
        appender.doAppend(fatalEvent1);
        appender.doAppend(fatalEvent2);
        Assert.assertEquals((long)0L, (long)log.getDebugMessages().size());
        Assert.assertEquals((long)0L, (long)log.getDetailedMessages().size());
        Assert.assertEquals((long)0L, (long)log.getBasicMessages().size());
        Assert.assertEquals((long)0L, (long)log.getMinimalMessages().size());
        Assert.assertEquals((long)0L, (long)log.getRowLevelMessages().size());
        Assert.assertEquals((long)4L, (long)log.getErrorMessages().size());
        Assert.assertEquals((Object)layout.format(errorEvent1), (Object)log.getErrorMessages().get(0).getMessage());
        Assert.assertEquals((Object)layout.format(errorEvent1), (Object)log.getErrorMessages().get(1).getMessage());
        Assert.assertEquals((Object)errorException, (Object)log.getErrorMessages().get(1).getThrowable());
        Assert.assertEquals((Object)layout.format(fatalEvent1), (Object)log.getErrorMessages().get(2).getMessage());
        Assert.assertEquals((Object)layout.format(fatalEvent2), (Object)log.getErrorMessages().get(3).getMessage());
        Assert.assertEquals((Object)fatalException, (Object)log.getErrorMessages().get(3).getThrowable());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockLoggingChannel
    implements LogChannelInterface {
        private List<MessageObject> minimal = new ArrayList<MessageObject>();
        private List<MessageObject> basic = new ArrayList<MessageObject>();
        private List<MessageObject> detailed = new ArrayList<MessageObject>();
        private List<MessageObject> debug = new ArrayList<MessageObject>();
        private List<MessageObject> rowLevel = new ArrayList<MessageObject>();
        private List<MessageObject> error = new ArrayList<MessageObject>();

        private MockLoggingChannel() {
        }

        public String getLogChannelId() {
            return null;
        }

        public LogLevel getLogLevel() {
            return null;
        }

        public void setLogLevel(LogLevel logLevel) {
        }

        public String getContainerObjectId() {
            return null;
        }

        public void setContainerObjectId(String containerObjectId) {
        }

        public boolean isBasic() {
            return false;
        }

        public boolean isDetailed() {
            return false;
        }

        public boolean isDebug() {
            return false;
        }

        public boolean isRowLevel() {
            return false;
        }

        public boolean isError() {
            return false;
        }

        public void logMinimal(String message) {
            this.minimal.add(new MessageObject(message, null, null));
        }

        public void logMinimal(String message, Object ... arguments) {
            this.minimal.add(new MessageObject(message, arguments, null));
        }

        public void logBasic(String message) {
            this.basic.add(new MessageObject(message, null, null));
        }

        public void logBasic(String message, Object ... arguments) {
            this.basic.add(new MessageObject(message, arguments, null));
        }

        public void logDetailed(String message) {
            this.detailed.add(new MessageObject(message, null, null));
        }

        public void logDetailed(String message, Object ... arguments) {
            this.detailed.add(new MessageObject(message, arguments, null));
        }

        public void logDebug(String message) {
            this.debug.add(new MessageObject(message, null, null));
        }

        public void logDebug(String message, Object ... arguments) {
            this.debug.add(new MessageObject(message, arguments, null));
        }

        public void logRowlevel(String message) {
            this.rowLevel.add(new MessageObject(message, null, null));
        }

        public void logRowlevel(String message, Object ... arguments) {
            this.rowLevel.add(new MessageObject(message, arguments, null));
        }

        public void logError(String message) {
            this.error.add(new MessageObject(message, null, null));
        }

        public void logError(String message, Throwable e) {
            this.error.add(new MessageObject(message, null, e));
        }

        public void logError(String message, Object ... arguments) {
            this.error.add(new MessageObject(message, arguments, null));
        }

        public List<MessageObject> getMinimalMessages() {
            return this.minimal;
        }

        public List<MessageObject> getBasicMessages() {
            return this.basic;
        }

        public List<MessageObject> getDetailedMessages() {
            return this.detailed;
        }

        public List<MessageObject> getDebugMessages() {
            return this.debug;
        }

        public List<MessageObject> getRowLevelMessages() {
            return this.rowLevel;
        }

        public List<MessageObject> getErrorMessages() {
            return this.error;
        }
    }

    private class MessageObject {
        private String message;
        private Object[] args;
        private Throwable throwable;

        private MessageObject(String message, Object[] args, Throwable throwable) {
            this.message = message;
            this.args = args;
            this.throwable = throwable;
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

