/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.parameters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.getvariable.GetVariableMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSimpleTransTest
extends TestCase {
    public RowMetaInterface createResultRowMetaInterface1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("PARAM1", 2), new ValueMeta("PARAM2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface1();
        Object[] r1 = new Object[]{"ParamValue1", "PARAMVALUE2"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface2() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("PARAM1", 2), new ValueMeta("PARAM2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface2();
        Object[] r1 = new Object[]{"ParamValue1", "default2"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface3() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("${JAVA_HOME}", 2), new ValueMeta("PARAM2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData3() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface3();
        Object[] r1 = new Object[]{"${JAVA_HOME}", "default2"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface5() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("PARAM1", 2), new ValueMeta("PARAM2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData5() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface5();
        Object[] r1 = new Object[]{"default1", "PARAMVALUE2"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface6() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("PARAM1", 2), new ValueMeta("PARAM2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData6() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface5();
        Object[] r1 = new Object[]{"", "PARAMVALUE2"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            ParameterSimpleTransTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                ParameterSimpleTransTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    ParameterSimpleTransTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                ParameterSimpleTransTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testParameterSimpleTrans1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("parameter_simple_trans1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String getVariablesStepname = "get variables step";
        GetVariableMeta gvm = new GetVariableMeta();
        String getVariablesPid = registry.getPluginId(StepPluginType.class, (Object)gvm);
        StepMeta getVariablesStep = new StepMeta(getVariablesPid, getVariablesStepname, (StepMetaInterface)gvm);
        transMeta.addStep(getVariablesStep);
        String[] fieldName = new String[]{"PARAM1", "PARAM2"};
        String[] varName = new String[]{"${Param1}", "%%PARAM2%%"};
        int[] fieldType = new int[]{2, 2};
        int[] length = new int[]{-1, -1};
        int[] precision = new int[]{-1, -1};
        String[] format = new String[]{"", ""};
        String[] currency = new String[]{"", ""};
        String[] decimal = new String[]{"", ""};
        String[] grouping = new String[]{"", ""};
        int[] trimType = new int[]{0, 0};
        gvm.setFieldName(fieldName);
        gvm.setVariableString(varName);
        gvm.setFieldType(fieldType);
        gvm.setFieldLength(length);
        gvm.setFieldPrecision(precision);
        gvm.setFieldFormat(format);
        gvm.setCurrency(currency);
        gvm.setDecimal(decimal);
        gvm.setGroup(grouping);
        gvm.setTrimType(trimType);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getVariablesStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.addParameterDefinition("Param1", "", "Parameter 1");
        trans.addParameterDefinition("PARAM2", "", "Parameter 2");
        trans.setParameterValue("Param1", "ParamValue1");
        trans.setParameterValue("PARAM2", "PARAMVALUE2");
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }

    public void testParameterSimpleTrans2() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("parameter_simple_trans2");
        PluginRegistry registry = PluginRegistry.getInstance();
        String getVariablesStepname = "get variables step";
        GetVariableMeta gvm = new GetVariableMeta();
        String getVariablesPid = registry.getPluginId(StepPluginType.class, (Object)gvm);
        StepMeta getVariablesStep = new StepMeta(getVariablesPid, getVariablesStepname, (StepMetaInterface)gvm);
        transMeta.addStep(getVariablesStep);
        String[] fieldName = new String[]{"Param1", "PARAM2"};
        String[] varName = new String[]{"${Param1}", "%%PARAM2%%"};
        int[] fieldType = new int[]{2, 2};
        int[] length = new int[]{-1, -1};
        int[] precision = new int[]{-1, -1};
        String[] format = new String[]{"", ""};
        String[] currency = new String[]{"", ""};
        String[] decimal = new String[]{"", ""};
        String[] grouping = new String[]{"", ""};
        int[] trimType = new int[]{0, 0};
        gvm.setFieldName(fieldName);
        gvm.setVariableString(varName);
        gvm.setFieldType(fieldType);
        gvm.setFieldLength(length);
        gvm.setFieldPrecision(precision);
        gvm.setFieldFormat(format);
        gvm.setCurrency(currency);
        gvm.setDecimal(decimal);
        gvm.setGroup(grouping);
        gvm.setTrimType(trimType);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getVariablesStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.addParameterDefinition("Param1", "default1", "Parameter 1");
        trans.addParameterDefinition("PARAM2", "default2", "Parameter 2");
        trans.setParameterValue("Param1", "ParamValue1");
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData2();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }

    public void testParameterSimpleTrans3() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("parameter_simple_trans3");
        PluginRegistry registry = PluginRegistry.getInstance();
        String getVariablesStepname = "get variables step";
        GetVariableMeta gvm = new GetVariableMeta();
        String getVariablesPid = registry.getPluginId(StepPluginType.class, (Object)gvm);
        StepMeta getVariablesStep = new StepMeta(getVariablesPid, getVariablesStepname, (StepMetaInterface)gvm);
        transMeta.addStep(getVariablesStep);
        String[] fieldName = new String[]{"PARAM1", "PARAM2"};
        String[] varName = new String[]{"${JAVA_HOME}", "%%PARAM2%%"};
        int[] fieldType = new int[]{2, 2};
        int[] length = new int[]{-1, -1};
        int[] precision = new int[]{-1, -1};
        String[] format = new String[]{"", ""};
        String[] currency = new String[]{"", ""};
        String[] decimal = new String[]{"", ""};
        String[] grouping = new String[]{"", ""};
        int[] trimType = new int[]{0, 0};
        gvm.setFieldName(fieldName);
        gvm.setVariableString(varName);
        gvm.setFieldType(fieldType);
        gvm.setFieldLength(length);
        gvm.setFieldPrecision(precision);
        gvm.setFieldFormat(format);
        gvm.setCurrency(currency);
        gvm.setDecimal(decimal);
        gvm.setGroup(grouping);
        gvm.setTrimType(trimType);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getVariablesStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.addParameterDefinition("${JAVA_HOME}", "default1", "Parameter 1");
        trans.addParameterDefinition("PARAM2", "default2", "Parameter 2");
        trans.setParameterValue("${JAVA_HOME}", "param1");
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData3();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }

    public void testParameterSimpleTrans4() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("parameter_simple_trans4");
        PluginRegistry registry = PluginRegistry.getInstance();
        String getVariablesStepname = "get variables step";
        GetVariableMeta gvm = new GetVariableMeta();
        String getVariablesPid = registry.getPluginId(StepPluginType.class, (Object)gvm);
        StepMeta getVariablesStep = new StepMeta(getVariablesPid, getVariablesStepname, (StepMetaInterface)gvm);
        transMeta.addStep(getVariablesStep);
        String[] fieldName = new String[]{"PARAM1", "PARAM2"};
        String[] varName = new String[]{"${Param1}", "%%PARAM2%%"};
        int[] fieldType = new int[]{2, 2};
        int[] length = new int[]{-1, -1};
        int[] precision = new int[]{-1, -1};
        String[] format = new String[]{"", ""};
        String[] currency = new String[]{"", ""};
        String[] decimal = new String[]{"", ""};
        String[] grouping = new String[]{"", ""};
        int[] trimType = new int[]{0, 0};
        gvm.setFieldName(fieldName);
        gvm.setVariableString(varName);
        gvm.setFieldType(fieldType);
        gvm.setFieldLength(length);
        gvm.setFieldPrecision(precision);
        gvm.setFieldFormat(format);
        gvm.setCurrency(currency);
        gvm.setDecimal(decimal);
        gvm.setGroup(grouping);
        gvm.setTrimType(trimType);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getVariablesStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.addParameterDefinition("Param1", "", "Parameter 1");
        trans.addParameterDefinition("PARAM2", "", "Parameter 2");
        trans.setParameterValue("Param1", "ParamValue1");
        trans.setParameterValue("PARAM2", "PARAMVALUE2");
        trans.setVariable("Param1", "Variable1");
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }

    public void testParameterSimpleTrans5() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("parameter_simple_trans4");
        PluginRegistry registry = PluginRegistry.getInstance();
        String getVariablesStepname = "get variables step";
        GetVariableMeta gvm = new GetVariableMeta();
        String getVariablesPid = registry.getPluginId(StepPluginType.class, (Object)gvm);
        StepMeta getVariablesStep = new StepMeta(getVariablesPid, getVariablesStepname, (StepMetaInterface)gvm);
        transMeta.addStep(getVariablesStep);
        String[] fieldName = new String[]{"PARAM1", "PARAM2"};
        String[] varName = new String[]{"${Param1}", "%%PARAM2%%"};
        int[] fieldType = new int[]{2, 2};
        int[] length = new int[]{-1, -1};
        int[] precision = new int[]{-1, -1};
        String[] format = new String[]{"", ""};
        String[] currency = new String[]{"", ""};
        String[] decimal = new String[]{"", ""};
        String[] grouping = new String[]{"", ""};
        int[] trimType = new int[]{0, 0};
        gvm.setFieldName(fieldName);
        gvm.setVariableString(varName);
        gvm.setFieldType(fieldType);
        gvm.setFieldLength(length);
        gvm.setFieldPrecision(precision);
        gvm.setFieldFormat(format);
        gvm.setCurrency(currency);
        gvm.setDecimal(decimal);
        gvm.setGroup(grouping);
        gvm.setTrimType(trimType);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getVariablesStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.addParameterDefinition("Param1", "default1", "Parameter 1");
        trans.addParameterDefinition("PARAM2", "", "Parameter 2");
        trans.setParameterValue("PARAM2", "PARAMVALUE2");
        trans.setVariable("Param1", "Variable1");
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData5();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }

    public void testParameterSimpleTrans6() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("parameter_simple_trans4");
        PluginRegistry registry = PluginRegistry.getInstance();
        String getVariablesStepname = "get variables step";
        GetVariableMeta gvm = new GetVariableMeta();
        String getVariablesPid = registry.getPluginId(StepPluginType.class, (Object)gvm);
        StepMeta getVariablesStep = new StepMeta(getVariablesPid, getVariablesStepname, (StepMetaInterface)gvm);
        transMeta.addStep(getVariablesStep);
        String[] fieldName = new String[]{"PARAM1", "PARAM2"};
        String[] varName = new String[]{"${Param1}", "%%PARAM2%%"};
        int[] fieldType = new int[]{2, 2};
        int[] length = new int[]{-1, -1};
        int[] precision = new int[]{-1, -1};
        String[] format = new String[]{"", ""};
        String[] currency = new String[]{"", ""};
        String[] decimal = new String[]{"", ""};
        String[] grouping = new String[]{"", ""};
        int[] trimType = new int[]{0, 0};
        gvm.setFieldName(fieldName);
        gvm.setVariableString(varName);
        gvm.setFieldType(fieldType);
        gvm.setFieldLength(length);
        gvm.setFieldPrecision(precision);
        gvm.setFieldFormat(format);
        gvm.setCurrency(currency);
        gvm.setDecimal(decimal);
        gvm.setGroup(grouping);
        gvm.setTrimType(trimType);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getVariablesStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.addParameterDefinition("Param1", "", "Parameter 1");
        trans.addParameterDefinition("PARAM2", "", "Parameter 2");
        trans.setParameterValue("PARAM2", "PARAMVALUE2");
        trans.setVariable("Param1", "Variable1");
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData6();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }
}

