/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PartitionerPluginType;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.di.ui.repository.dialog.RepositoryRevisionBrowserDialogInterface;

public class PluginRegistryTest
extends TestCase {
    private static final String PLUGIN_INPUT_CATEGORY = "Input";
    private static final String PLUGIN_OUTPUT_CATEGORY = "Output";
    private static final String TABLE_INPUT_PLUGIN_ID = "TableInput";
    private static final String TABLE_INPUT_PLUGIN_NAME = "Table Input";
    private static final String TABLE_INPUT_PLUGIN_DESCRIPTION = "The table input step";
    private static final String TABLE_INPUT_PLUGIN_IMAGE_FILE_NAME = "/ui/images/TIN.png";
    private static final String TABLE_OUTPUT_PLUGIN_ID = "TableOutput";
    private static final String TABLE_OUTPUT_PLUGIN_NAME = "Table Output";
    private static final String TABLE_OUTPUT_PLUGIN_DESCRIPTION = "The table output step";
    private static final String TABLE_OUTPUT_PLUGIN_IMAGE_FILE_NAME = "/ui/images/TOP.png";

    public void testPluginRegistry() throws KettlePluginException {
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginRegistryTest.assertNotNull((String)"Registry singleton was not found!", (Object)registry);
        Class<StepPluginType> pluginType = StepPluginType.class;
        registry.registerPluginType(pluginType);
        List pluginTypes = registry.getPluginTypes();
        PluginRegistryTest.assertEquals((String)"One plugin type expected in the registry", (int)1, (int)pluginTypes.size());
        HashMap<Class, String> classMap = new HashMap<Class, String>();
        classMap.put(TableInputMeta.class, "org.pentaho.di.trans.steps.tableinput.TableInputMeta");
        Plugin tableInputPlugin = new Plugin(new String[]{TABLE_INPUT_PLUGIN_ID}, pluginType, StepMetaInterface.class, PLUGIN_INPUT_CATEGORY, TABLE_INPUT_PLUGIN_NAME, TABLE_INPUT_PLUGIN_DESCRIPTION, TABLE_INPUT_PLUGIN_IMAGE_FILE_NAME, false, true, classMap, new ArrayList(), null, null);
        registry.registerPlugin(pluginType, (PluginInterface)tableInputPlugin);
        List stepPlugins = registry.getPlugins(pluginType);
        PluginRegistryTest.assertEquals((String)"Size of plugins list expected to be 1", (int)1, (int)stepPlugins.size());
        PluginInterface verify = registry.getPlugin(pluginType, TABLE_INPUT_PLUGIN_ID);
        PluginRegistryTest.assertNotNull((String)"A plugin was not found in the plugin registry", (Object)verify);
        PluginRegistryTest.assertEquals((String)"A different plugin then expected was retrieved from the plugin registry", (Object)verify, (Object)tableInputPlugin);
        classMap = new HashMap();
        classMap.put(TableOutputMeta.class, "org.pentaho.di.trans.steps.tableoutput.TableOutputMeta");
        Plugin tableOutputPlugin = new Plugin(new String[]{TABLE_OUTPUT_PLUGIN_ID}, pluginType, StepMetaInterface.class, PLUGIN_OUTPUT_CATEGORY, TABLE_OUTPUT_PLUGIN_NAME, TABLE_OUTPUT_PLUGIN_DESCRIPTION, TABLE_OUTPUT_PLUGIN_IMAGE_FILE_NAME, false, true, classMap, new ArrayList(), null, null);
        registry.registerPlugin(pluginType, (PluginInterface)tableOutputPlugin);
        stepPlugins = registry.getPlugins(pluginType);
        PluginRegistryTest.assertEquals((String)"Size of plugins list expected to be 2", (int)2, (int)stepPlugins.size());
        verify = registry.getPlugin(pluginType, TABLE_OUTPUT_PLUGIN_ID);
        PluginRegistryTest.assertNotNull((String)"A plugin was not found in the plugin registry", (Object)verify);
        PluginRegistryTest.assertEquals((String)"A different plugin then expected was retrieved from the plugin registry", (Object)verify, (Object)tableOutputPlugin);
        List inputPlugins = registry.getPluginsByCategory(pluginType, PLUGIN_INPUT_CATEGORY);
        PluginRegistryTest.assertEquals((String)"Exactly one plugin expected in the step plugin input category", (int)1, (int)inputPlugins.size());
        PluginRegistryTest.assertEquals((String)"The table input step was expected in the input category", inputPlugins.get(0), (Object)tableInputPlugin);
        PluginRegistryTest.assertTrue((String)"Input plugins list should contain the table input step", (boolean)inputPlugins.contains(tableInputPlugin));
        PluginRegistryTest.assertFalse((String)"Input plugins list should not contain the table output step", (boolean)inputPlugins.contains(tableOutputPlugin));
        List outputPlugins = registry.getPluginsByCategory(pluginType, PLUGIN_OUTPUT_CATEGORY);
        PluginRegistryTest.assertEquals((String)"Exactly one plugin expected in the step plugin output category", (int)1, (int)outputPlugins.size());
        PluginRegistryTest.assertEquals((String)"The table output step was expected in the otuput category", outputPlugins.get(0), (Object)tableOutputPlugin);
        PluginRegistryTest.assertTrue((String)"Output plugins list should contain the table output step", (boolean)outputPlugins.contains(tableOutputPlugin));
        PluginRegistryTest.assertFalse((String)"Output plugins list should not contain the table input step", (boolean)outputPlugins.contains(tableInputPlugin));
        List categories = registry.getCategories(pluginType);
        PluginRegistryTest.assertEquals((String)"Two categories expected in the step plugin registry", (int)2, (int)categories.size());
        PluginRegistryTest.assertTrue((String)"The input category was expected in the categories list", (boolean)categories.contains(PLUGIN_INPUT_CATEGORY));
        PluginRegistryTest.assertTrue((String)"The output category was expected in the categories list", (boolean)categories.contains(PLUGIN_OUTPUT_CATEGORY));
        Object object = registry.loadClass((PluginInterface)tableInputPlugin, TableInputMeta.class);
        PluginRegistryTest.assertNotNull((Object)object);
        PluginRegistryTest.assertTrue((boolean)(object instanceof TableInputMeta));
        Object object2 = registry.loadClass((PluginInterface)tableOutputPlugin, TableOutputMeta.class);
        PluginRegistryTest.assertNotNull((Object)object2);
        PluginRegistryTest.assertTrue((boolean)(object2 instanceof TableOutputMeta));
        try {
            registry.loadClass((PluginInterface)tableInputPlugin, RepositoryRevisionBrowserDialogInterface.class);
            PluginRegistryTest.fail((String)"A repository browser plugin class type can't be used when loading a step class");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testPluginRegistryInit() throws KettlePluginException {
        PluginTypeInterface[] plugins;
        for (PluginTypeInterface pl : plugins = new PluginTypeInterface[]{StepPluginType.getInstance(), PartitionerPluginType.getInstance(), JobEntryPluginType.getInstance(), RepositoryPluginType.getInstance(), DatabasePluginType.getInstance()}) {
            PluginRegistry.addPluginType((PluginTypeInterface)pl);
        }
        PluginRegistry.init();
    }
}

