/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import junit.framework.TestCase;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;

public class RowDataUtilTest
extends TestCase {
    public boolean arrayCompare(Object[] arr1, int start1, Object[] arr2, int start2, int len) {
        boolean rcode = true;
        for (int idx = 0; idx < len && rcode; ++idx) {
            if (arr1[start1 + idx] == null && arr2[start2 + idx] == null || arr1[start1 + idx].equals(arr2[start2 + idx])) continue;
            rcode = false;
        }
        return rcode;
    }

    public void testResizeArray() throws KettleValueException {
        Object[] arr1 = new Object[]{"test", Boolean.TRUE, new Long(100L), new Long(101L), new String("test1")};
        Object[] nullArr = new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        Object[] arr2 = RowDataUtil.resizeArray((Object[])arr1, (int)7);
        RowDataUtilTest.assertTrue((arr1 != arr2 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((arr2.length >= 7 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(arr1, 0, arr2, 0, arr1.length));
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(arr2, arr1.length, nullArr, 0, arr2.length - arr1.length));
        Object[] arr3 = RowDataUtil.resizeArray((Object[])arr1, (int)3);
        RowDataUtilTest.assertTrue((arr3 == arr1 ? 1 : 0) != 0);
        Object[] arr4 = RowDataUtil.resizeArray((Object[])arr1, (int)arr1.length);
        RowDataUtilTest.assertTrue((arr1 != arr2 ? 1 : 0) != 0);
        RowDataUtilTest.assertEquals((int)arr4.length, (int)arr1.length);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(arr1, 0, arr4, 0, arr1.length));
    }

    public void testRemoveItem() throws KettleValueException {
        Object[] arr = new Object[]{new Long(1L), new Long(2L), new Long(3L), new Long(4L), new Long(5L)};
        Object[] comp1 = new Object[]{new Long(2L), new Long(3L), new Long(4L), new Long(5L)};
        Object[] newArr1 = RowDataUtil.removeItem((Object[])arr, (int)0);
        RowDataUtilTest.assertTrue((newArr1.length == comp1.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((newArr1.length == arr.length - 1 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr1, 0, comp1, 0, newArr1.length));
        Object[] comp2 = new Object[]{new Long(2L), new Long(3L), new Long(4L)};
        Object[] newArr2 = RowDataUtil.removeItem((Object[])newArr1, (int)(newArr1.length - 1));
        RowDataUtilTest.assertTrue((newArr2.length == arr.length - 2 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((newArr2.length == comp2.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr2, 0, comp2, 0, newArr2.length));
        Object[] comp3 = new Object[]{new Long(2L), new Long(4L)};
        Object[] newArr3 = RowDataUtil.removeItem((Object[])newArr2, (int)1);
        RowDataUtilTest.assertTrue((newArr3.length == arr.length - 3 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((newArr3.length == comp3.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr3, 0, comp3, 0, newArr3.length));
        Object[] comp4 = new Object[]{};
        Object[] newArr4 = RowDataUtil.removeItem((Object[])newArr3, (int)0);
        newArr4 = RowDataUtil.removeItem((Object[])newArr4, (int)0);
        RowDataUtilTest.assertTrue((newArr4.length == arr.length - 5 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((newArr4.length == comp4.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr4, 0, comp4, 0, newArr4.length));
    }

    public void testAddRowData() throws KettleValueException {
        Object[] arr = new Object[]{new Long(1L), new Long(2L), new Long(3L)};
        Object[] newArr1 = RowDataUtil.addRowData((Object[])new Object[0], (int)0, (Object[])new Object[]{new Long(1L), new Long(2L), new Long(3L)});
        RowDataUtilTest.assertTrue((newArr1.length >= arr.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr1, 0, arr, 0, arr.length));
        Object[] newArr2 = RowDataUtil.addRowData((Object[])new Object[]{new Long(1L), new Long(2L), new Long(3L)}, (int)3, (Object[])new Object[0]);
        RowDataUtilTest.assertTrue((newArr2.length >= arr.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr2, 0, arr, 0, arr.length));
        Object[] newArr3 = RowDataUtil.addRowData((Object[])new Object[]{new Long(1L)}, (int)1, (Object[])new Object[]{new Long(2L), new Long(3L)});
        RowDataUtilTest.assertTrue((newArr3.length >= arr.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr3, 0, arr, 0, arr.length));
        Object[] newArr4 = RowDataUtil.addRowData((Object[])new Object[]{new Long(1L), new Long(2L)}, (int)2, (Object[])new Object[]{new Long(3L)});
        RowDataUtilTest.assertTrue((newArr4.length >= arr.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr4, 0, arr, 0, arr.length));
    }

    public void testAddValueData() throws KettleValueException {
        Object[] arr1 = new Object[]{new Long(1L)};
        Object[] arr2 = new Object[]{new Long(1L), new Long(2L)};
        Object[] newArr1 = RowDataUtil.addValueData((Object[])new Object[0], (int)0, (Object)new Long(1L));
        RowDataUtilTest.assertTrue((newArr1.length >= arr1.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr1, 0, arr1, 0, arr1.length));
        Object[] newArr2 = RowDataUtil.addValueData((Object[])new Object[]{new Long(1L)}, (int)1, (Object)new Long(2L));
        RowDataUtilTest.assertTrue((newArr2.length >= arr2.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr2, 0, arr2, 0, arr2.length));
    }

    public void testRemoveItems() throws KettleValueException {
        Object[] arr1 = new Object[]{new Long(1L), new Long(2L), new Long(3L), new Long(4L), new Long(5L)};
        Object[] comp1 = new Object[]{new Long(2L), new Long(4L)};
        Object[] newArr1 = RowDataUtil.removeItems((Object[])arr1, (int[])new int[0]);
        RowDataUtilTest.assertTrue((newArr1.length == arr1.length ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr1, 0, arr1, 0, newArr1.length));
        Object[] newArr2 = RowDataUtil.removeItems((Object[])arr1, (int[])new int[]{0, 2, 4});
        RowDataUtilTest.assertTrue((newArr2.length == arr1.length - 3 ? 1 : 0) != 0);
        RowDataUtilTest.assertTrue((boolean)this.arrayCompare(newArr2, 0, comp1, 0, newArr2.length));
    }
}

