/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class RowTest
extends TestCase {
    public void testNormalStringConversion() throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Object[] rowData1 = new Object[]{"sampleString", fmt.parse("2007/05/07 13:04:13.203"), new Double(9123.0), new Long(12345L), new BigDecimal("123456789012345678.9349"), Boolean.TRUE};
        RowMetaInterface rowMeta1 = this.createTestRowMetaNormalStringConversion1();
        RowTest.assertEquals((String)"sampleString", (String)rowMeta1.getString(rowData1, 0));
        RowTest.assertEquals((String)"2007/05/07 13:04:13.203", (String)rowMeta1.getString(rowData1, 1));
        RowTest.assertEquals((String)"9,123.00", (String)rowMeta1.getString(rowData1, 2));
        RowTest.assertEquals((String)"0012345", (String)rowMeta1.getString(rowData1, 3));
        RowTest.assertEquals((String)"123456789012345678.9349", (String)rowMeta1.getString(rowData1, 4));
        RowTest.assertEquals((String)"Y", (String)rowMeta1.getString(rowData1, 5));
        fmt = new SimpleDateFormat("yyyyMMddHHmmss");
        Object[] rowData2 = new Object[]{null, fmt.parse("20070507130413"), new Double(9123.9), new Long(12345L), new BigDecimal("123456789012345678.9349"), Boolean.FALSE};
        RowMetaInterface rowMeta2 = this.createTestRowMetaNormalStringConversion2();
        RowTest.assertTrue((rowMeta2.getString(rowData2, 0) == null ? 1 : 0) != 0);
        RowTest.assertEquals((String)"20070507130413", (String)rowMeta2.getString(rowData2, 1));
        RowTest.assertEquals((String)"9.123,9", (String)rowMeta2.getString(rowData2, 2));
        RowTest.assertEquals((String)"0012345", (String)rowMeta2.getString(rowData2, 3));
        RowTest.assertEquals((String)"123456789012345678.9349", (String)rowMeta2.getString(rowData2, 4));
        RowTest.assertEquals((String)"false", (String)rowMeta2.getString(rowData2, 5));
    }

    public void testIndexedStringConversion() throws Exception {
        String[] colors = new String[]{"Green", "Red", "Blue", "Yellow", null};
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date[] dates = new Date[]{fmt.parse("2007/05/07 13:04:13.203"), null, fmt.parse("2007/05/05 05:15:49.349"), fmt.parse("2007/05/05 19:08:44.736")};
        RowMetaInterface rowMeta = this.createTestRowMetaIndexedStringConversion1(colors, dates);
        Object[] rowData1 = new Object[]{0, 0};
        Object[] rowData2 = new Object[]{1, 1};
        Object[] rowData3 = new Object[]{2, 2};
        Object[] rowData4 = new Object[]{3, 3};
        Object[] rowData5 = new Object[]{4, 0};
        RowTest.assertEquals((String)"Green", (String)rowMeta.getString(rowData1, 0));
        RowTest.assertEquals((String)"2007/05/07 13:04:13.203", (String)rowMeta.getString(rowData1, 1));
        RowTest.assertEquals((String)"Red", (String)rowMeta.getString(rowData2, 0));
        RowTest.assertTrue((null == rowMeta.getString(rowData2, 1) ? 1 : 0) != 0);
        RowTest.assertEquals((String)"Blue", (String)rowMeta.getString(rowData3, 0));
        RowTest.assertEquals((String)"2007/05/05 05:15:49.349", (String)rowMeta.getString(rowData3, 1));
        RowTest.assertEquals((String)"Yellow", (String)rowMeta.getString(rowData4, 0));
        RowTest.assertEquals((String)"2007/05/05 19:08:44.736", (String)rowMeta.getString(rowData4, 1));
        RowTest.assertTrue((null == rowMeta.getString(rowData5, 0) ? 1 : 0) != 0);
        RowTest.assertEquals((String)"2007/05/07 13:04:13.203", (String)rowMeta.getString(rowData5, 1));
    }

    private RowMetaInterface createTestRowMetaNormalStringConversion1() {
        RowMeta rowMeta = new RowMeta();
        ValueMeta meta1 = new ValueMeta("stringValue", 2, 30, 0);
        rowMeta.addValueMeta((ValueMetaInterface)meta1);
        ValueMeta meta2 = new ValueMeta("dateValue", 3);
        rowMeta.addValueMeta((ValueMetaInterface)meta2);
        ValueMeta meta3 = new ValueMeta("numberValue", 1, 5, 2);
        meta3.setConversionMask("#,##0.00");
        meta3.setDecimalSymbol(".");
        meta3.setGroupingSymbol(",");
        rowMeta.addValueMeta((ValueMetaInterface)meta3);
        ValueMeta meta4 = new ValueMeta("integerValue", 5, 7, 0);
        meta4.setConversionMask("0000000");
        meta4.setDecimalSymbol(".");
        meta4.setGroupingSymbol(",");
        rowMeta.addValueMeta((ValueMetaInterface)meta4);
        ValueMeta meta5 = new ValueMeta("bigNumberValue", 6, 30, 7);
        meta5.setDecimalSymbol(".");
        rowMeta.addValueMeta((ValueMetaInterface)meta5);
        ValueMeta meta6 = new ValueMeta("booleanValue", 4);
        rowMeta.addValueMeta((ValueMetaInterface)meta6);
        return rowMeta;
    }

    private RowMetaInterface createTestRowMetaNormalStringConversion2() {
        RowMeta rowMeta = new RowMeta();
        ValueMeta meta1 = new ValueMeta("stringValue", 2, 30, 0);
        meta1.setStorageType(2);
        rowMeta.addValueMeta((ValueMetaInterface)meta1);
        ValueMeta meta2 = new ValueMeta("dateValue", 3);
        meta2.setConversionMask("yyyyMMddHHmmss");
        rowMeta.addValueMeta((ValueMetaInterface)meta2);
        ValueMeta meta3 = new ValueMeta("numberValue", 1, 5, 2);
        meta3.setConversionMask("###,##0.##");
        meta3.setDecimalSymbol(",");
        meta3.setGroupingSymbol(".");
        rowMeta.addValueMeta((ValueMetaInterface)meta3);
        ValueMeta meta4 = new ValueMeta("integerValue", 5, 7, 0);
        meta4.setConversionMask("0000000");
        meta4.setDecimalSymbol(",");
        meta4.setGroupingSymbol(".");
        rowMeta.addValueMeta((ValueMetaInterface)meta4);
        ValueMeta meta5 = new ValueMeta("bigNumberValue", 6, 30, 7);
        meta5.setDecimalSymbol(".");
        rowMeta.addValueMeta((ValueMetaInterface)meta5);
        ValueMeta meta6 = new ValueMeta("booleanValue", 4, 3, 0);
        rowMeta.addValueMeta((ValueMetaInterface)meta6);
        return rowMeta;
    }

    private RowMetaInterface createTestRowMetaIndexedStringConversion1(String[] colors, Date[] dates) {
        RowMeta rowMeta = new RowMeta();
        ValueMeta meta1 = new ValueMeta("stringValue", 2, 30, 0);
        meta1.setIndex((Object[])colors);
        meta1.setStorageType(2);
        rowMeta.addValueMeta((ValueMetaInterface)meta1);
        ValueMeta meta2 = new ValueMeta("dateValue", 3);
        meta2.setIndex((Object[])dates);
        meta2.setStorageType(2);
        rowMeta.addValueMeta((ValueMetaInterface)meta2);
        return rowMeta;
    }
}

