/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class ValueDataUtilTest
extends TestCase {
    private static String yyyy_MM_dd = "yyyy-MM-dd";

    public void testLeftTrim() throws KettleValueException {
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.leftTrim((String)""));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.leftTrim((String)"string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.leftTrim((String)" string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.leftTrim((String)"  string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.leftTrim((String)"   string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.leftTrim((String)"     string"));
        ValueDataUtilTest.assertEquals((String)"string ", (String)ValueDataUtil.leftTrim((String)" string "));
        ValueDataUtilTest.assertEquals((String)"string  ", (String)ValueDataUtil.leftTrim((String)"  string  "));
        ValueDataUtilTest.assertEquals((String)"string   ", (String)ValueDataUtil.leftTrim((String)"   string   "));
        ValueDataUtilTest.assertEquals((String)"string    ", (String)ValueDataUtil.leftTrim((String)"    string    "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.leftTrim((String)" "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.leftTrim((String)"  "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.leftTrim((String)"   "));
    }

    public void testRightTrim() throws KettleValueException {
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)""));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.rightTrim((String)"string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.rightTrim((String)"string "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.rightTrim((String)"string  "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.rightTrim((String)"string   "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.rightTrim((String)"string    "));
        ValueDataUtilTest.assertEquals((String)" string", (String)ValueDataUtil.rightTrim((String)" string "));
        ValueDataUtilTest.assertEquals((String)"  string", (String)ValueDataUtil.rightTrim((String)"  string  "));
        ValueDataUtilTest.assertEquals((String)"   string", (String)ValueDataUtil.rightTrim((String)"   string   "));
        ValueDataUtilTest.assertEquals((String)"    string", (String)ValueDataUtil.rightTrim((String)"    string    "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)" "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)"  "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)"   "));
    }

    public void testIsSpace() throws KettleValueException {
        ValueDataUtilTest.assertTrue((boolean)ValueDataUtil.isSpace((char)' '));
        ValueDataUtilTest.assertTrue((boolean)ValueDataUtil.isSpace((char)'\t'));
        ValueDataUtilTest.assertTrue((boolean)ValueDataUtil.isSpace((char)'\r'));
        ValueDataUtilTest.assertTrue((boolean)ValueDataUtil.isSpace((char)'\n'));
        ValueDataUtilTest.assertFalse((boolean)ValueDataUtil.isSpace((char)'S'));
        ValueDataUtilTest.assertFalse((boolean)ValueDataUtil.isSpace((char)'b'));
    }

    public void testTrim() throws KettleValueException {
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.trim((String)""));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"string "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"string  "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"string   "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"string    "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)" string "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"  string  "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"   string   "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"    string    "));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)" string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"  string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"   string"));
        ValueDataUtilTest.assertEquals((String)"string", (String)ValueDataUtil.trim((String)"    string"));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)" "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)"  "));
        ValueDataUtilTest.assertEquals((String)"", (String)ValueDataUtil.rightTrim((String)"   "));
    }

    public void testDateDiff_A_GT_B() {
        Object daysDiff = this.calculate("2010-05-12", "2010-01-01", 3, 41);
        ValueDataUtilTest.assertEquals((Object)new Long(131L), (Object)((Long)daysDiff));
    }

    public void testDateDiff_A_LT_B() {
        Object daysDiff = this.calculate("2010-12-31", "2011-02-10", 3, 41);
        ValueDataUtilTest.assertEquals((Object)new Long(-41L), (Object)((Long)daysDiff));
    }

    public void testWorkingDaysDays_A_GT_B() {
        Object daysDiff = this.calculate("2010-05-12", "2010-01-01", 3, 63);
        ValueDataUtilTest.assertEquals((Object)new Long(93L), (Object)((Long)daysDiff));
    }

    public void testWorkingDaysDays_A_LT_B() {
        Object daysDiff = this.calculate("2010-12-31", "2011-02-10", 3, 63);
        ValueDataUtilTest.assertEquals((Object)new Long(-29L), (Object)((Long)daysDiff));
    }

    public void testAdd() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("3.0"), (Object)this.calculate("1", "2", 1, 3));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("0.0"), (Object)this.calculate("2", "-2", 1, 3));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("30.0"), (Object)this.calculate("10", "20", 1, 3));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("-50.0"), (Object)this.calculate("-100", "50", 1, 3));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("3"), (Object)this.calculate("1", "2", 5, 3));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("0"), (Object)this.calculate("2", "-2", 5, 3));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("30"), (Object)this.calculate("10", "20", 5, 3));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("-50"), (Object)this.calculate("-100", "50", 5, 3));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("2.0").compareTo((BigDecimal)this.calculate("1", "1", 6, 3)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("0.0").compareTo((BigDecimal)this.calculate("2", "-2", 6, 3)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("30.0").compareTo((BigDecimal)this.calculate("10", "20", 6, 3)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("-50.0").compareTo((BigDecimal)this.calculate("-100", "50", 6, 3)));
    }

    public void testAdd3() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("6.0"), (Object)this.calculate("1", "2", "3", 1, 42));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("2", "-2", "10", 1, 42));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("27.0"), (Object)this.calculate("10", "20", "-3", 1, 42));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("-55.0"), (Object)this.calculate("-100", "50", "-5", 1, 42));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("3"), (Object)this.calculate("1", "1", "1", 5, 42));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("2", "-2", "10", 5, 42));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("27"), (Object)this.calculate("10", "20", "-3", 5, 42));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("-55"), (Object)this.calculate("-100", "50", "-5", 5, 42));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("6.0").compareTo((BigDecimal)this.calculate("1", "2", "3", 6, 42)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("10.0").compareTo((BigDecimal)this.calculate("2", "-2", "10", 6, 42)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("27.0").compareTo((BigDecimal)this.calculate("10", "20", "-3", 6, 42)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("-55.0").compareTo((BigDecimal)this.calculate("-100", "50", "-5", 6, 42)));
    }

    public void testSubtract() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("20", "10", 1, 4));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("-10.0"), (Object)this.calculate("10", "20", 1, 4));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("20", "10", 5, 4));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("-10"), (Object)this.calculate("10", "20", 5, 4));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("10").compareTo((BigDecimal)this.calculate("20", "10", 6, 4)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("-10").compareTo((BigDecimal)this.calculate("10", "20", 6, 4)));
    }

    public void testDivide() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("2", "1", 1, 6));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("4", "2", 1, 6));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("0.5"), (Object)this.calculate("10", "20", 1, 6));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("100", "50", 1, 6));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "1", 5, 6));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("4", "2", 5, 6));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("0"), (Object)this.calculate("10", "20", 5, 6));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("100", "50", 5, 6));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("2")), (Object)this.calculate("2", "1", 6, 6));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("2")), (Object)this.calculate("4", "2", 6, 6));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("0.5")), (Object)this.calculate("10", "20", 6, 6));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("2")), (Object)this.calculate("100", "50", 6, 6));
    }

    public void testPercent1() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("10", "100", 1, 9));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("100.0"), (Object)this.calculate("2", "2", 1, 9));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("50.0"), (Object)this.calculate("10", "20", 1, 9));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("200.0"), (Object)this.calculate("100", "50", 1, 9));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("10", "100", 5, 9));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("100"), (Object)this.calculate("2", "2", 5, 9));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("50"), (Object)this.calculate("10", "20", 5, 9));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("200"), (Object)this.calculate("100", "50", 5, 9));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("10")), (Object)this.calculate("10", "100", 6, 9));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("100")), (Object)this.calculate("2", "2", 6, 9));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("50")), (Object)this.calculate("10", "20", 6, 9));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Long.valueOf("200")), (Object)this.calculate("100", "50", 6, 9));
    }

    public void testPercent2() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("0.99"), (Object)this.calculate("1", "1", 1, 10));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("1.96"), (Object)this.calculate("2", "2", 1, 10));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("8.0"), (Object)this.calculate("10", "20", 1, 10));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("50.0"), (Object)this.calculate("100", "50", 1, 10));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 10));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 10));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("8"), (Object)this.calculate("10", "20", 5, 10));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("50"), (Object)this.calculate("100", "50", 5, 10));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("0.99")), (Object)this.calculate("1", "1", 6, 10));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("1.99")), (Object)this.calculate("2", "2", 6, 10));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("9.995")), (Object)this.calculate("10", "20", 6, 10));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("99.98")), (Object)this.calculate("100", "50", 6, 10));
    }

    public void testPercent3() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("1.01"), (Object)this.calculate("1", "1", 1, 11));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.04"), (Object)this.calculate("2", "2", 1, 11));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("12.0"), (Object)this.calculate("10", "20", 1, 11));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("150.0"), (Object)this.calculate("100", "50", 1, 11));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 11));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 11));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("12"), (Object)this.calculate("10", "20", 5, 11));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("150"), (Object)this.calculate("100", "50", 5, 11));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("1.01").compareTo((BigDecimal)this.calculate("1", "1", 6, 11)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("2.01").compareTo((BigDecimal)this.calculate("2", "2", 6, 11)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("10.005").compareTo((BigDecimal)this.calculate("10", "20", 6, 11)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("100.02").compareTo((BigDecimal)this.calculate("100", "50", 6, 11)));
    }

    public void testCombination1() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("1", "1", "1", 1, 12));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("22.0"), (Object)this.calculate("2", "2", "10", 1, 12));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("70.0"), (Object)this.calculate("10", "20", "3", 1, 12));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("350"), (Object)this.calculate("100", "50", "5", 1, 12));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("1", "1", "1", 5, 12));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("22"), (Object)this.calculate("2", "2", "10", 5, 12));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("70"), (Object)this.calculate("10", "20", "3", 5, 12));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("350"), (Object)this.calculate("100", "50", "5", 5, 12));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("2.0").compareTo((BigDecimal)this.calculate("1", "1", "1", 6, 12)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("22.0").compareTo((BigDecimal)this.calculate("2", "2", "10", 6, 12)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("70.0").compareTo((BigDecimal)this.calculate("10", "20", "3", 6, 12)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("350.0").compareTo((BigDecimal)this.calculate("100", "50", "5", 6, 12)));
    }

    public void testCombination2() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("1.4142135623730951"), (Object)this.calculate("1", "1", 1, 13));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.8284271247461903"), (Object)this.calculate("2", "2", 1, 13));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("22.360679774997898"), (Object)this.calculate("10", "20", 1, 13));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("111.80339887498948"), (Object)this.calculate("100", "50", 1, 13));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 13));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 13));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("10", "20", 5, 13));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("100"), (Object)this.calculate("100", "50", 5, 13));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("1.4142135623730951").compareTo((BigDecimal)this.calculate("1", "1", 6, 13)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("2.8284271247461903").compareTo((BigDecimal)this.calculate("2", "2", 6, 13)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("22.360679774997898").compareTo((BigDecimal)this.calculate("10", "20", 6, 13)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("111.80339887498948").compareTo((BigDecimal)this.calculate("100", "50", 6, 13)));
    }

    public void testRound2() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("1.0"), (Object)this.calculate("1", "1", 1, 15));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.1"), (Object)this.calculate("2.06", "1", 1, 15));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("103.0"), (Object)this.calculate("103.01", "1", 1, 15));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("12.35"), (Object)this.calculate("12.346", "2", 1, 15));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "1", 5, 15));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("2", "2", 5, 15));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("103"), (Object)this.calculate("103", "3", 5, 15));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("12"), (Object)this.calculate("12", "4", 5, 15));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("1.0")), (Object)this.calculate("1", "1", 6, 15));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("2.1")), (Object)this.calculate("2.06", "1", 6, 15));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("103.0")), (Object)this.calculate("103.01", "1", 6, 15));
        ValueDataUtilTest.assertEquals((Object)BigDecimal.valueOf(Double.valueOf("12.35")), (Object)this.calculate("12.346", "2", 6, 15));
    }

    public void testNVL() {
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("1.0"), (Object)this.calculate("1", "", 1, 18));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("2.0"), (Object)this.calculate("", "2", 1, 18));
        ValueDataUtilTest.assertEquals((Object)Double.valueOf("10.0"), (Object)this.calculate("10", "20", 1, 18));
        ValueDataUtilTest.assertEquals(null, (Object)this.calculate("", "", 1, 18));
        ValueDataUtilTest.assertEquals((Object)"1", (Object)this.calculate("1", "", 2, 18));
        ValueDataUtilTest.assertEquals((Object)"2", (Object)this.calculate("", "2", 2, 18));
        ValueDataUtilTest.assertEquals((Object)"10", (Object)this.calculate("10", "20", 2, 18));
        ValueDataUtilTest.assertEquals(null, (Object)this.calculate("", "", 2, 18));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("1"), (Object)this.calculate("1", "", 5, 18));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("2"), (Object)this.calculate("", "2", 5, 18));
        ValueDataUtilTest.assertEquals((Object)Long.valueOf("10"), (Object)this.calculate("10", "20", 5, 18));
        ValueDataUtilTest.assertEquals(null, (Object)this.calculate("", "", 5, 18));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("1").compareTo((BigDecimal)this.calculate("1", "", 6, 18)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("2").compareTo((BigDecimal)this.calculate("", "2", 6, 18)));
        ValueDataUtilTest.assertEquals((int)0, (int)new BigDecimal("10").compareTo((BigDecimal)this.calculate("10", "20", 6, 18)));
        ValueDataUtilTest.assertEquals(null, (Object)this.calculate("", "", 6, 18));
        ValueDataUtilTest.assertEquals((Object)true, (Object)this.calculate("true", "", 4, 18));
        ValueDataUtilTest.assertEquals((Object)false, (Object)this.calculate("", "false", 4, 18));
        ValueDataUtilTest.assertEquals((Object)false, (Object)this.calculate("false", "true", 4, 18));
        ValueDataUtilTest.assertEquals(null, (Object)this.calculate("", "", 4, 18));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(yyyy_MM_dd);
        try {
            ValueDataUtilTest.assertEquals((Object)simpleDateFormat.parse("2012-04-11"), (Object)this.calculate("2012-04-11", "", 3, 18));
            ValueDataUtilTest.assertEquals((Object)simpleDateFormat.parse("2012-11-04"), (Object)this.calculate("", "2012-11-04", 3, 18));
            ValueDataUtilTest.assertEquals((Object)simpleDateFormat.parse("1965-07-01"), (Object)this.calculate("1965-07-01", "1967-04-11", 3, 18));
            ValueDataUtilTest.assertNull((Object)this.calculate("", "", 3, 18));
        }
        catch (ParseException pe) {
            ValueDataUtilTest.fail((String)pe.getMessage());
        }
        ValueMeta stringValueMeta = new ValueMeta("string", 2);
        try {
            byte[] data = stringValueMeta.getBinary((Object)"101");
            byte[] calculated = (byte[])this.calculate("101", "", 8, 18);
            ValueDataUtilTest.assertTrue((boolean)Arrays.equals(data, calculated));
            data = stringValueMeta.getBinary((Object)"011");
            calculated = (byte[])this.calculate("", "011", 8, 18);
            ValueDataUtilTest.assertTrue((boolean)Arrays.equals(data, calculated));
            data = stringValueMeta.getBinary((Object)"110");
            calculated = (byte[])this.calculate("110", "011", 8, 18);
            ValueDataUtilTest.assertTrue((boolean)Arrays.equals(data, calculated));
            calculated = (byte[])this.calculate("", "", 8, 18);
            ValueDataUtilTest.assertNull((Object)calculated);
        }
        catch (KettleValueException kve) {
            ValueDataUtilTest.fail((String)kve.getMessage());
        }
    }

    private Object calculate(String string_dataA, String string_dataB, int valueMetaInterfaceType, int calculatorMetaFunction) {
        return this.calculate(string_dataA, string_dataB, null, valueMetaInterfaceType, calculatorMetaFunction);
    }

    private Object calculate(String string_dataA, String string_dataB, String string_dataC, int valueMetaInterfaceType, int calculatorMetaFunction) {
        try {
            ValueMeta parameterValueMeta = new ValueMeta("parameter", 2);
            ValueMeta valueMetaA = this.createValueMeta("data_A", valueMetaInterfaceType);
            ValueMeta valueMetaB = this.createValueMeta("data_B", valueMetaInterfaceType);
            ValueMeta valueMetaC = this.createValueMeta("data_C", valueMetaInterfaceType);
            Object dataA = null;
            Object dataB = null;
            Object dataC = null;
            if (valueMetaInterfaceType == 1) {
                dataA = !Const.isEmpty((String)string_dataA) ? Double.valueOf(string_dataA) : null;
                dataB = !Const.isEmpty((String)string_dataB) ? Double.valueOf(string_dataB) : null;
                dataC = !Const.isEmpty((String)string_dataC) ? Double.valueOf(string_dataC) : null;
            } else if (valueMetaInterfaceType == 5) {
                dataA = !Const.isEmpty((String)string_dataA) ? Long.valueOf(string_dataA) : null;
                dataB = !Const.isEmpty((String)string_dataB) ? Long.valueOf(string_dataB) : null;
                dataC = !Const.isEmpty((String)string_dataC) ? Long.valueOf(string_dataC) : null;
            } else if (valueMetaInterfaceType == 3) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(yyyy_MM_dd);
                try {
                    dataA = !Const.isEmpty((String)string_dataA) ? simpleDateFormat.parse(string_dataA) : null;
                    dataB = !Const.isEmpty((String)string_dataB) ? simpleDateFormat.parse(string_dataB) : null;
                    dataC = !Const.isEmpty((String)string_dataC) ? simpleDateFormat.parse(string_dataC) : null;
                }
                catch (ParseException pe) {
                    ValueDataUtilTest.fail((String)pe.getMessage());
                    return null;
                }
            } else if (valueMetaInterfaceType == 6) {
                dataA = !Const.isEmpty((String)string_dataA) ? BigDecimal.valueOf(Double.valueOf(string_dataA)) : null;
                dataB = !Const.isEmpty((String)string_dataB) ? BigDecimal.valueOf(Double.valueOf(string_dataB)) : null;
                dataC = !Const.isEmpty((String)string_dataC) ? BigDecimal.valueOf(Double.valueOf(string_dataC)) : null;
            } else if (valueMetaInterfaceType == 2) {
                dataA = !Const.isEmpty((String)string_dataA) ? string_dataA : null;
                dataB = !Const.isEmpty((String)string_dataB) ? string_dataB : null;
                dataC = !Const.isEmpty((String)string_dataC) ? string_dataC : null;
            } else if (valueMetaInterfaceType == 8) {
                ValueMeta binaryValueMeta = new ValueMeta("binary_data", 8);
                dataA = !Const.isEmpty((String)string_dataA) ? binaryValueMeta.convertData((ValueMetaInterface)parameterValueMeta, (Object)string_dataA) : null;
                dataB = !Const.isEmpty((String)string_dataB) ? binaryValueMeta.convertData((ValueMetaInterface)parameterValueMeta, (Object)string_dataB) : null;
                dataC = !Const.isEmpty((String)string_dataC) ? binaryValueMeta.convertData((ValueMetaInterface)parameterValueMeta, (Object)string_dataC) : null;
            } else if (valueMetaInterfaceType == 4) {
                dataA = !Const.isEmpty((String)string_dataA) ? Boolean.valueOf(string_dataA.equalsIgnoreCase("true")) : null;
                dataB = !Const.isEmpty((String)string_dataB) ? Boolean.valueOf(string_dataB.equalsIgnoreCase("true")) : null;
                dataC = !Const.isEmpty((String)string_dataC) ? Boolean.valueOf(string_dataC.equalsIgnoreCase("true")) : null;
            } else {
                ValueDataUtilTest.fail((String)"Invalid ValueMetaInterface type.");
                return null;
            }
            if (calculatorMetaFunction == 3) {
                return ValueDataUtil.plus((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 42) {
                return ValueDataUtil.plus3((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB, (ValueMetaInterface)valueMetaC, (Object)dataC);
            }
            if (calculatorMetaFunction == 4) {
                return ValueDataUtil.minus((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 6) {
                return ValueDataUtil.divide((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 9) {
                return ValueDataUtil.percent1((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 10) {
                return ValueDataUtil.percent2((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 11) {
                return ValueDataUtil.percent3((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 12) {
                return ValueDataUtil.combination1((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB, (ValueMetaInterface)valueMetaC, (Object)dataC);
            }
            if (calculatorMetaFunction == 13) {
                return ValueDataUtil.combination2((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 15) {
                return ValueDataUtil.round((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 18) {
                return ValueDataUtil.nvl((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 41) {
                return ValueDataUtil.DateDiff((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            if (calculatorMetaFunction == 63) {
                return ValueDataUtil.DateWorkingDiff((ValueMetaInterface)valueMetaA, (Object)dataA, (ValueMetaInterface)valueMetaB, (Object)dataB);
            }
            ValueDataUtilTest.fail((String)"Invalid CalculatorMetaFunction specified.");
            return null;
        }
        catch (KettleValueException kve) {
            ValueDataUtilTest.fail((String)kve.getMessage());
            return null;
        }
    }

    private ValueMeta createValueMeta(String name, int valueType) {
        ValueMeta valueMeta = new ValueMeta();
        valueMeta.setName(name);
        valueMeta.setType(valueType);
        return valueMeta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DateCalc {
        WORKING_DAYS,
        DATE_DIFF;

    }
}

