/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.math.BigDecimal;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class ValueMetaTest
extends TestCase {
    private boolean byteCompare(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int idx = 0; idx < b1.length; ++idx) {
            if (b1[idx] == b2[idx]) continue;
            return false;
        }
        return true;
    }

    public void testCvtStringToBinaryString() throws Exception {
        ValueMeta val1 = new ValueMeta("STR1", 2);
        val1.setLength(6);
        val1.setStringEncoding("UTF8");
        byte[] b1 = val1.getBinary((Object)"PDI123");
        ValueMetaTest.assertTrue((boolean)this.byteCompare(b1, new byte[]{80, 68, 73, 49, 50, 51}));
        byte[] b2 = val1.getBinary((Object)"PDI");
        ValueMetaTest.assertTrue((boolean)this.byteCompare(b2, new byte[]{80, 68, 73}));
        byte[] b3 = val1.getBinary((Object)"PDI123456");
        ValueMetaTest.assertTrue((boolean)this.byteCompare(b3, new byte[]{80, 68, 73, 49, 50, 51, 52, 53, 54}));
        ValueMeta val2 = new ValueMeta("STR2", 2);
        val2.setLength(1);
        byte[] b4 = val2.getBinary((Object)"PDI123");
        ValueMetaTest.assertTrue((boolean)this.byteCompare(b4, new byte[]{80, 68, 73, 49, 50, 51}));
        byte[] b5 = val2.getBinary((Object)"PDI");
        ValueMetaTest.assertTrue((boolean)this.byteCompare(b5, new byte[]{80, 68, 73}));
        byte[] b6 = val2.getBinary((Object)"PDI123456");
        ValueMetaTest.assertTrue((boolean)this.byteCompare(b6, new byte[]{80, 68, 73, 49, 50, 51, 52, 53, 54}));
    }

    public void testCvtStringBinaryString() throws Exception {
        ValueMeta val1 = new ValueMeta("STR1", 2);
        val1.setLength(6);
        val1.setStringEncoding("UTF8");
        ValueMeta val2 = new ValueMeta("BINSTR1", 2, 1);
        val2.setStorageMetadata((ValueMetaInterface)val1);
        val2.setLength(6);
        val2.setStringEncoding("UTF8");
        String str1 = val2.getString((Object)val1.getBinary((Object)"PDI123"));
        ValueMetaTest.assertTrue((boolean)"PDI123".equals(str1));
        String str2 = val2.getString((Object)val1.getBinary((Object)"PDI"));
        ValueMetaTest.assertTrue((boolean)"PDI".equals(str2));
        String str3 = val2.getString((Object)val1.getBinary((Object)"PDI123456"));
        ValueMetaTest.assertTrue((boolean)"PDI123456".equals(str3));
    }

    public void testIntegerToStringToInteger() throws Exception {
        ValueMeta intValueMeta = new ValueMeta("i", 5);
        intValueMeta.setConversionMask(null);
        intValueMeta.setLength(7);
        Long originalValue = new Long(123L);
        String string = intValueMeta.getString((Object)originalValue);
        ValueMetaTest.assertEquals((String)" 0000123", (String)string);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        strValueMeta.setConversionMetadata((ValueMetaInterface)intValueMeta);
        Long x = (Long)strValueMeta.convertDataUsingConversionMetaData((Object)string);
        ValueMetaTest.assertEquals((Object)originalValue, (Object)x);
    }

    public void testNumberToStringToNumber() throws Exception {
        ValueMeta numValueMeta = new ValueMeta("i", 1);
        numValueMeta.setConversionMask(null);
        numValueMeta.setLength(7, 3);
        numValueMeta.setDecimalSymbol(",");
        numValueMeta.setGroupingSymbol(".");
        Double originalValue = new Double(123.456);
        String string = numValueMeta.getString((Object)originalValue);
        ValueMetaTest.assertEquals((String)" 0123,456", (String)string);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        strValueMeta.setConversionMetadata((ValueMetaInterface)numValueMeta);
        Double x = (Double)strValueMeta.convertDataUsingConversionMetaData((Object)string);
        ValueMetaTest.assertEquals((Object)originalValue, (Object)x);
    }

    public void testBigNumberToStringToBigNumber() throws Exception {
        ValueMeta numValueMeta = new ValueMeta("i", 6);
        numValueMeta.setLength(42, 9);
        numValueMeta.setDecimalSymbol(".");
        numValueMeta.setGroupingSymbol(",");
        BigDecimal originalValue = new BigDecimal("34039423484343123.443489056");
        String string = numValueMeta.getString((Object)originalValue);
        ValueMetaTest.assertEquals((String)"34039423484343123.443489056", (String)string);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        strValueMeta.setConversionMetadata((ValueMetaInterface)numValueMeta);
        BigDecimal x = (BigDecimal)strValueMeta.convertDataUsingConversionMetaData((Object)string);
        ValueMetaTest.assertEquals((Object)originalValue, (Object)x);
    }

    public void testDateToStringToDate() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("CET"));
        ValueMeta datValueMeta = new ValueMeta("i", 3);
        datValueMeta.setConversionMask("yyyy - MM - dd   HH:mm:ss'('SSS')' z");
        Date originalValue = new Date(7258114799999L);
        String string = datValueMeta.getString((Object)originalValue);
        ValueMetaTest.assertEquals((String)"2199 - 12 - 31   23:59:59(999) CET", (String)string);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        strValueMeta.setConversionMetadata((ValueMetaInterface)datValueMeta);
        Date x = (Date)strValueMeta.convertDataUsingConversionMetaData((Object)string);
        ValueMetaTest.assertEquals((Object)originalValue, (Object)x);
    }

    public void testConvertDataDate() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("CET"));
        ValueMeta source = new ValueMeta("src", 2);
        source.setConversionMask("SSS.ss:mm:HH dd/MM/yyyy z");
        ValueMeta target = new ValueMeta("tgt", 3);
        Date date = (Date)target.convertData((ValueMetaInterface)source, (Object)"999.59:59:23 31/12/2007 CET");
        ValueMetaTest.assertEquals((Object)new Date(1199141999999L), (Object)date);
        target.setConversionMask("yy/MM/dd HH:mm");
        String string = (String)source.convertData((ValueMetaInterface)target, (Object)date);
        ValueMetaTest.assertEquals((String)"07/12/31 23:59", (String)string);
    }

    public void testConvertDataInteger() throws Exception {
        ValueMeta source = new ValueMeta("src", 2);
        source.setConversionMask(" #,##0");
        source.setLength(12, 3);
        source.setDecimalSymbol(",");
        source.setGroupingSymbol(".");
        ValueMeta target = new ValueMeta("tgt", 5);
        Long d = (Long)target.convertData((ValueMetaInterface)source, (Object)" 2.837");
        ValueMetaTest.assertEquals((long)2837L, (long)d);
        target.setConversionMask("###,###,##0.00");
        target.setLength(12, 4);
        target.setDecimalSymbol(".");
        target.setGroupingSymbol("'");
        String string = (String)source.convertData((ValueMetaInterface)target, (Object)d);
        ValueMetaTest.assertEquals((String)"2'837.00", (String)string);
    }

    public void testConvertDataNumber() throws Exception {
        ValueMeta source = new ValueMeta("src", 2);
        source.setConversionMask("###,###,##0.000");
        source.setLength(3, 0);
        source.setDecimalSymbol(",");
        source.setGroupingSymbol(".");
        ValueMeta target = new ValueMeta("tgt", 1);
        Double d = (Double)target.convertData((ValueMetaInterface)source, (Object)"123.456.789,012");
        ValueMetaTest.assertEquals((Object)1.23456789012E8, (Object)d);
        target.setConversionMask("###,###,##0.00");
        target.setLength(12, 4);
        target.setDecimalSymbol(".");
        target.setGroupingSymbol("'");
        String string = (String)source.convertData((ValueMetaInterface)target, (Object)d);
        ValueMetaTest.assertEquals((String)"123'456'789.01", (String)string);
    }

    public void testLazyConversionInteger() throws Exception {
        byte[] data = "1234".getBytes();
        ValueMeta intValueMeta = new ValueMeta("i", 5);
        intValueMeta.setConversionMask(null);
        intValueMeta.setLength(7);
        intValueMeta.setStorageType(1);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        intValueMeta.setStorageMetadata((ValueMetaInterface)strValueMeta);
        Long integerValue = intValueMeta.getInteger((Object)data);
        ValueMetaTest.assertEquals((Object)new Long(1234L), (Object)integerValue);
        Double numberValue = intValueMeta.getNumber((Object)data);
        ValueMetaTest.assertEquals((Object)new Double(1234.0), (Object)numberValue);
        BigDecimal bigNumberValue = intValueMeta.getBigNumber((Object)data);
        ValueMetaTest.assertEquals((Object)new BigDecimal(1234), (Object)bigNumberValue);
        Date dateValue = intValueMeta.getDate((Object)data);
        ValueMetaTest.assertEquals((Object)new Date(1234L), (Object)dateValue);
        String string = intValueMeta.getString((Object)data);
        ValueMetaTest.assertEquals((String)" 0001234", (String)string);
    }

    public void testLazyConversionNumber() throws Exception {
        byte[] data = "1,234.56".getBytes();
        ValueMeta numValueMeta = new ValueMeta("i", 1);
        numValueMeta.setConversionMask(null);
        numValueMeta.setLength(12, 4);
        numValueMeta.setDecimalSymbol(",");
        numValueMeta.setGroupingSymbol(".");
        numValueMeta.setStorageType(1);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        strValueMeta.setConversionMask("#,##0.00");
        strValueMeta.setDecimalSymbol(".");
        strValueMeta.setGroupingSymbol(",");
        numValueMeta.setStorageMetadata((ValueMetaInterface)strValueMeta);
        Long integerValue = numValueMeta.getInteger((Object)data);
        ValueMetaTest.assertEquals((Object)new Long(1235L), (Object)integerValue);
        Double numberValue = numValueMeta.getNumber((Object)data);
        ValueMetaTest.assertEquals((Object)new Double(1234.56), (Object)numberValue);
        BigDecimal bigNumberValue = numValueMeta.getBigNumber((Object)data);
        ValueMetaTest.assertEquals((Object)BigDecimal.valueOf(1234.56), (Object)bigNumberValue);
        Date dateValue = numValueMeta.getDate((Object)data);
        ValueMetaTest.assertEquals((Object)new Date(1234L), (Object)dateValue);
        String string = numValueMeta.getString((Object)data);
        ValueMetaTest.assertEquals((String)" 00001234,5600", (String)string);
        byte[] binaryValue = numValueMeta.getBinaryString((Object)data);
        ValueMetaTest.assertTrue((boolean)this.byteCompare(" 00001234,5600".getBytes(), binaryValue));
    }

    public void testLazyConversionBigNumber() throws Exception {
        String originalValue = "34983433433212304121900934.5634314343";
        byte[] data = originalValue.getBytes();
        ValueMeta numValueMeta = new ValueMeta("i", 6);
        numValueMeta.setLength(36, 10);
        numValueMeta.setConversionMask("#.############");
        numValueMeta.setDecimalSymbol(".");
        numValueMeta.setGroupingSymbol(",");
        numValueMeta.setStorageType(1);
        ValueMeta strValueMeta = new ValueMeta("str", 2);
        strValueMeta.setConversionMask("#.############");
        strValueMeta.setDecimalSymbol(".");
        strValueMeta.setGroupingSymbol(",");
        numValueMeta.setStorageMetadata((ValueMetaInterface)strValueMeta);
        Long integerValue = numValueMeta.getInteger((Object)data);
        ValueMetaTest.assertEquals((Object)new Long(-5045838617297571962L), (Object)integerValue);
        Double numberValue = numValueMeta.getNumber((Object)data);
        ValueMetaTest.assertEquals((Object)new Double("3.4983433433212304E25"), (Object)numberValue);
        BigDecimal bigNumberValue = numValueMeta.getBigNumber((Object)data);
        ValueMetaTest.assertEquals((Object)new BigDecimal(originalValue), (Object)bigNumberValue);
        Date dateValue = numValueMeta.getDate((Object)data);
        ValueMetaTest.assertEquals((Object)new Date(-5045838617297571962L), (Object)dateValue);
        String string = numValueMeta.getString((Object)data);
        ValueMetaTest.assertEquals((String)originalValue, (String)string);
    }

    public void testCompareIntegersNormalStorageData() throws Exception {
        Long integer1 = new Long(1234L);
        Long integer2 = new Long(1235L);
        Long integer3 = new Long(1233L);
        Long integer4 = new Long(1234L);
        Object integer5 = null;
        Object integer6 = null;
        ValueMeta one = new ValueMeta("one", 5);
        ValueMeta two = new ValueMeta("two", 5);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (Object)integer2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (Object)integer3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (Object)integer4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, integer5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(integer5, integer6) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (ValueMetaInterface)two, (Object)integer2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (ValueMetaInterface)two, (Object)integer3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (ValueMetaInterface)two, (Object)integer4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)integer1, (ValueMetaInterface)two, integer5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(integer5, (ValueMetaInterface)two, integer6) == 0 ? 1 : 0) != 0);
    }

    public void testCompareNumbersNormalStorageData() throws Exception {
        Double number1 = new Double(1234.56);
        Double number2 = new Double(1235.56);
        Double number3 = new Double(1233.56);
        Double number4 = new Double(1234.56);
        Object number5 = null;
        Object number6 = null;
        ValueMeta one = new ValueMeta("one", 1);
        ValueMeta two = new ValueMeta("two", 1);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (Object)number2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (Object)number3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (Object)number4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, number5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(number5, number6) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, (Object)number2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, (Object)number3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, (Object)number4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, number5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(number5, (ValueMetaInterface)two, number6) == 0 ? 1 : 0) != 0);
    }

    public void testCompareBigNumberNormalStorageData() throws Exception {
        BigDecimal number1 = new BigDecimal("987908798769876.23943409");
        BigDecimal number2 = new BigDecimal("999908798769876.23943409");
        BigDecimal number3 = new BigDecimal("955908798769876.23943409");
        BigDecimal number4 = new BigDecimal("987908798769876.23943409");
        Object number5 = null;
        Object number6 = null;
        ValueMeta one = new ValueMeta("one", 6);
        ValueMeta two = new ValueMeta("two", 6);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (Object)number2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (Object)number3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (Object)number4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, number5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(number5, number6) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, (Object)number2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, (Object)number3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, (Object)number4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)number1, (ValueMetaInterface)two, number5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(number5, (ValueMetaInterface)two, number6) == 0 ? 1 : 0) != 0);
    }

    public void testCompareDatesNormalStorageData() throws Exception {
        Date date1 = new Date();
        Date date2 = new Date(date1.getTime() + 3600L);
        Date date3 = new Date(date1.getTime() - 3600L);
        Date date4 = new Date(date1.getTime());
        Object date5 = null;
        Object date6 = null;
        ValueMeta one = new ValueMeta("one", 3);
        ValueMeta two = new ValueMeta("two", 3);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (Object)date2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (Object)date3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (Object)date4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, date5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(date5, date6) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (ValueMetaInterface)two, (Object)date2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (ValueMetaInterface)two, (Object)date3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (ValueMetaInterface)two, (Object)date4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)date1, (ValueMetaInterface)two, date5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(date5, (ValueMetaInterface)two, date6) == 0 ? 1 : 0) != 0);
    }

    public void testCompareBooleanNormalStorageData() throws Exception {
        Boolean boolean1 = new Boolean(false);
        Boolean boolean2 = new Boolean(true);
        Boolean boolean3 = new Boolean(false);
        Object boolean4 = null;
        Object boolean5 = null;
        ValueMeta one = new ValueMeta("one", 4);
        ValueMeta two = new ValueMeta("two", 4);
        ValueMetaTest.assertTrue((one.compare((Object)boolean1, (Object)boolean2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)boolean1, (Object)boolean3) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)boolean1, boolean4) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(boolean4, boolean5) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)boolean1, (ValueMetaInterface)two, (Object)boolean2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)boolean1, (ValueMetaInterface)two, (Object)boolean3) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)boolean1, (ValueMetaInterface)two, boolean4) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(boolean4, (ValueMetaInterface)two, boolean5) == 0 ? 1 : 0) != 0);
    }

    public void testCompareStringsNormalStorageData() throws Exception {
        String string1 = "bbbbb";
        String string2 = "ccccc";
        String string3 = "aaaaa";
        String string4 = "bbbbb";
        Object string5 = null;
        Object string6 = null;
        ValueMeta one = new ValueMeta("one", 2);
        ValueMeta two = new ValueMeta("two", 2);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (Object)string2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (Object)string3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (Object)string4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, string5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(string5, string6) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (ValueMetaInterface)two, (Object)string2) < 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (ValueMetaInterface)two, (Object)string3) > 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (ValueMetaInterface)two, (Object)string4) == 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare((Object)string1, (ValueMetaInterface)two, string5) != 0 ? 1 : 0) != 0);
        ValueMetaTest.assertTrue((one.compare(string5, (ValueMetaInterface)two, string6) == 0 ? 1 : 0) != 0);
    }
}

