/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.pentaho.di.core.util.StringEvaluationResult;
import org.pentaho.di.core.util.StringEvaluator;

public class StringEvaluatorTest
extends TestCase {
    private String[] series1 = new String[]{"Foo", "Bar", "One", "", "Two", "Three"};
    private String[] series2 = new String[]{"2009/12/31 12:34:56", "2010/02/14 23:22:01"};
    private String[] series3 = new String[]{"1234,56", "12394,26", "1934,34", "19245,23", ""};
    private String[] series4 = new String[]{"01234,56     ", "             ", "98765,43     ", "12394,26     ", "01934,34     ", "19245,23     ", "00045,67     "};

    public void testSeries1() throws Exception {
        StringEvaluator evaluator = new StringEvaluator(false);
        for (String string : this.series1) {
            evaluator.evaluateString(string);
        }
        StringEvaluatorTest.assertEquals((int)evaluator.getCount(), (int)this.series1.length);
        StringEvaluatorTest.assertEquals((int)evaluator.getMaxLength(), (int)5);
        StringEvaluatorTest.assertEquals((int)evaluator.getStringEvaluationResults().size(), (int)0);
    }

    public void testSeries2() throws Exception {
        StringEvaluator evaluator = new StringEvaluator(false);
        for (String string : this.series2) {
            evaluator.evaluateString(string);
        }
        StringEvaluatorTest.assertEquals((int)evaluator.getCount(), (int)this.series2.length);
        StringEvaluatorTest.assertEquals((int)evaluator.getMaxLength(), (int)19);
        StringEvaluationResult result = (StringEvaluationResult)evaluator.getStringEvaluationResults().get(0);
        StringEvaluatorTest.assertEquals((String)"Not a date detetected", (int)result.getConversionMeta().getType(), (int)3);
        Date minDate = result.getConversionMeta().getDate(result.getMin());
        StringEvaluatorTest.assertEquals((long)minDate.getTime(), (long)1262280896000L);
        int nrEmpty = result.getNrNull();
        StringEvaluatorTest.assertEquals((int)nrEmpty, (int)0);
        StringEvaluatorTest.assertEquals((int)evaluator.getValues().size(), (int)this.series2.length);
    }

    public void testSeries3() throws Exception {
        StringEvaluator evaluator = new StringEvaluator(false);
        for (String string : this.series3) {
            evaluator.evaluateString(string);
        }
        StringEvaluatorTest.assertEquals((int)evaluator.getCount(), (int)this.series3.length);
        StringEvaluatorTest.assertEquals((int)evaluator.getMaxLength(), (int)8);
        StringEvaluationResult result = (StringEvaluationResult)evaluator.getStringEvaluationResults().get(0);
        StringEvaluatorTest.assertEquals((String)"Not a number detetected", (int)result.getConversionMeta().getType(), (int)1);
        int nrEmpty = result.getNrNull();
        StringEvaluatorTest.assertEquals((int)nrEmpty, (int)1);
        StringEvaluatorTest.assertEquals((int)evaluator.getValues().size(), (int)this.series3.length);
    }

    public void testSeries4() throws Exception {
        StringEvaluator evaluator = new StringEvaluator(true);
        for (String string : this.series4) {
            evaluator.evaluateString(string);
        }
        StringEvaluatorTest.assertEquals((int)evaluator.getCount(), (int)this.series4.length);
        StringEvaluatorTest.assertEquals((int)evaluator.getMaxLength(), (int)13);
        StringEvaluationResult result = (StringEvaluationResult)evaluator.getStringEvaluationResults().get(0);
        StringEvaluatorTest.assertEquals((String)"Not a number detetected", (int)result.getConversionMeta().getType(), (int)1);
        int nrEmpty = result.getNrNull();
        StringEvaluatorTest.assertEquals((int)nrEmpty, (int)1);
        StringEvaluatorTest.assertEquals((int)evaluator.getValues().size(), (int)this.series4.length);
    }

    public void testCurrencyData() {
        String[] values;
        StringEvaluator eval = new StringEvaluator(true);
        for (String value : values = new String[]{"$300.00", "$3,400", "$23.00", "($0.50)"}) {
            eval.evaluateString(value);
        }
        StringEvaluatorTest.assertEquals((int)values.length, (int)eval.getCount());
        StringEvaluationResult result = eval.getAdvicedResult();
        StringEvaluatorTest.assertEquals((String)"Not a number detetected", (int)1, (int)result.getConversionMeta().getType());
        StringEvaluatorTest.assertEquals((String)"Precision not correct", (int)2, (int)result.getConversionMeta().getPrecision());
        StringEvaluatorTest.assertEquals((String)"Currency format mask is incorrect", (String)"$#,##0.00;($#,##0.00)", (String)result.getConversionMeta().getConversionMask());
    }

    public void testCurrencyData_UK() {
        String[] values;
        Locale orig = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        StringEvaluator eval = new StringEvaluator(true);
        DecimalFormat currencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
        System.out.println("UK Locale currency format: " + currencyFormat.toLocalizedPattern());
        try {
            currencyFormat.parse("-\u00a3400.059");
        }
        catch (ParseException e) {
            StringEvaluatorTest.fail();
        }
        for (String value : values = new String[]{"\u00a3400.019", "\u00a33,400.029", "\u00a323.00", "-\u00a3400.059"}) {
            eval.evaluateString(value);
        }
        StringEvaluatorTest.assertEquals((int)values.length, (int)eval.getCount());
        StringEvaluationResult result = eval.getAdvicedResult();
        Locale.setDefault(orig);
        StringEvaluatorTest.assertEquals((String)"Not a number detetected", (int)1, (int)result.getConversionMeta().getType());
        StringEvaluatorTest.assertEquals((String)"Precision not correct", (int)2, (int)result.getConversionMeta().getPrecision());
        StringEvaluatorTest.assertEquals((String)"Currency format mask is incorrect", (String)"\u00a3#,##0.00", (String)result.getConversionMeta().getConversionMask());
    }

    public void testCustomDateFormats() {
        List<String> dates = Arrays.asList("MM/dd/yyyy");
        List<String> numbers = Arrays.asList("#,##0.###");
        StringEvaluator eval = new StringEvaluator(true, numbers, dates);
        String[] goodDateValues = new String[]{"01/01/2000", "02/02/2000", "03/03/2000"};
        String[] badDateValues = new String[]{"01-01-2000", "02-02-2000", "03-03-2000"};
        for (String value : goodDateValues) {
            eval.evaluateString(value);
        }
        StringEvaluatorTest.assertEquals((int)goodDateValues.length, (int)eval.getCount());
        StringEvaluationResult result = eval.getAdvicedResult();
        StringEvaluatorTest.assertEquals((String)"Not a date detetected", (int)result.getConversionMeta().getType(), (int)3);
        eval = new StringEvaluator(true, numbers, dates);
        for (String value : badDateValues) {
            eval.evaluateString(value);
        }
        StringEvaluatorTest.assertEquals((int)badDateValues.length, (int)eval.getCount());
        result = eval.getAdvicedResult();
        StringEvaluatorTest.assertFalse((String)"Date detetected", (result.getConversionMeta().getType() == 3 ? 1 : 0) != 0);
    }

    public void testCustomNumberFormats() {
        List<String> dates = Arrays.asList("MM/dd/yyyy");
        List<String> numbers = Arrays.asList("#");
        StringEvaluator eval = new StringEvaluator(true, numbers, dates);
        String[] goodValues = new String[]{"200.00", "999.99", "4,309.88"};
        String[] badValues = new String[]{"9 00", "$30.00", "3.999,00"};
        for (String value : goodValues) {
            eval.evaluateString(value);
        }
        StringEvaluatorTest.assertEquals((int)goodValues.length, (int)eval.getCount());
        StringEvaluationResult result = eval.getAdvicedResult();
        StringEvaluatorTest.assertEquals((String)"Not a number detetected", (int)result.getConversionMeta().getType(), (int)1);
        eval = new StringEvaluator(true, numbers, dates);
        for (String value : badValues) {
            eval.evaluateString(value);
        }
        StringEvaluatorTest.assertEquals((int)badValues.length, (int)eval.getCount());
        result = eval.getAdvicedResult();
        StringEvaluatorTest.assertFalse((String)"Number detetected", (result.getConversionMeta().getType() == 1 ? 1 : 0) != 0);
    }

    public void testDeterminePrecision() {
        StringEvaluatorTest.assertEquals((int)4, (int)StringEvaluator.determinePrecision((String)"#.0000"));
        StringEvaluatorTest.assertEquals((int)4, (int)StringEvaluator.determinePrecision((String)"0.#### $"));
        StringEvaluatorTest.assertEquals((int)0, (int)StringEvaluator.determinePrecision(null));
        StringEvaluatorTest.assertEquals((int)4, (int)StringEvaluator.determinePrecision((String)"0.##00 $"));
        StringEvaluatorTest.assertEquals((int)4, (int)StringEvaluator.determinePrecision((String)"##,##0.#0## $"));
    }
}

