/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.pentaho.di.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtilTest
extends TestCase {
    public void testinitCap() {
        StringUtilTest.assertEquals((String)"", (String)StringUtil.initCap(null));
        StringUtilTest.assertEquals((String)"", (String)StringUtil.initCap((String)""));
        StringUtilTest.assertEquals((String)"", (String)StringUtil.initCap((String)"   "));
        StringUtilTest.assertEquals((String)"A word", (String)StringUtil.initCap((String)"a word"));
        StringUtilTest.assertEquals((String)"A word", (String)StringUtil.initCap((String)"A word"));
        StringUtilTest.assertEquals((String)"Award", (String)StringUtil.initCap((String)"award"));
        StringUtilTest.assertEquals((String)"Award", (String)StringUtil.initCap((String)"Award"));
        StringUtilTest.assertEquals((String)"AWard", (String)StringUtil.initCap((String)"aWard"));
        StringUtilTest.assertEquals((String)"AWard", (String)StringUtil.initCap((String)"AWard"));
    }

    Map<String, String> createVariables1(String open, String close) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EMPTY", "");
        map.put("checkcase", "case1");
        map.put("CheckCase", "case2");
        map.put("CHECKCASE", "case3");
        map.put("VARIABLE_1", "VARIABLE1");
        map.put("recursive1", "A" + open + "recursive2" + close);
        map.put("recursive2", "recurse");
        map.put("recursive3", open + "recursive4" + close + "B");
        map.put("recursive4", "recurse");
        map.put("recursive5", open + "recursive6" + close + "B");
        map.put("recursive6", "Z" + open + "recursive7" + close);
        map.put("recursive7", "final");
        map.put("recursive_all", open + "recursive_all1" + close + " tail");
        map.put("recursive_all1", open + "recursive_all" + close + " tail1");
        return map;
    }

    public void testSubstituteBasic() {
        Map<String, String> map = this.createVariables1("${", "}");
        StringUtilTest.assertEquals((String)"||", (String)StringUtil.substitute((String)"|${EMPTY}|", map, (String)"${", (String)"}"));
        StringUtilTest.assertEquals((String)"|case1|", (String)StringUtil.substitute((String)"|${checkcase}|", map, (String)"${", (String)"}"));
        StringUtilTest.assertEquals((String)"|case2|", (String)StringUtil.substitute((String)"|${CheckCase}|", map, (String)"${", (String)"}"));
        StringUtilTest.assertEquals((String)"|case3|", (String)StringUtil.substitute((String)"|${CHECKCASE}|", map, (String)"${", (String)"}"));
        StringUtilTest.assertEquals((String)"|Arecurse|", (String)StringUtil.substitute((String)"|${recursive1}|", map, (String)"${", (String)"}"));
        StringUtilTest.assertEquals((String)"|recurseB|", (String)StringUtil.substitute((String)"|${recursive3}|", map, (String)"${", (String)"}"));
        StringUtilTest.assertEquals((String)"|ZfinalB|", (String)StringUtil.substitute((String)"|${recursive5}|", map, (String)"${", (String)"}"));
        try {
            StringUtil.substitute((String)"|${recursive_all}|", map, (String)"${", (String)"}", (int)0);
            StringUtilTest.fail((String)"recursive check is failing");
        }
        catch (RuntimeException rex) {
            // empty catch block
        }
        map = this.createVariables1("%%", "%%");
        StringUtilTest.assertEquals((String)"||", (String)StringUtil.substitute((String)"|%%EMPTY%%|", map, (String)"%%", (String)"%%"));
        StringUtilTest.assertEquals((String)"|case1|", (String)StringUtil.substitute((String)"|%%checkcase%%|", map, (String)"%%", (String)"%%"));
        StringUtilTest.assertEquals((String)"|case2|", (String)StringUtil.substitute((String)"|%%CheckCase%%|", map, (String)"%%", (String)"%%"));
        StringUtilTest.assertEquals((String)"|case3|", (String)StringUtil.substitute((String)"|%%CHECKCASE%%|", map, (String)"%%", (String)"%%"));
        StringUtilTest.assertEquals((String)"|Arecurse|", (String)StringUtil.substitute((String)"|%%recursive1%%|", map, (String)"%%", (String)"%%"));
        StringUtilTest.assertEquals((String)"|recurseB|", (String)StringUtil.substitute((String)"|%%recursive3%%|", map, (String)"%%", (String)"%%"));
        StringUtilTest.assertEquals((String)"|ZfinalB|", (String)StringUtil.substitute((String)"|%%recursive5%%|", map, (String)"%%", (String)"%%"));
        try {
            StringUtil.substitute((String)"|%%recursive_all%%|", map, (String)"%%", (String)"%%");
            StringUtilTest.fail((String)"recursive check is failing");
        }
        catch (RuntimeException rex) {
            // empty catch block
        }
        map = this.createVariables1("${", "}");
        StringUtilTest.assertEquals((String)"||", (String)StringUtil.environmentSubstitute((String)"|%%EMPTY%%|", map));
        StringUtilTest.assertEquals((String)"|case1|", (String)StringUtil.environmentSubstitute((String)"|%%checkcase%%|", map));
        StringUtilTest.assertEquals((String)"|case2|", (String)StringUtil.environmentSubstitute((String)"|%%CheckCase%%|", map));
        StringUtilTest.assertEquals((String)"|case3|", (String)StringUtil.environmentSubstitute((String)"|%%CHECKCASE%%|", map));
        StringUtilTest.assertEquals((String)"|Arecurse|", (String)StringUtil.environmentSubstitute((String)"|%%recursive1%%|", map));
        StringUtilTest.assertEquals((String)"|recurseB|", (String)StringUtil.environmentSubstitute((String)"|%%recursive3%%|", map));
        StringUtilTest.assertEquals((String)"|ZfinalB|", (String)StringUtil.environmentSubstitute((String)"|%%recursive5%%|", map));
        try {
            StringUtil.environmentSubstitute((String)"|%%recursive_all%%|", map);
            StringUtilTest.fail((String)"recursive check is failing");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        StringUtilTest.assertTrue((boolean)StringUtil.isEmpty((String)null));
        StringUtilTest.assertTrue((boolean)StringUtil.isEmpty((String)""));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmpty((String)"A"));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmpty((String)" A "));
    }

    public void testGetIndent() {
        StringUtilTest.assertEquals((String)"", (String)StringUtil.getIndent((int)0));
        StringUtilTest.assertEquals((String)" ", (String)StringUtil.getIndent((int)1));
        StringUtilTest.assertEquals((String)"  ", (String)StringUtil.getIndent((int)2));
        StringUtilTest.assertEquals((String)"   ", (String)StringUtil.getIndent((int)3));
    }
}

