/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import junit.framework.TestCase;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.vfs.KettleVFS;

public class VfsCoreTest
extends TestCase {
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    private static final String content = "Just a small line of text\n";

    public void testWriteReadFile() throws Exception {
        int c;
        FileObject tempFile = KettleVFS.createTempFile((String)"prefix", (String)"suffix", (String)tmpDir);
        OutputStream outputStream = KettleVFS.getOutputStream((FileObject)tempFile, (boolean)false);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.write(content);
        writer.close();
        outputStream.close();
        InputStream inputStream = KettleVFS.getInputStream((FileObject)tempFile);
        StringBuffer buffer = new StringBuffer();
        while ((c = inputStream.read()) >= 0) {
            buffer.append((char)c);
        }
        inputStream.close();
        VfsCoreTest.assertEquals((String)content, (String)buffer.toString());
        String url = tempFile.getName().getURI();
        String textFileContent = KettleVFS.getTextFileContent((String)url, (String)"UTF-8");
        tempFile.delete();
        VfsCoreTest.assertEquals((boolean)false, (boolean)tempFile.exists());
        VfsCoreTest.assertEquals((String)content, (String)textFileContent);
    }
}

