/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.DatabaseConfigurationImportRule;
import org.pentaho.di.trans.TransMeta;

public class DatabaseConfigurationImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        String DBNAME = "test";
        String HOSTNAME = "localhost";
        String PORT = "3306";
        String USERNAME = "foo";
        String PASSWORD = "bar";
        DatabaseMeta verifyMeta = new DatabaseMeta("LOGDB", "MYSQL", "JDBC", HOSTNAME, DBNAME, PORT, USERNAME, PASSWORD);
        TransMeta transMeta = new TransMeta();
        transMeta.addDatabase((DatabaseMeta)verifyMeta.clone());
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "DatabaseConfiguration");
        DatabaseConfigurationImportRuleTest.assertNotNull((String)"The 'database configuration' rule could not be found in the plugin registry!", (Object)plugin);
        DatabaseConfigurationImportRule rule = (DatabaseConfigurationImportRule)registry.loadClass(plugin);
        DatabaseConfigurationImportRuleTest.assertNotNull((String)"The 'database configuration' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'database configuration'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setDatabaseMeta(verifyMeta);
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        verifyMeta.setDBName("incorrect-test");
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An error ruling was expected validating the db name", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        verifyMeta.setDBName(DBNAME);
        verifyMeta.setHostname("incorrect-hostname");
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An error ruling was expected validating the db hostname", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        verifyMeta.setHostname(HOSTNAME);
        verifyMeta.setDBPort("incorrect-port");
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An error ruling was expected validating the db port", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        verifyMeta.setDBPort(PORT);
        verifyMeta.setUsername("incorrect-username");
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An error ruling was expected validating the db username", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        verifyMeta.setUsername(USERNAME);
        verifyMeta.setPassword("incorrect-password");
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"An error ruling was expected validating the db password", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        verifyMeta.setPassword(PASSWORD);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)transMeta);
        DatabaseConfigurationImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'transformation has trans log table configured' since disabled", (boolean)feedback.isEmpty());
    }
}

