/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.JobHasANoteImportRule;
import org.pentaho.di.job.JobMeta;

public class JobHasANoteImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        JobMeta jobMeta = new JobMeta();
        NotePadMeta note = new NotePadMeta("A note documenting the transformation", 50, 50, 200, 50);
        jobMeta.addNote(note);
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "JobHasANote");
        JobHasANoteImportRuleTest.assertNotNull((String)"The 'job has a note' rule could not be found in the plugin registry!", (Object)plugin);
        JobHasANoteImportRule rule = (JobHasANoteImportRule)registry.loadClass(plugin);
        JobHasANoteImportRuleTest.assertNotNull((String)"The 'job has a note' rule class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)jobMeta);
        JobHasANoteImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has a note'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasANoteImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        jobMeta.removeNote(0);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasANoteImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has a note' rule", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasANoteImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasANoteImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'job has no note' rule while disabled", (boolean)feedback.isEmpty());
    }
}

