/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.JobHasDescriptionImportRule;
import org.pentaho.di.job.JobMeta;

public class JobHasDescriptionImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        JobMeta jobMeta = new JobMeta();
        jobMeta.setDescription("This job is used for testing an import rule");
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "JobHasDescription");
        JobHasDescriptionImportRuleTest.assertNotNull((String)"The 'job has description' rule could not be found in the plugin registry!", (Object)plugin);
        JobHasDescriptionImportRule rule = (JobHasDescriptionImportRule)registry.loadClass(plugin);
        JobHasDescriptionImportRuleTest.assertNotNull((String)"The 'job has description rule' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setMinLength(20);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)jobMeta);
        JobHasDescriptionImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasDescriptionImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        rule.setMinLength(2000);
        rule.setEnabled(true);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasDescriptionImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasDescriptionImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasDescriptionImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'job has description rule' while disabled", (boolean)feedback.isEmpty());
    }
}

