/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.JobHasJobLogConfiguredImportRule;
import org.pentaho.di.job.JobMeta;

public class JobHasJobLogConfiguredImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        JobMeta jobMeta = new JobMeta();
        DatabaseMeta logDbMeta = new DatabaseMeta("LOGDB", "MYSQL", "JDBC", "localhost", "test", "3306", "foo", "bar");
        jobMeta.addDatabase(logDbMeta);
        JobLogTable logTable = jobMeta.getJobLogTable();
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "JobHasJobLogConfigured");
        JobHasJobLogConfiguredImportRuleTest.assertNotNull((String)"The 'job has job log table configured' rule could not be found in the plugin registry!", (Object)plugin);
        JobHasJobLogConfiguredImportRule rule = (JobHasJobLogConfiguredImportRule)registry.loadClass(plugin);
        JobHasJobLogConfiguredImportRuleTest.assertNotNull((String)"The 'job has job log table configured' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has job log table configured'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        logTable.setTableName("SCHEMA");
        logTable.setTableName("LOGTABLE");
        logTable.setConnectionName(logDbMeta.getName());
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        rule.setTableName("SCHEMA");
        rule.setTableName("LOGTABLE");
        rule.setConnectionName(logDbMeta.getName());
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        rule.setSchemaName("INCORRECT_SCHEMA");
        rule.setTableName("LOGTABLE");
        rule.setConnectionName(logDbMeta.getName());
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setSchemaName("SCHEMA");
        rule.setTableName("INCORRECT_LOGTABLE");
        rule.setConnectionName(logDbMeta.getName());
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setSchemaName("SCHEMA");
        rule.setTableName("LOGTABLE");
        rule.setConnectionName("INCORRECT_DATABASE");
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasJobLogConfiguredImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'job has job log table configured' since the rule is not enabled", (boolean)feedback.isEmpty());
    }
}

