/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.JobHasNoDisabledHopsImportRule;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.special.JobEntrySpecial;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;

public class JobHasNoDisabledHopsImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        JobMeta jobMeta = new JobMeta();
        JobEntryCopy lastCopy = null;
        for (int i = 0; i < 3; ++i) {
            JobEntrySpecial dummy = new JobEntrySpecial();
            dummy.setDummy(true);
            dummy.setName("dummy" + (i + 1));
            JobEntryCopy copy = new JobEntryCopy((JobEntryInterface)dummy);
            copy.setLocation(50 + i * 50, 50);
            copy.setDrawn();
            jobMeta.addJobEntry(copy);
            if (lastCopy != null) {
                JobHopMeta hop = new JobHopMeta(lastCopy, copy);
                jobMeta.addJobHop(hop);
            }
            lastCopy = copy;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "JobHasNoDisabledHops");
        JobHasNoDisabledHopsImportRuleTest.assertNotNull((String)"The 'job has no disabled hops' rule could not be found in the plugin registry!", (Object)plugin);
        JobHasNoDisabledHopsImportRule rule = (JobHasNoDisabledHopsImportRule)registry.loadClass(plugin);
        JobHasNoDisabledHopsImportRuleTest.assertNotNull((String)"The 'job has no disabled hops' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)jobMeta);
        JobHasNoDisabledHopsImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has no disabled hops'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasNoDisabledHopsImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        jobMeta.getJobHop(0).setEnabled(false);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasNoDisabledHopsImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'job has no disabled hops'", (!feedback.isEmpty() ? 1 : 0) != 0);
        JobHasNoDisabledHopsImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)jobMeta);
        JobHasNoDisabledHopsImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'job has no disabled hops' while disabled", (boolean)feedback.isEmpty());
    }
}

