/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.TransformationHasANoteImportRule;
import org.pentaho.di.trans.TransMeta;

public class TransformationHasANoteImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        TransMeta transMeta = new TransMeta();
        NotePadMeta note = new NotePadMeta("A note documenting the transformation", 50, 50, 200, 50);
        transMeta.addNote(note);
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "TransformationHasANote");
        TransformationHasANoteImportRuleTest.assertNotNull((String)"The 'transformation has a note' rule could not be found in the plugin registry!", (Object)plugin);
        TransformationHasANoteImportRule rule = (TransformationHasANoteImportRule)registry.loadClass(plugin);
        TransformationHasANoteImportRuleTest.assertNotNull((String)"The 'transformation has a note' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)transMeta);
        TransformationHasANoteImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has a note' rule", (!feedback.isEmpty() ? 1 : 0) != 0);
        TransformationHasANoteImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        transMeta.removeNote(0);
        feedback = rule.verifyRule((Object)transMeta);
        TransformationHasANoteImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has a note' rule", (!feedback.isEmpty() ? 1 : 0) != 0);
        TransformationHasANoteImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)transMeta);
        TransformationHasANoteImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'transformation has a note' rule while disabled", (boolean)feedback.isEmpty());
    }
}

