/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.TransformationHasDescriptionImportRule;
import org.pentaho.di.trans.TransMeta;

public class TransformationHasDescriptionImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        TransMeta transMeta = new TransMeta();
        transMeta.setDescription("This transformation is used for testing an import rule");
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "TransformationHasDescription");
        TransformationHasDescriptionImportRuleTest.assertNotNull((String)"The 'transformation has description' rule could not be found in the plugin registry!", (Object)plugin);
        TransformationHasDescriptionImportRule rule = (TransformationHasDescriptionImportRule)registry.loadClass(plugin);
        TransformationHasDescriptionImportRuleTest.assertNotNull((String)"The 'transformation has description rule' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setMinLength(20);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)transMeta);
        TransformationHasDescriptionImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        TransformationHasDescriptionImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        rule.setMinLength(2000);
        rule.setEnabled(true);
        feedback = rule.verifyRule((Object)transMeta);
        TransformationHasDescriptionImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has description rule'", (!feedback.isEmpty() ? 1 : 0) != 0);
        TransformationHasDescriptionImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)transMeta);
        TransformationHasDescriptionImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'transformation has description rule' while disabled", (boolean)feedback.isEmpty());
    }
}

