/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rule.ImportValidationResultType;
import org.pentaho.di.imp.rules.TransformationHasNoDisabledHopsImportRule;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;

public class TransformationHasNoDisabledHopsImportRuleTest
extends TestCase {
    protected void setUp() throws Exception {
        KettleEnvironment.init();
    }

    public void testRule() throws Exception {
        TransMeta transMeta = new TransMeta();
        StepMeta lastStep = null;
        for (int i = 0; i < 3; ++i) {
            DummyTransMeta dummyTransMeta = new DummyTransMeta();
            StepMeta stepMeta = new StepMeta("dummy" + (i + 1), (StepMetaInterface)dummyTransMeta);
            stepMeta.setLocation(50 + i * 50, 50);
            stepMeta.setDraw(true);
            transMeta.addStep(stepMeta);
            if (lastStep != null) {
                TransHopMeta hop = new TransHopMeta(lastStep, stepMeta);
                transMeta.addTransHop(hop);
            }
            lastStep = stepMeta;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, "TransformationHasNoDisabledHops");
        TransformationHasNoDisabledHopsImportRuleTest.assertNotNull((String)"The 'transformation has no disabled hops' rule could not be found in the plugin registry!", (Object)plugin);
        TransformationHasNoDisabledHopsImportRule rule = (TransformationHasNoDisabledHopsImportRule)registry.loadClass(plugin);
        TransformationHasNoDisabledHopsImportRuleTest.assertNotNull((String)"The 'transformation has no disabled hops' class could not be loaded by the plugin registry!", (Object)plugin);
        rule.setEnabled(true);
        List feedback = rule.verifyRule((Object)transMeta);
        TransformationHasNoDisabledHopsImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has no disabled hops'", (!feedback.isEmpty() ? 1 : 0) != 0);
        TransformationHasNoDisabledHopsImportRuleTest.assertTrue((String)"An approval ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.APPROVAL ? 1 : 0) != 0);
        transMeta.getTransHop(0).setEnabled(false);
        feedback = rule.verifyRule((Object)transMeta);
        TransformationHasNoDisabledHopsImportRuleTest.assertTrue((String)"We didn't get any feedback from the 'transformation has no disabled hops'", (!feedback.isEmpty() ? 1 : 0) != 0);
        TransformationHasNoDisabledHopsImportRuleTest.assertTrue((String)"An error ruling was expected", (((ImportValidationFeedback)feedback.get(0)).getResultType() == ImportValidationResultType.ERROR ? 1 : 0) != 0);
        rule.setEnabled(false);
        feedback = rule.verifyRule((Object)transMeta);
        TransformationHasNoDisabledHopsImportRuleTest.assertTrue((String)"We didn't expect any feedback from the 'transformation has no disabled hops' while disabled", (boolean)feedback.isEmpty());
    }
}

