/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copyfiles;

import junit.framework.TestCase;
import org.pentaho.di.TestUtilities;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entries.copyfiles.JobEntryCopyFiles;

public class CopyFilesTest
extends TestCase {
    private static Result createStartJobEntryResult() {
        Result startResult = new Result();
        startResult.setLogText(TestUtilities.now() + " - START - Starting job entry\r\n ");
        return startResult;
    }

    public void testLocalFileCopy() throws Exception {
        String sourceFolder = TestUtilities.createTempFolder("testLocalFileCopy_source");
        String destinationFolder = TestUtilities.createTempFolder("testLocalFileCopy_destination");
        if (Const.isEmpty((String)sourceFolder) || Const.isEmpty((String)destinationFolder)) {
            CopyFilesTest.fail((String)"Could not create the source and/or destination folder(s).");
        }
        TestUtilities.writeTextFile(sourceFolder, "testLocalFileCopy", ";");
        Job parentJob = new Job();
        JobEntryCopyFiles jobEntry = new JobEntryCopyFiles("Job entry copy files");
        jobEntry.source_filefolder = new String[]{sourceFolder};
        jobEntry.destination_filefolder = new String[]{destinationFolder};
        jobEntry.wildcard = new String[]{""};
        jobEntry.setParentJob(parentJob);
        Result result = jobEntry.execute(CopyFilesTest.createStartJobEntryResult(), 1);
        if (result.getNrErrors() != 0L) {
            CopyFilesTest.fail((String)result.getLogText());
        }
    }
}

