/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.kitchen;

import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.kitchen.Kitchen;
import org.pentaho.di.pan.CommandLineOption;

public class KitchenTest
extends TestCase {
    public void testArgumentMaxLogLines_valid() throws KettleException {
        String maxLogLinesArg = "50";
        int expected = 50;
        CommandLineOption opt = new CommandLineOption("maxloglines", null, new StringBuffer("50"));
        int maxLogLines = Kitchen.parseIntArgument((CommandLineOption)opt, (int)0);
        KitchenTest.assertEquals((int)expected, (int)maxLogLines);
    }

    public void testArgumentMaxLogLines_invalid() {
        String maxLogLinesArg = "fifty";
        CommandLineOption opt = new CommandLineOption("maxloglines", null, new StringBuffer("fifty"));
        try {
            Kitchen.parseIntArgument((CommandLineOption)opt, (int)0);
            KitchenTest.fail((String)"Argument should not be parsable");
        }
        catch (KettleException expected) {
            KitchenTest.assertTrue((String)("Error is not as expected: " + expected.getMessage()), (boolean)expected.getMessage().contains("ERROR: maxloglines"));
        }
    }

    public void testArgumentMaxLogTimeout_valid() throws KettleException {
        String maxLogTimeoutArg = "658";
        int expected = 658;
        CommandLineOption opt = new CommandLineOption("maxlogtimeout", null, new StringBuffer("658"));
        int maxLogLines = Kitchen.parseIntArgument((CommandLineOption)opt, (int)0);
        KitchenTest.assertEquals((int)expected, (int)maxLogLines);
    }

    public void testArgumentMaxLogTimeout_invalid() {
        String maxLogTimeoutArg = "sixfiftyeight";
        CommandLineOption opt = new CommandLineOption("maxlogtimeout", null, new StringBuffer("sixfiftyeight"));
        try {
            Kitchen.parseIntArgument((CommandLineOption)opt, (int)0);
            KitchenTest.fail((String)"Argument should not be parsable");
        }
        catch (KettleException expected) {
            KitchenTest.assertTrue((String)("Error is not as expected: " + expected.getMessage()), (boolean)expected.getMessage().contains("ERROR: maxlogtimeout"));
        }
    }

    public void testConfigureLogging() throws KettleException {
        String maxLogTimeoutArg = "600";
        KettleEnvironment.init();
        int maxNrLines = CentralLogStore.getAppender().getMaxNrLines() + 50;
        String maxLogLinesArg = String.valueOf(maxNrLines);
        CommandLineOption maxLogLinesOption = new CommandLineOption("maxloglines", null, new StringBuffer(maxLogLinesArg));
        CommandLineOption maxLogTimeoutOption = new CommandLineOption("maxlogtimeout", null, new StringBuffer("600"));
        Kitchen.configureLogging((CommandLineOption)maxLogLinesOption, (CommandLineOption)maxLogTimeoutOption);
        KitchenTest.assertEquals((int)maxNrLines, (int)CentralLogStore.getAppender().getMaxNrLines());
    }
}

