/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.TestSuite;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryCreationHelper;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;

public class RepositoryUnitTest
extends TestSuite {
    protected static KettleDatabaseRepositoryMeta repositoryMeta;
    protected static KettleDatabaseRepository repository;
    protected static DatabaseMeta connection;
    protected static PluginRegistry registry;
    protected static String filename;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleEnvironment.init();
        registry = PluginRegistry.getInstance();
        filename = File.createTempFile("kdrtest", "").getAbsolutePath();
        System.out.println("Using file '" + filename + "' as a H2 database repository");
        try {
            DatabaseMeta databaseMeta = new DatabaseMeta("H2Repo", "H2", "JDBC", null, filename, null, null, null);
            repositoryMeta = new KettleDatabaseRepositoryMeta("KettleDatabaseRepository", "H2Repo", "H2 Repository", databaseMeta);
            repository = new KettleDatabaseRepository();
            repository.init((RepositoryMeta)repositoryMeta);
            RepositoryUnitTest.repository.connectionDelegate.connect(true, true);
            KettleDatabaseRepositoryCreationHelper helper = new KettleDatabaseRepositoryCreationHelper(repository);
            helper.createRepositorySchema(null, false, new ArrayList(), false);
            repository.disconnect();
            repository.connect("admin", "admin");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KettleException("Error during database repository unit testing", (Throwable)e);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (repository != null) {
            repository.disconnect();
            new File(filename + ".h2.db").delete();
            new File(filename + ".trace.db").delete();
        }
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetXMLDataMetaSaveAndReadRep() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("getxmldata1");
        String getXMLDataName = "get xml data step";
        GetXMLDataMeta gxdm = new GetXMLDataMeta();
        String getXMLDataPid = registry.getPluginId(StepPluginType.class, (Object)gxdm);
        StepMeta getXMLDataStep = new StepMeta(getXMLDataPid, getXMLDataName, (StepMetaInterface)gxdm);
        transMeta.addStep(getXMLDataStep);
        GetXMLDataField[] fields = new GetXMLDataField[1];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new GetXMLDataField();
        }
        fields[0].setName("objectid");
        fields[0].setXPath("ObjectID");
        fields[0].setElementType(0);
        fields[0].setResultType(1);
        fields[0].setType(2);
        fields[0].setFormat("");
        fields[0].setLength(-1);
        fields[0].setPrecision(-1);
        fields[0].setCurrencySymbol("");
        fields[0].setDecimalSymbol("");
        fields[0].setGroupSymbol("");
        fields[0].setTrimType(0);
        gxdm.setDefault();
        gxdm.setEncoding("UTF-8");
        gxdm.setIsAFile(false);
        gxdm.setInFields(true);
        gxdm.setLoopXPath("/");
        gxdm.setXMLField("field1");
        gxdm.setInputFields(fields);
        try {
            transMeta.setRepository((Repository)repository);
            RepositoryDirectoryInterface repositoryDirectory = repository.findDirectory("/");
            transMeta.setRepositoryDirectory(repositoryDirectory);
            RepositoryUnitTest.repository.transDelegate.saveTransformation(transMeta, "None", null, true);
            GetXMLDataMeta newMeta = (GetXMLDataMeta)gxdm.clone();
            for (GetXMLDataField f : newMeta.getInputFields()) {
                f.setResultType(0);
            }
            newMeta.readRep((Repository)repository, getXMLDataStep.getObjectId(), repository.getDatabases(), new Hashtable());
            Assert.assertEquals((Object)newMeta.getInputFields()[0].getResultTypeCode(), (Object)"singlenode");
        }
        catch (KettleException e) {
            Assert.fail((String)("Test failed due to exception: " + e.getLocalizedMessage()));
        }
    }
}

