/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.resource;

import junit.framework.TestCase;
import org.apache.commons.vfs.FileObject;
import org.junit.Test;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.SequenceResourceNaming;
import org.pentaho.di.trans.TransMeta;

public class NameResourceTest
extends TestCase {
    @Test
    public void testUnixStyle() throws Exception {
        this.testNamingResourceLegacyAndNew("/home/users/test/csv input/data", "csv", "");
    }

    @Test
    public void testWindowsDriveLetter() throws Exception {
        this.testNamingResourceLegacyAndNew("z:\\program files\\data files\\data", "txt", "");
    }

    @Test
    public void testUNC() throws Exception {
        this.testNamingResourceLegacyAndNew("\\\\devju1\\pentaho\\data files\\data", "mdb", "");
    }

    @Test
    public void testVFS() throws Exception {
        this.testNamingResourceLegacyAndNew("file:///c:/home/user/database/humanResources", "mdb", "");
    }

    @Test
    public void testUnixStylePathOnly() throws Exception {
        this.testNamingResourceLegacyAndNew("/home/users/test/csv input/data", "csv", ".+");
    }

    @Test
    public void testWindowsDriveLetterPathOnly() throws Exception {
        this.testNamingResourceLegacyAndNew("z:\\program files\\data files\\data", "txt", ".+");
    }

    @Test
    public void testUNCPathOnly() throws Exception {
        this.testNamingResourceLegacyAndNew("\\\\devju1\\pentaho\\data files\\data", "mdb", ".+");
    }

    @Test
    public void testVFSPathOnly() throws Exception {
        this.testNamingResourceLegacyAndNew("file:///c:/home/user/database/humanResources", "mdb", ".+");
    }

    private void testNamingResourceLegacyAndNew(String fileName, String extension, String fileMask) throws Exception {
        TransMeta transMeta = new TransMeta();
        FileObject fileObject = KettleVFS.getFileObject((String)fileName, (VariableSpace)transMeta);
        String path = null;
        String prefix = null;
        if (Const.isEmpty((String)fileMask)) {
            prefix = fileObject.getName().getBaseName();
            path = fileObject.getParent().getURL().toString();
        } else {
            prefix = "";
            path = fileObject.getURL().toString();
        }
        SequenceResourceNaming resourceNamingInterface_LEGACY = new SequenceResourceNaming();
        SequenceResourceNaming resourceNamingInterface_NEW = new SequenceResourceNaming();
        String resolvedFileName_LEGACY = resourceNamingInterface_LEGACY.nameResource(prefix, path, extension, ResourceNamingInterface.FileNamingType.DATA_FILE);
        String resolvedFileName_NEW = resourceNamingInterface_NEW.nameResource(fileObject, (VariableSpace)transMeta, Const.isEmpty((String)fileMask));
        String pathFromMap_LEGACY = (String)resourceNamingInterface_LEGACY.getDirectoryMap().get(path);
        String pathFromMap_NEW = (String)resourceNamingInterface_NEW.getDirectoryMap().get(path);
        NameResourceTest.assertEquals((String)pathFromMap_LEGACY, (String)pathFromMap_NEW);
        NameResourceTest.assertEquals((String)resolvedFileName_LEGACY, (String)resolvedFileName_NEW);
    }
}

