/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.resource;

import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.TransMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDependencyTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ResourceDependencyTest test = new ResourceDependencyTest();
        try {
            test.setUp();
            test.testJobDependencyList();
            test.testTransformationDependencyList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                test.tearDown();
            }
            catch (Exception exception) {}
        }
    }

    public void testJobDependencyList() throws Exception {
        KettleEnvironment.init();
        JobMeta jobMeta = new JobMeta("test/org/pentaho/di/resource/processchangelog.kjb", null, null);
        List resourceReferences = jobMeta.getResourceDependencies();
        ResourceDependencyTest.assertEquals((int)5, (int)resourceReferences.size());
        for (int i = 0; i < 5; ++i) {
            ResourceReference genRef = (ResourceReference)resourceReferences.get(i);
            ResourceHolderInterface refHolder = genRef.getReferenceHolder();
            boolean checkDatabaseStuff = false;
            if (i == 0) {
                ResourceDependencyTest.assertEquals((String)"TABLE_EXISTS", (String)refHolder.getTypeId());
                checkDatabaseStuff = true;
            } else if (i == 1 || i == 4) {
                ResourceDependencyTest.assertEquals((String)"SQL", (String)refHolder.getTypeId());
                checkDatabaseStuff = true;
            } else if (i == 2 || i == 3) {
                ResourceDependencyTest.assertEquals((String)"TRANS", (String)refHolder.getTypeId());
                checkDatabaseStuff = false;
            }
            if (checkDatabaseStuff) {
                ResourceDependencyTest.assertEquals((int)2, (int)genRef.getEntries().size());
                for (int j = 0; j < 2; ++j) {
                    ResourceEntry entry = (ResourceEntry)genRef.getEntries().get(j);
                    if (j == 0) {
                        ResourceDependencyTest.assertEquals((Object)ResourceEntry.ResourceType.SERVER, (Object)entry.getResourcetype());
                        ResourceDependencyTest.assertEquals((String)"localhost", (String)entry.getResource());
                        continue;
                    }
                    ResourceDependencyTest.assertEquals((Object)ResourceEntry.ResourceType.DATABASENAME, (Object)entry.getResourcetype());
                    ResourceDependencyTest.assertEquals((String)"test", (String)entry.getResource());
                }
                continue;
            }
            ResourceDependencyTest.assertEquals((int)1, (int)genRef.getEntries().size());
            ResourceEntry entry = (ResourceEntry)genRef.getEntries().get(0);
            ResourceDependencyTest.assertEquals((Object)ResourceEntry.ResourceType.ACTIONFILE, (Object)entry.getResourcetype());
            ResourceDependencyTest.assertTrue((boolean)entry.getResource().endsWith(".ktr"));
        }
    }

    public void testTransformationDependencyList() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta("test/org/pentaho/di/resource/trans/General - Change log processing.ktr");
        List resourceReferences = transMeta.getResourceDependencies();
        ResourceDependencyTest.assertEquals((int)2, (int)resourceReferences.size());
        ResourceReference genRef = null;
        for (ResourceReference look : resourceReferences) {
            if (!look.getReferenceHolder().getTypeId().equals("TextFileInput")) continue;
            genRef = look;
        }
        ResourceDependencyTest.assertNotNull(genRef);
        ResourceHolderInterface refHolder = genRef.getReferenceHolder();
        ResourceDependencyTest.assertEquals((String)"TextFileInput", (String)refHolder.getTypeId());
        List entries = genRef.getEntries();
        ResourceDependencyTest.assertEquals((int)1, (int)entries.size());
        ResourceEntry theEntry = (ResourceEntry)entries.get(0);
        ResourceDependencyTest.assertEquals((Object)ResourceEntry.ResourceType.FILE, (Object)theEntry.getResourcetype());
        ResourceDependencyTest.assertTrue((boolean)theEntry.getResource().endsWith("changelog.txt"));
    }

    protected void printResourceReferences(List<ResourceReference> resourceReferences) {
        for (int i = 0; i < resourceReferences.size(); ++i) {
            ResourceReference genRef = resourceReferences.get(i);
            ResourceHolderInterface refHolder = genRef.getReferenceHolder();
            System.out.println("Reference Holder Information");
            System.out.println("  Name: " + refHolder.getName());
            System.out.println("  Type Id: " + refHolder.getTypeId());
            System.out.println("  Resource Entries");
            List entries = genRef.getEntries();
            for (int j = 0; j < entries.size(); ++j) {
                ResourceEntry resEntry = (ResourceEntry)entries.get(j);
                System.out.println("    Resource Entry");
                System.out.println("      Resource Type: " + resEntry.getResourcetype());
                System.out.println("      Resource: " + resEntry.getResource());
            }
        }
    }
}

