/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.run;

import java.text.DecimalFormat;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class TimedTransRunner {
    private String filename;
    private LogLevel logLevel;
    private long records;
    private double runTime;
    private double speed;
    private Result result;
    private String rowListenerStep;
    private RowListener rowListener;
    private TransMeta transMeta;
    private DatabaseMeta targetDatabaseMeta;
    private static DecimalFormat recordsDF = new DecimalFormat("###,###,##0");
    private static DecimalFormat runtimeDF = new DecimalFormat("##0.00");
    private static DecimalFormat speedDF = new DecimalFormat("#,###,###,##0");

    public TimedTransRunner(String filename, LogLevel logLevel, DatabaseMeta newTargetDatabaseMeta, long records) {
        this.filename = filename;
        this.logLevel = logLevel;
        this.targetDatabaseMeta = newTargetDatabaseMeta;
        this.records = records;
    }

    public boolean run() throws Exception {
        return this.runEngine(false);
    }

    public void printTransDescription() {
        System.out.println();
        System.out.println("Transformation name         : " + this.transMeta.getName());
        System.out.println("Transformation description  : " + Const.NVL((String)this.transMeta.getDescription(), (String)""));
        System.out.println("-----------------------------------------------------------------------------------------------------");
    }

    private void printStats(String prefix, long lines, double runTime, double speed) {
        System.out.println(prefix + ", rows: " + recordsDF.format(lines) + ",   runtime: " + runtimeDF.format(runTime) + "s,   speed: " + speedDF.format(speed) + " rows/s");
    }

    public boolean runEngine() throws KettleException {
        return this.runEngine(false);
    }

    public boolean runEngine(boolean printDescription) throws KettleException {
        StepInterface step;
        System.gc();
        KettleEnvironment.init();
        this.transMeta = new TransMeta(this.filename);
        this.transMeta.setVariable("NR_OF_ROWS", Long.toString(this.records));
        if (printDescription) {
            this.printTransDescription();
        }
        if (this.targetDatabaseMeta != null) {
            this.transMeta.addOrReplaceDatabase(this.targetDatabaseMeta);
        }
        Trans trans = new Trans(this.transMeta);
        trans.setLogLevel(this.logLevel);
        try {
            trans.prepareExecution(null);
        }
        catch (Exception e) {
            System.err.println(CentralLogStore.getAppender().getBuffer(trans.getLogChannelId(), true));
            trans.getLogChannel().logError("Error preparing / initializing transformation", (Throwable)e);
            return false;
        }
        if (!Const.isEmpty((String)this.rowListenerStep) && (step = trans.findRunThread(this.rowListenerStep)) != null) {
            step.addRowListener(this.rowListener);
        }
        long startTime = System.currentTimeMillis();
        trans.startThreads();
        trans.waitUntilFinished();
        long stopTime = System.currentTimeMillis();
        this.result = trans.getResult();
        this.runTime = (double)(stopTime - startTime) / 1000.0;
        this.speed = (double)this.records / this.runTime;
        this.printStats("V3 results", this.records, this.runTime, this.speed);
        return true;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public long getRecords() {
        return this.records;
    }

    public void setRecords(long records) {
        this.records = records;
    }

    public Result getNewResult() {
        return this.result;
    }

    public void setNewResult(Result result) {
        this.result = result;
    }

    public void addRowListener(String stepname, RowListener rowListener) {
        this.rowListenerStep = stepname;
        this.rowListener = rowListener;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public double getRunTime() {
        return this.runTime;
    }

    public void setNewRunTime(double runTime) {
        this.runTime = runTime;
    }

    public double speed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public DatabaseMeta getTargetDatabaseMeta() {
        return this.targetDatabaseMeta;
    }

    public void setTargetDatabaseMeta(DatabaseMeta targetDatabaseMeta) {
        this.targetDatabaseMeta = targetDatabaseMeta;
    }
}

