/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HopTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L)};
        Object[] r2 = new Object[]{new Long(2L)};
        Object[] r3 = new Object[]{new Long(3L)};
        Object[] r4 = new Object[]{new Long(4L)};
        Object[] r5 = new Object[]{new Long(5L)};
        Object[] r6 = new Object[]{new Long(6L)};
        Object[] r7 = new Object[]{new Long(7L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            HopTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object[] r2;
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            if (r1.length != (r2 = rm2.getData()).length) {
                HopTest.fail((String)("row nr " + idx + "is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    HopTest.fail((String)("row nr " + idx + "is not equal"));
                }
            }
            catch (KettleValueException e) {
                HopTest.fail((String)("row nr " + idx + "is not equal"));
            }
            ++idx;
        }
    }

    public void testCopyHops() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("hop test default");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep);
        transMeta.addTransHop(hi);
        dummyStep.setDistributes(false);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hop1 = new TransHopMeta(dummyStep, dummyStep1);
        transMeta.addTransHop(hop1);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hop2 = new TransHopMeta(dummyStep, dummyStep2);
        transMeta.addTransHop(hop2);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si1 = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector rc1 = new RowStepCollector();
        si1.addRowListener((RowListener)rc1);
        StepInterface si2 = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector rc2 = new RowStepCollector();
        si2.addRowListener((RowListener)rc2);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc1.getRowsWritten();
        this.checkRows(resultRows, inputList);
    }

    public void testDefaultConfiguration() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("hop test default");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep);
        transMeta.addTransHop(hi);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hop1 = new TransHopMeta(dummyStep, dummyStep1);
        transMeta.addTransHop(hop1);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hop2 = new TransHopMeta(dummyStep, dummyStep2);
        transMeta.addTransHop(hop2);
        dummyStep.setDistributes(true);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si1 = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector rc1 = new RowStepCollector();
        si1.addRowListener((RowListener)rc1);
        StepInterface si2 = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector rc2 = new RowStepCollector();
        si2.addRowListener((RowListener)rc2);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        ArrayList<RowMetaAndData> compareList1 = new ArrayList<RowMetaAndData>();
        ArrayList<RowMetaAndData> compareList2 = new ArrayList<RowMetaAndData>();
        int counter = 1;
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
            if (counter % 2 == 0) {
                compareList2.add(rm);
            } else {
                compareList1.add(rm);
            }
            ++counter;
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = rc1.getRowsWritten();
        this.checkRows(resultRows1, compareList1);
        List<RowMetaAndData> resultRows2 = rc2.getRowsWritten();
        this.checkRows(resultRows2, compareList2);
    }

    public void testDistributeHops() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("hop test default");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep);
        transMeta.addTransHop(hi);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hop1 = new TransHopMeta(dummyStep, dummyStep1);
        transMeta.addTransHop(hop1);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hop2 = new TransHopMeta(dummyStep, dummyStep2);
        transMeta.addTransHop(hop2);
        dummyStep.setDistributes(true);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si1 = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector rc1 = new RowStepCollector();
        si1.addRowListener((RowListener)rc1);
        StepInterface si2 = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector rc2 = new RowStepCollector();
        si2.addRowListener((RowListener)rc2);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        ArrayList<RowMetaAndData> compareList1 = new ArrayList<RowMetaAndData>();
        ArrayList<RowMetaAndData> compareList2 = new ArrayList<RowMetaAndData>();
        int counter = 1;
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
            if (counter % 2 == 0) {
                compareList2.add(rm);
            } else {
                compareList1.add(rm);
            }
            ++counter;
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = rc1.getRowsWritten();
        this.checkRows(resultRows1, compareList1);
        List<RowMetaAndData> resultRows2 = rc2.getRowsWritten();
        this.checkRows(resultRows2, compareList2);
    }
}

