/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class NormalExecutionTest
extends TestCase {
    private boolean initCalled = false;

    protected synchronized void setUp() throws Exception {
        if (this.initCalled) {
            return;
        }
        KettleEnvironment.init();
        this.initCalled = true;
        CentralLogStore.getAppender().setMaxNrLines(100);
    }

    public void testWaitUntilFinished() throws Exception {
        Long ROWS = 10L;
        int ITERATIONS = 100000;
        TransMeta transMeta = new TransMeta("testfiles/NormalExecutionTest - WaitUntilFinished.ktr");
        transMeta.setSizeRowset(5);
        for (int t = 0; t < 100000; ++t) {
            Trans trans = new Trans(transMeta);
            trans.setLogLevel(LogLevel.NOTHING);
            trans.prepareExecution(null);
            StepInterface injector = trans.findRunThread("Injector");
            StepInterface output = trans.findRunThread("Output");
            RowMeta injectorRowMeta = new RowMeta();
            ((BaseStepMeta)injector.getStepMeta().getStepMetaInterface()).getFields((RowMetaInterface)injectorRowMeta, null, null, null, null);
            RowProducer producer = trans.addRowProducer(injector.getStepname(), 0);
            CountingRowListener countingListener = new CountingRowListener();
            output.addRowListener((RowListener)countingListener);
            Object[] row = new Object[1];
            trans.startThreads();
            Integer i = 0;
            while ((long)i.intValue() < ROWS) {
                row[0] = i;
                producer.putRow((RowMetaInterface)injectorRowMeta, row);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            producer.finished();
            trans.waitUntilFinished();
            countingListener.setListening(false);
            NormalExecutionTest.assertTrue((boolean)trans.isFinished());
            long start = System.currentTimeMillis();
            while (countingListener.getWritten() + countingListener.getIgnoredWritten() != ROWS) {
                Thread.sleep(0L, 10);
            }
            long end = System.currentTimeMillis();
            System.out.println("Run report for RowListener on last step in transformation, iteration #" + (t + 1) + " :\n");
            System.out.println("Rows read             : " + countingListener.getRead());
            System.out.println("Rows written          : " + countingListener.getWritten());
            System.out.println("Rows error            : " + countingListener.getError());
            System.out.println("Rows ignored (read)   : " + countingListener.getIgnoredRead());
            System.out.println("Rows ignored (written): " + countingListener.getIgnoredWritten());
            System.out.println("Rows ignored (error)  : " + countingListener.getIgnoredError());
            System.out.println("Had to wait " + (end - start) + "ms for all data to be received by the row listener.");
            NormalExecutionTest.assertEquals((String)"Incorrect number of read rows received", (Object)ROWS, (Object)countingListener.getRead());
            NormalExecutionTest.assertEquals((String)"Incorrect number of written rows received", (Object)ROWS, (Object)countingListener.getWritten());
            NormalExecutionTest.assertEquals((String)"Incorrect number of error rows received", (Object)new Long(0L), (Object)countingListener.getError());
        }
    }

    public void testStartThreads_only_one_TransListener() throws Exception {
        TransMeta transMeta = new TransMeta("testfiles/NormalExecutionTest - WaitUntilFinished.ktr");
        Trans trans = new Trans(transMeta);
        trans.setLogLevel(LogLevel.NOTHING);
        trans.prepareExecution(null);
        trans.startThreads();
        trans.waitUntilFinished();
        int numTransListeners = trans.getTransListeners().size();
        trans.prepareExecution(null);
        trans.startThreads();
        trans.waitUntilFinished();
        NormalExecutionTest.assertEquals((String)"TransListeners on Trans are growing", (int)numTransListeners, (int)trans.getTransListeners().size());
    }

    private class CountingRowListener
    extends RowAdapter {
        private Long error;
        private Long written;
        private Long read;
        private Long ignoredError;
        private Long ignoredWritten;
        private Long ignoredRead;
        private AtomicBoolean listening;

        public CountingRowListener() {
            this.written = this.read = Long.valueOf(0L);
            this.error = this.read;
            this.ignoredRead = this.read;
            this.ignoredWritten = this.read;
            this.ignoredError = this.read;
            this.listening = new AtomicBoolean(true);
        }

        public void setListening(boolean b) {
            this.listening.set(b);
        }

        public boolean isListening() {
            return this.listening.get();
        }

        public Long getError() {
            return this.error;
        }

        public Long getWritten() {
            return this.written;
        }

        public Long getRead() {
            return this.read;
        }

        public Long getIgnoredError() {
            return this.ignoredError;
        }

        public Long getIgnoredWritten() {
            return this.ignoredWritten;
        }

        public Long getIgnoredRead() {
            return this.ignoredRead;
        }

        public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (!this.isListening()) {
                Long l = this.ignoredError;
                Long l2 = this.ignoredError = Long.valueOf(this.ignoredError + 1L);
            } else {
                Long l = this.error;
                Long l3 = this.error = Long.valueOf(this.error + 1L);
            }
        }

        public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (!this.isListening()) {
                Long l = this.ignoredRead;
                Long l2 = this.ignoredRead = Long.valueOf(this.ignoredRead + 1L);
            } else {
                Long l = this.read;
                Long l3 = this.read = Long.valueOf(this.read + 1L);
            }
        }

        public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (!this.isListening()) {
                Long l = this.ignoredWritten;
                Long l2 = this.ignoredWritten = Long.valueOf(this.ignoredWritten + 1L);
            } else {
                Long l = this.written;
                Long l3 = this.written = Long.valueOf(this.written + 1L);
            }
        }
    }
}

