/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;

public class RowProducerTest
extends TestCase {
    public void testPutRow_not_full() {
        boolean attempts = true;
        MockBlockingRowSet rs = new MockBlockingRowSet(1);
        RowProducer rp = new RowProducer(null, (RowSet)rs);
        rp.putRow(null, null);
        RowProducerTest.assertEquals((String)"Total attempts to putRow() exceeded expected amount", (int)1, (int)rs.getTotalAttempts());
    }

    public void testPutRow_full() {
        int attempts = 10;
        MockBlockingRowSet rs = new MockBlockingRowSet(10);
        RowProducer rp = new RowProducer(null, (RowSet)rs);
        rp.putRow(null, null);
        RowProducerTest.assertEquals((String)"Total attempts to putRow() exceeded expected amount", (int)10, (int)rs.getTotalAttempts());
    }

    class MockBlockingRowSet
    implements RowSet {
        private final int reqdAttempts;
        private int totalAttempts;

        public MockBlockingRowSet(int attempts) {
            this.reqdAttempts = attempts;
            this.totalAttempts = 0;
        }

        public int getTotalAttempts() {
            return this.totalAttempts;
        }

        public boolean putRow(RowMetaInterface rowMeta, Object[] rowData) {
            throw new UnsupportedOperationException();
        }

        public boolean putRowWait(RowMetaInterface rowMeta, Object[] rowData, long time, TimeUnit tu) {
            ++this.totalAttempts;
            if (this.totalAttempts % this.reqdAttempts == 0) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return false;
        }

        public Object[] getRow() {
            throw new UnsupportedOperationException();
        }

        public Object[] getRowImmediate() {
            throw new UnsupportedOperationException();
        }

        public Object[] getRowWait(long timeout, TimeUnit tu) {
            throw new UnsupportedOperationException();
        }

        public void setDone() {
            throw new UnsupportedOperationException();
        }

        public boolean isDone() {
            throw new UnsupportedOperationException();
        }

        public String getOriginStepName() {
            throw new UnsupportedOperationException();
        }

        public int getOriginStepCopy() {
            throw new UnsupportedOperationException();
        }

        public String getDestinationStepName() {
            throw new UnsupportedOperationException();
        }

        public int getDestinationStepCopy() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public void setThreadNameFromToCopy(String from, int from_copy, String to, int to_copy) {
            throw new UnsupportedOperationException();
        }

        public RowMetaInterface getRowMeta() {
            throw new UnsupportedOperationException();
        }

        public void setRowMeta(RowMetaInterface rowMeta) {
            throw new UnsupportedOperationException();
        }

        public String getRemoteSlaveServerName() {
            throw new UnsupportedOperationException();
        }

        public void setRemoteSlaveServerName(String remoteSlaveServerName) {
            throw new UnsupportedOperationException();
        }

        public boolean isBlocking() {
            return true;
        }
    }
}

