/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaDataCombi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransSingleThreadTest
extends TestCase {
    public void testSingleThreadedTrans() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta("testfiles/SingleThreadedTest - Stream Lookup.ktr");
        transMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
        long transStart = System.currentTimeMillis();
        Trans trans = new Trans(transMeta);
        trans.setLogLevel(LogLevel.MINIMAL);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface("OUTPUT", 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer("INPUT", 0);
        trans.startThreads();
        SingleThreadedTransExecutor executor = new SingleThreadedTransExecutor(trans);
        executor.init();
        int iterations = 1000000;
        long totalWait = 0L;
        List<RowMetaAndData> inputList = this.createData();
        for (int i = 0; i < iterations; ++i) {
            for (RowMetaAndData rm : inputList) {
                Object[] copy = rm.getRowMeta().cloneRow(rm.getData());
                rp.putRow(rm.getRowMeta(), copy);
            }
            long start = System.currentTimeMillis();
            boolean cont = executor.oneIteration();
            if (!cont) {
                TransSingleThreadTest.fail((String)"We don't expect any step or the transformation to be done before the end of all iterations.");
            }
            long end = System.currentTimeMillis();
            long delay = end - start;
            totalWait += delay;
            if (i > 0 && i % 100000 == 0) {
                long rowsProcessed = trans.findRunThread("bottles").getLinesRead();
                double speed = Const.round((double)((double)rowsProcessed / ((double)(end - transStart) / 1000.0)), (int)1);
                int totalRows = 0;
                for (StepMetaDataCombi combi : trans.getSteps()) {
                    for (RowSet rowSet : combi.step.getInputRowSets()) {
                        totalRows += rowSet.size();
                    }
                    for (RowSet rowSet : combi.step.getOutputRowSets()) {
                        totalRows += rowSet.size();
                    }
                }
                System.out.println("#" + i + " : Finished processing one iteration in " + delay + "ms, average is: " + Const.round((double)((double)totalWait / (double)(i + 1)), (int)1) + ", speed=" + speed + " row/s, total rows buffered: " + totalRows);
            }
            List<RowMetaAndData> resultRows = rc.getRowsWritten();
            TransSingleThreadTest.assertEquals((String)("Error found in iteration " + i), (int)6, (int)resultRows.size());
            rc.clear();
        }
        rp.finished();
        executor.dispose();
        long rowsProcessed = trans.findRunThread("bottles").getLinesRead();
        long transEnd = System.currentTimeMillis();
        long transTime = transEnd - transStart;
        System.out.println("Average delay before idle : " + Const.round((double)((double)totalWait / (double)iterations), (int)1));
        double transTimeSeconds = Const.round((double)((double)transTime / 1000.0), (int)1);
        System.out.println("Total transformation runtime for " + iterations + " iterations :" + transTimeSeconds + " seconds");
        double transTimePerIteration = Const.round((double)((double)transTime / (double)iterations), (int)2);
        System.out.println("Runtime per iteration: " + transTimePerIteration + " miliseconds");
        double rowsPerSecond = Const.round((double)((double)rowsProcessed / ((double)transTime / 1000.0)), (int)1);
        System.out.println("Average speed: " + rowsPerSecond + " rows/second");
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 5), new ValueMeta("field3", 1), new ValueMeta("field4", 3), new ValueMeta("field5", 4), new ValueMeta("field6", 6), new ValueMeta("field7", 6)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"KETTLE1", new Long(123L), new Double(10.5), new Date(), Boolean.TRUE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r2 = new Object[]{"KETTLE2", new Long(500L), new Double(20.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r3 = new Object[]{"KETTLE3", new Long(501L), new Double(21.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.7)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }
}

