/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransTestFactory {
    public static final String INJECTOR_STEPNAME = "injector";
    public static final String DUMMY_STEPNAME = "dummy";

    public static TransMeta generateTestTransformation(VariableSpace parent, StepMetaInterface oneMeta, String oneStepname) {
        PluginRegistry registry = PluginRegistry.getInstance();
        TransMeta previewMeta = new TransMeta(parent);
        InjectorMeta zeroMeta = new InjectorMeta();
        StepMeta zero = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)zeroMeta), INJECTOR_STEPNAME, (StepMetaInterface)zeroMeta);
        zero.setLocation(50, 50);
        zero.setDraw(true);
        previewMeta.addStep(zero);
        StepMeta one = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)oneMeta), oneStepname, oneMeta);
        one.setLocation(150, 50);
        one.setDraw(true);
        previewMeta.addStep(one);
        DummyTransMeta twoMeta = new DummyTransMeta();
        StepMeta two = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)twoMeta), DUMMY_STEPNAME, (StepMetaInterface)twoMeta);
        two.setLocation(250, 50);
        two.setDraw(true);
        previewMeta.addStep(two);
        TransHopMeta zeroOne = new TransHopMeta(zero, one);
        previewMeta.addTransHop(zeroOne);
        TransHopMeta oneTwo = new TransHopMeta(one, two);
        previewMeta.addTransHop(oneTwo);
        return previewMeta;
    }

    public static List<RowMetaAndData> executeTestTransformation(TransMeta transMeta, String injectorStepname, String testStepname, String dummyStepname, List<RowMetaAndData> inputData) throws KettleException {
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = inputData;
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        if (trans.getResult().getNrErrors() > 0L) {
            throw new KettleException("Test transformation finished with errors. Check the log.");
        }
        return dummyRc.getRowsRead();
    }
}

