/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaDataCombi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordCountSingleThreadTest
extends TestCase {
    public void testWordCountMapper() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta("testfiles/wordcount-mapper.ktr");
        transMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
        long transStart = System.currentTimeMillis();
        Trans trans = new Trans(transMeta);
        trans.setLogLevel(LogLevel.MINIMAL);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface("Output", 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer("Injector", 0);
        trans.startThreads();
        String metricsStep = "Remove garbage";
        SingleThreadedTransExecutor executor = new SingleThreadedTransExecutor(trans);
        executor.init();
        int iterations = 1000000;
        long totalWait = 0L;
        List<RowMetaAndData> inputList = this.createMapperData();
        for (int i = 0; i < iterations; ++i) {
            for (RowMetaAndData rm : inputList) {
                Object[] copy = rm.getRowMeta().cloneRow(rm.getData());
                rp.putRow(rm.getRowMeta(), copy);
            }
            long start = System.currentTimeMillis();
            boolean cont = executor.oneIteration();
            if (!cont) {
                WordCountSingleThreadTest.fail((String)"We don't expect any step or the transformation to be done before the end of all iterations.");
            }
            long end = System.currentTimeMillis();
            long delay = end - start;
            totalWait += delay;
            if (i > 0 && i % 100000 == 0) {
                long rowsProcessed = trans.findRunThread(metricsStep).getLinesRead();
                double speed = Const.round((double)((double)rowsProcessed / ((double)(end - transStart) / 1000.0)), (int)1);
                int totalRows = 0;
                for (StepMetaDataCombi combi : trans.getSteps()) {
                    for (RowSet rowSet : combi.step.getInputRowSets()) {
                        totalRows += rowSet.size();
                    }
                    for (RowSet rowSet : combi.step.getOutputRowSets()) {
                        totalRows += rowSet.size();
                    }
                }
                System.out.println("#" + i + " : Finished processing one iteration in " + delay + "ms, average is: " + Const.round((double)((double)totalWait / (double)(i + 1)), (int)1) + ", speed=" + speed + " row/s, total rows buffered: " + totalRows);
            }
            List<RowMetaAndData> resultRows = rc.getRowsWritten();
            WordCountSingleThreadTest.assertEquals((String)("Error found in iteration " + i + " : not the expected amount of output rows."), (int)9, (int)resultRows.size());
            rc.clear();
        }
        rp.finished();
        executor.dispose();
        long rowsProcessed = trans.findRunThread(metricsStep).getLinesRead();
        long transEnd = System.currentTimeMillis();
        long transTime = transEnd - transStart;
        System.out.println("Average delay before idle : " + Const.round((double)((double)totalWait / (double)iterations), (int)1));
        double transTimeSeconds = Const.round((double)((double)transTime / 1000.0), (int)1);
        System.out.println("Total transformation runtime for " + iterations + " iterations :" + transTimeSeconds + " seconds");
        double transTimePerIteration = Const.round((double)((double)transTime / (double)iterations), (int)2);
        System.out.println("Runtime per iteration: " + transTimePerIteration + " miliseconds");
        double rowsPerSecond = Const.round((double)((double)rowsProcessed / ((double)transTime / 1000.0)), (int)1);
        System.out.println("Average speed: " + rowsPerSecond + " rows/second");
    }

    public void testWordCountReducer() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta("testfiles/wordcount-reducer.ktr");
        transMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
        long transStart = System.currentTimeMillis();
        Trans trans = new Trans(transMeta);
        trans.setLogLevel(LogLevel.MINIMAL);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface("Output", 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer("Injector", 0);
        trans.startThreads();
        String metricsStep = "Injector";
        SingleThreadedTransExecutor executor = new SingleThreadedTransExecutor(trans);
        executor.init();
        int iterations = 1000000;
        long totalWait = 0L;
        List<RowMetaAndData> inputList = this.createReducerData();
        for (int i = 0; i < iterations; ++i) {
            for (RowMetaAndData rm : inputList) {
                Object[] copy = rm.getRowMeta().cloneRow(rm.getData());
                rp.putRow(rm.getRowMeta(), copy);
            }
            long start = System.currentTimeMillis();
            boolean cont = executor.oneIteration();
            if (!cont) {
                WordCountSingleThreadTest.fail((String)"We don't expect any step or the transformation to be done before the end of all iterations.");
            }
            long end = System.currentTimeMillis();
            long delay = end - start;
            totalWait += delay;
            if (i > 0 && i % 100000 == 0) {
                long rowsProcessed = trans.findRunThread(metricsStep).getLinesRead();
                double speed = Const.round((double)((double)rowsProcessed / ((double)(end - transStart) / 1000.0)), (int)1);
                int totalRows = 0;
                for (StepMetaDataCombi combi : trans.getSteps()) {
                    for (RowSet rowSet : combi.step.getInputRowSets()) {
                        totalRows += rowSet.size();
                    }
                    for (RowSet rowSet : combi.step.getOutputRowSets()) {
                        totalRows += rowSet.size();
                    }
                }
                System.out.println("#" + i + " : Finished processing one iteration in " + delay + "ms, average is: " + Const.round((double)((double)totalWait / (double)(i + 1)), (int)1) + ", speed=" + speed + " row/s, total rows buffered: " + totalRows);
            }
            List<RowMetaAndData> resultRows = rc.getRowsWritten();
            WordCountSingleThreadTest.assertEquals((String)("Error found in iteration " + i + " : not the expected amount of output rows."), (int)4, (int)resultRows.size());
            rc.clear();
        }
        rp.finished();
        executor.dispose();
        long rowsProcessed = trans.findRunThread(metricsStep).getLinesRead();
        long transEnd = System.currentTimeMillis();
        long transTime = transEnd - transStart;
        System.out.println("Average delay before idle : " + Const.round((double)((double)totalWait / (double)iterations), (int)1));
        double transTimeSeconds = Const.round((double)((double)transTime / 1000.0), (int)1);
        System.out.println("Total transformation runtime for " + iterations + " iterations :" + transTimeSeconds + " seconds");
        double transTimePerIteration = Const.round((double)((double)transTime / (double)iterations), (int)2);
        System.out.println("Runtime per iteration: " + transTimePerIteration + " miliseconds");
        double rowsPerSecond = Const.round((double)((double)rowsProcessed / ((double)transTime / 1000.0)), (int)1);
        System.out.println("Average speed: " + rowsPerSecond + " rows/second");
    }

    public RowMetaInterface createMapperRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("key", 2), new ValueMeta("value", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createMapperData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createMapperRowMetaInterface();
        Object[] r1 = new Object[]{"12345", "The quick brown fox jumped over the lazy dog"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createReducerRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("key", 2), new ValueMeta("value", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createReducerData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createReducerRowMetaInterface();
        Object[] r1 = new Object[]{"A", 100L};
        list.add(new RowMetaAndData(rm, r1));
        r1 = new Object[]{"A", 200L};
        list.add(new RowMetaAndData(rm, r1));
        r1 = new Object[]{"B", 300L};
        list.add(new RowMetaAndData(rm, r1));
        r1 = new Object[]{"C", 400L};
        list.add(new RowMetaAndData(rm, r1));
        r1 = new Object[]{"C", 500L};
        list.add(new RowMetaAndData(rm, r1));
        r1 = new Object[]{"D", 600L};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }
}

