/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.append;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.append.AppendMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 5), new ValueMeta("field3", 1), new ValueMeta("field4", 3), new ValueMeta("field5", 4), new ValueMeta("field6", 6), new ValueMeta("field7", 6)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"KETTLE1", new Long(123L), new Double(10.5), new Date(), Boolean.TRUE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r2 = new Object[]{"KETTLE1", new Long(500L), new Double(20.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r3 = new Object[]{"KETTLE1", new Long(501L), new Double(21.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.7)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public List<RowMetaAndData> createData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"KETTLE1", 123L, new Double(10.5), new Date(), Boolean.TRUE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r2 = new Object[]{"KETTLE1", 500L, new Double(20.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r3 = new Object[]{"KETTLE1", 501L, new Double(21.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.7)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            AppendTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object[] r2;
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            if (r1.length != (r2 = rm2.getData()).length) {
                AppendTest.fail((String)("row nr " + idx + "is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    AppendTest.fail((String)("row nr " + idx + "is not equal"));
                }
            }
            catch (KettleValueException e) {
                AppendTest.fail((String)("row nr " + idx + "is not equal"));
            }
            ++idx;
        }
    }

    public void testAppendStep() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("Appendtest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname1 = "injector step 1";
        InjectorMeta im1 = new InjectorMeta();
        String injectorPid1 = registry.getPluginId(StepPluginType.class, (Object)im1);
        StepMeta injectorStep1 = new StepMeta(injectorPid1, injectorStepname1, (StepMetaInterface)im1);
        transMeta.addStep(injectorStep1);
        String injectorStepname2 = "injector step 2";
        InjectorMeta im2 = new InjectorMeta();
        String injectorPid2 = registry.getPluginId(StepPluginType.class, (Object)im2);
        StepMeta injectorStep2 = new StepMeta(injectorPid2, injectorStepname2, (StepMetaInterface)im2);
        transMeta.addStep(injectorStep2);
        String appendName = "append step";
        AppendMeta am = new AppendMeta();
        List infoStreams = am.getStepIOMeta().getInfoStreams();
        ((StreamInterface)infoStreams.get(0)).setStepMeta(injectorStep1);
        ((StreamInterface)infoStreams.get(1)).setStepMeta(injectorStep2);
        String appendPid = registry.getPluginId(StepPluginType.class, (Object)am);
        StepMeta append = new StepMeta(appendPid, appendName, (StepMetaInterface)am);
        transMeta.addStep(append);
        TransHopMeta hi2 = new TransHopMeta(injectorStep1, append);
        transMeta.addTransHop(hi2);
        TransHopMeta hi3 = new TransHopMeta(injectorStep2, append);
        transMeta.addTransHop(hi3);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi4 = new TransHopMeta(append, dummyStep1);
        transMeta.addTransHop(hi4);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(appendName, 0);
        RowStepCollector blockingRc = new RowStepCollector();
        si.addRowListener((RowListener)blockingRc);
        si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        RowProducer rp1 = trans.addRowProducer(injectorStepname1, 0);
        RowProducer rp2 = trans.addRowProducer(injectorStepname2, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList2 = this.createData2();
        for (RowMetaAndData rm : inputList2) {
            rp2.putRow(rm.getRowMeta(), rm.getData());
        }
        rp2.finished();
        List<RowMetaAndData> inputList1 = this.createData1();
        for (RowMetaAndData rm : inputList1) {
            rp1.putRow(rm.getRowMeta(), rm.getData());
        }
        rp1.finished();
        trans.waitUntilFinished();
        ArrayList<RowMetaAndData> expectedList = new ArrayList<RowMetaAndData>();
        expectedList.addAll(inputList1);
        expectedList.addAll(inputList2);
        List<RowMetaAndData> resultRows1 = dummyRc1.getRowsWritten();
        this.checkRows(resultRows1, expectedList);
    }
}

