/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.blockingstep;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.blockingstep.BlockingStepMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingStepTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 5), new ValueMeta("field3", 1), new ValueMeta("field4", 3), new ValueMeta("field5", 4), new ValueMeta("field6", 6), new ValueMeta("field7", 6)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"KETTLE1", new Long(123L), new Double(10.5), new Date(), Boolean.TRUE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r2 = new Object[]{"KETTLE2", new Long(500L), new Double(20.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.6)};
        Object[] r3 = new Object[]{"KETTLE3", new Long(501L), new Double(21.0), new Date(), Boolean.FALSE, BigDecimal.valueOf(123.45), BigDecimal.valueOf(123.7)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            BlockingStepTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object[] r2;
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            if (r1.length != (r2 = rm2.getData()).length) {
                BlockingStepTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    BlockingStepTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                BlockingStepTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testBlockingStep() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("blockingsteptest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String blockingStepname = "blocking step";
        BlockingStepMeta bm = new BlockingStepMeta();
        String blockingStepPid = registry.getPluginId(StepPluginType.class, (Object)bm);
        StepMeta blockingStep = new StepMeta(blockingStepPid, blockingStepname, (StepMetaInterface)bm);
        transMeta.addStep(blockingStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, blockingStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(blockingStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(blockingStepname, 0);
        RowStepCollector blockingRc = new RowStepCollector();
        si.addRowListener((RowListener)blockingRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc2 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc2);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = dummyRc1.getRowsRead();
        this.checkRows(resultRows1, inputList);
        List<RowMetaAndData> resultRows2 = blockingRc.getRowsRead();
        this.checkRows(resultRows2, inputList);
        List<RowMetaAndData> resultRows3 = dummyRc2.getRowsRead();
        ArrayList<RowMetaAndData> lastList = new ArrayList<RowMetaAndData>();
        lastList.add(inputList.get(inputList.size() - 1));
        this.checkRows(resultRows3, lastList);
    }

    public void testBlockingStepPassAll() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("blockingsteptest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String blockingStepname = "blocking step";
        BlockingStepMeta bm = new BlockingStepMeta();
        bm.setPassAllRows(true);
        String blockingStepPid = registry.getPluginId(StepPluginType.class, (Object)bm);
        StepMeta blockingStep = new StepMeta(blockingStepPid, blockingStepname, (StepMetaInterface)bm);
        transMeta.addStep(blockingStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, blockingStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(blockingStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(blockingStepname, 0);
        RowStepCollector blockingRc = new RowStepCollector();
        si.addRowListener((RowListener)blockingRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc2 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc2);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = dummyRc1.getRowsWritten();
        this.checkRows(resultRows1, inputList);
        List<RowMetaAndData> resultRows2 = blockingRc.getRowsWritten();
        this.checkRows(resultRows2, inputList);
        List<RowMetaAndData> resultRows3 = dummyRc2.getRowsWritten();
        this.checkRows(resultRows3, inputList);
    }
}

