/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSumMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;

public class CheckSumTest
extends TestCase {
    private Trans buildHexadecimalChecksumTrans(int checkSumType, boolean compatibilityMode) throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName(((Object)((Object)this)).getClass().getName());
        String checkSumStepname = "CheckSum";
        CheckSumMeta meta = new CheckSumMeta();
        meta.setCompatibilityMode(compatibilityMode);
        meta.setResultFieldName("hex");
        meta.setCheckSumType(checkSumType);
        meta.setResultType(1);
        meta.setFieldName(new String[]{"test"});
        String checkSumPluginPid = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)meta);
        StepMeta checkSumStep = new StepMeta(checkSumPluginPid, checkSumStepname, (StepMetaInterface)meta);
        transMeta.addStep(checkSumStep);
        String dummyStepname = "Output";
        DummyTransMeta dummyMeta = new DummyTransMeta();
        String dummyStepPid = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)dummyMeta);
        StepMeta dummyStep = new StepMeta(dummyStepPid, dummyStepname, (StepMetaInterface)dummyMeta);
        transMeta.addStep(dummyStep);
        TransHopMeta hop = new TransHopMeta(checkSumStep, dummyStep);
        transMeta.addTransHop(hop);
        return new Trans(transMeta);
    }

    private RowMeta createStringRowMeta() throws Exception {
        RowMeta rowMeta = new RowMeta();
        ValueMeta meta = new ValueMeta();
        meta.setType(2);
        meta.setName("test");
        rowMeta.addValueMeta((ValueMetaInterface)meta);
        return rowMeta;
    }

    private MockRowListener executeHexTest(int checkSumType, boolean compatibilityMode, String input) throws Exception {
        Trans trans = this.buildHexadecimalChecksumTrans(checkSumType, compatibilityMode);
        trans.prepareExecution(null);
        StepInterface output = trans.getRunThread("Output", 0);
        MockRowListener listener = new MockRowListener();
        output.addRowListener((RowListener)listener);
        RowProducer rp = trans.addRowProducer("CheckSum", 0);
        RowMeta inputRowMeta = this.createStringRowMeta();
        ((BaseStep)trans.getRunThread("CheckSum", 0)).setInputRowMeta((RowMetaInterface)inputRowMeta);
        trans.startThreads();
        rp.putRow((RowMetaInterface)inputRowMeta, new Object[]{input});
        rp.finished();
        trans.waitUntilFinished();
        trans.stopAll();
        trans.cleanup();
        return listener;
    }

    public void testHexOutput_md5() throws Exception {
        MockRowListener results = this.executeHexTest(2, false, "xyz");
        CheckSumTest.assertEquals((int)1, (int)results.getWritten().size());
        CheckSumTest.assertEquals((Object)"d16fb36f0911f878998c136191af705e", (Object)results.getWritten().get(0)[1]);
    }

    public void testHexOutput_md5_compatibilityMode() throws Exception {
        MockRowListener results = this.executeHexTest(2, true, "xyz");
        CheckSumTest.assertEquals((int)1, (int)results.getWritten().size());
        CheckSumTest.assertEquals((Object)"FD6FFD6F0911FD78FDFD1361FDFD705E", (Object)results.getWritten().get(0)[1]);
    }

    public void testHexOutput_sha1() throws Exception {
        MockRowListener results = this.executeHexTest(3, false, "xyz");
        CheckSumTest.assertEquals((int)1, (int)results.getWritten().size());
        CheckSumTest.assertEquals((Object)"66b27417d37e024c46526c2f6d358a754fc552f3", (Object)results.getWritten().get(0)[1]);
    }

    public void testHexOutput_sha1_compatibilityMode() throws Exception {
        MockRowListener results = this.executeHexTest(3, true, "xyz");
        CheckSumTest.assertEquals((int)1, (int)results.getWritten().size());
        CheckSumTest.assertEquals((Object)"66FD7417FD7E024C46526C2F6D35FD754FFD52FD", (Object)results.getWritten().get(0)[1]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockRowListener
    extends RowAdapter {
        private List<Object[]> written = new ArrayList<Object[]>();
        private List<Object[]> read = new ArrayList<Object[]>();
        private List<Object[]> error = new ArrayList<Object[]>();

        public List<Object[]> getWritten() {
            return this.written;
        }

        public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.written.add(row);
        }

        public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.read.add(row);
        }

        public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.error.add(row);
        }
    }
}

