/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.combinationlookup;

import java.sql.ResultSet;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class CombinationLookupTest
extends TestCase {
    public static final String[] databasesXML = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>lookup</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>"};
    private static String target_table = "type1_dim";
    private static String source_table = "source";
    private static String[] insertStatement = new String[]{"INSERT INTO " + source_table + "(ORDNO, DLR_CD, DLR_NM, DLR_DESC)" + "VALUES (1, 'BE010001', 'Frijters', 'Frijters NV');", "INSERT INTO " + source_table + "(ORDNO, DLR_CD, DLR_NM, DLR_DESC)" + "VALUES (2, 'BE010002', 'Sebrechts', 'Sebrechts NV');", "INSERT INTO " + source_table + "(ORDNO, DLR_CD, DLR_NM, DLR_DESC)" + "VALUES (3, 'DE010003', 'Gelden', 'Gelden Distribution Center');", "INSERT INTO " + source_table + "(ORDNO, DLR_CD, DLR_NM, DLR_DESC)" + "VALUES (4, 'BE010001', 'Frijters', 'Frijters BVBA');", "INSERT INTO " + source_table + "(ORDNO, DLR_CD, DLR_NM, DLR_DESC)" + "VALUES (5, 'DE010004', 'Germania', 'German Distribution Center');"};

    public RowMetaInterface createTargetRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ID", 5, 8, 0), new ValueMeta("DLR_CD", 2, 8, 0), new ValueMeta("DLR_NM", 2, 30, 0), new ValueMeta("DLR_DESC", 2, 30, 0)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public RowMetaInterface createSourceRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ORDNO", 5, 8, 0), new ValueMeta("DLR_CD", 2, 8, 0), new ValueMeta("DLR_NM", 2, 30, 0), new ValueMeta("DLR_DESC", 2, 30, 0)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public void createTables(Database db) throws Exception {
        String target = db.getCreateTableStatement(target_table, this.createTargetRowMetaInterface(), null, false, null, true);
        try {
            db.execStatement(target);
        }
        catch (KettleException ex) {
            CombinationLookupTest.fail((String)("failure while creating table " + target_table + ": " + ex.getMessage()));
        }
        String source = db.getCreateTableStatement(source_table, this.createSourceRowMetaInterface(), null, false, null, true);
        try {
            db.execStatement(source);
        }
        catch (KettleException ex) {
            CombinationLookupTest.fail((String)("failure while creating table " + source_table + ": " + ex.getMessage()));
        }
    }

    private void createData(Database db) throws Exception {
        for (int idx = 0; idx < insertStatement.length; ++idx) {
            db.execStatement(insertStatement[idx]);
        }
    }

    public void checkResults(Database db) throws Exception {
        String query = "SELECT ID, DLR_CD, DLR_NM, DLR_DESC FROM " + target_table + " ORDER BY ID";
        String[] correctResults = new String[]{"1|BE010001|null|null", "2|BE010002|null|null", "3|DE010003|null|null", "4|DE010004|null|null"};
        ResultSet rs = db.openQuery(query);
        int idx = 0;
        while (rs.next()) {
            int id = rs.getInt("ID");
            String dlr_cd = rs.getString("DLR_CD");
            String dlr_nm = rs.getString("DLR_NM");
            String dlr_desc = rs.getString("DLR_DESC");
            String result = id + "|" + dlr_cd + "|" + dlr_nm + "|" + dlr_desc;
            if (idx > correctResults.length) {
                CombinationLookupTest.fail((String)"more rows returned than expected");
            }
            if (!result.equals(correctResults[idx])) {
                CombinationLookupTest.fail((String)("row " + (idx + 1) + " is different than expected"));
            }
            ++idx;
        }
        if (idx < correctResults.length) {
            CombinationLookupTest.fail((String)"less rows returned than expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCombinationLookup() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta lookupDBInfo = transMeta.findDatabase("lookup");
        Database lookupDatabase = new Database((LoggingObjectInterface)transMeta, lookupDBInfo);
        lookupDatabase.connect();
        this.createTables(lookupDatabase);
        this.createData(lookupDatabase);
        PluginRegistry registry = PluginRegistry.getInstance();
        String fromstepname = "read from [" + source_table + "]";
        TableInputMeta tii = new TableInputMeta();
        tii.setDatabaseMeta(transMeta.findDatabase("lookup"));
        String selectSQL = "SELECT " + Const.CR;
        selectSQL = selectSQL + "DLR_CD, DLR_NM, DLR_DESC ";
        selectSQL = selectSQL + "FROM " + source_table + " ORDER BY ORDNO;";
        tii.setSQL(selectSQL);
        String fromstepid = registry.getPluginId(StepPluginType.class, (Object)tii);
        StepMeta fromstep = new StepMeta(fromstepid, fromstepname, (StepMetaInterface)tii);
        fromstep.setLocation(150, 100);
        fromstep.setDraw(true);
        fromstep.setDescription("Reads information from table [" + source_table + "] on database [" + lookupDBInfo + "]");
        transMeta.addStep(fromstep);
        String lookupstepname = "lookup from [lookup]";
        CombinationLookupMeta clm = new CombinationLookupMeta();
        String[] lookupKey = new String[]{"DLR_CD"};
        clm.setTablename(target_table);
        clm.setKeyField(lookupKey);
        clm.setKeyLookup(lookupKey);
        clm.setTechnicalKeyField("ID");
        clm.setTechKeyCreation(CombinationLookupMeta.CREATION_METHOD_TABLEMAX);
        clm.setDatabaseMeta(lookupDBInfo);
        String lookupstepid = registry.getPluginId(StepPluginType.class, (Object)clm);
        StepMeta lookupstep = new StepMeta(lookupstepid, lookupstepname, (StepMetaInterface)clm);
        lookupstep.setDescription("Looks up information from table [lookup] on database [" + lookupDBInfo + "]");
        transMeta.addStep(lookupstep);
        TransHopMeta hi = new TransHopMeta(fromstep, lookupstep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.execute(null);
        trans.waitUntilFinished();
        this.checkResults(lookupDatabase);
    }
}

