/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.constant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.constant.ConstantMeta;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantTest
extends TestCase {
    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("boolean1", 4), new ValueMeta("boolean2", 4), new ValueMeta("boolean3", 4), new ValueMeta("boolean4", 4), new ValueMeta("boolean5", 4), new ValueMeta("boolean6", 4), new ValueMeta("boolean7", 4), new ValueMeta("string1", 2), new ValueMeta("string2", 2), new ValueMeta("string3", 2), new ValueMeta("integer1", 5), new ValueMeta("integer2", 5), new ValueMeta("integer3", 5), new ValueMeta("integer4", 5), new ValueMeta("number1", 1), new ValueMeta("number2", 1), new ValueMeta("number3", 1), new ValueMeta("number4", 1)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, null, "AAAAAAAAAAAAAA", "   ", null, -100L, 0L, 212L, null, new Double(-100.2), new Double(0.0), new Double(212.23), null};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            ConstantTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                ConstantTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    ConstantTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                ConstantTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testConstant1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("constanttest1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String rowGeneratorStepname = "row generator step";
        RowGeneratorMeta rm = new RowGeneratorMeta();
        String rowGeneratorPid = registry.getPluginId(StepPluginType.class, (Object)rm);
        StepMeta rowGeneratorStep = new StepMeta(rowGeneratorPid, rowGeneratorStepname, (StepMetaInterface)rm);
        transMeta.addStep(rowGeneratorStep);
        String[] fieldName = new String[]{};
        String[] type = new String[]{};
        String[] value = new String[]{};
        String[] fieldFormat = new String[]{};
        String[] group = new String[]{};
        String[] decimal = new String[]{};
        int[] intDummies = new int[]{};
        rm.setDefault();
        rm.setFieldName(fieldName);
        rm.setFieldType(type);
        rm.setValue(value);
        rm.setFieldLength(intDummies);
        rm.setFieldPrecision(intDummies);
        rm.setRowLimit("1");
        rm.setFieldFormat(fieldFormat);
        rm.setGroup(group);
        rm.setDecimal(decimal);
        String constStepname1 = "constant 1";
        ConstantMeta cnst1 = new ConstantMeta();
        String[] fieldName1 = new String[]{"boolean1", "boolean2", "boolean3", "boolean4", "boolean5", "boolean6", "boolean7", "string1", "string2", "string3", "integer1", "integer2", "integer3", "integer4", "number1", "number2", "number3", "number4"};
        String[] type1 = new String[]{"boolean", "Boolean", "bOOLEAN", "BOOLEAN", "boolean", "boolean", "boolean", "string", "string", "String", "integer", "integer", "integer", "integer", "number", "number", "number", "number"};
        String[] value1 = new String[]{"Y", "T", "a", "TRUE", "0", "9", "", "AAAAAAAAAAAAAA", "   ", "", "-100", "0", "212", "", "-100.2", "0.0", "212.23", ""};
        String[] fieldFormat1 = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        String[] group1 = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", ",", ",", ",", ","};
        String[] decimal1 = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", ".", ".", ".", "."};
        String[] currency = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        int[] intDummies1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        cnst1.setFieldName(fieldName1);
        cnst1.setFieldType(type1);
        cnst1.setValue(value1);
        cnst1.setFieldLength(intDummies1);
        cnst1.setFieldPrecision(intDummies1);
        cnst1.setFieldFormat(fieldFormat1);
        cnst1.setGroup(group1);
        cnst1.setDecimal(decimal1);
        cnst1.setCurrency(currency);
        String addSeqPid1 = registry.getPluginId(StepPluginType.class, (Object)cnst1);
        StepMeta addSeqStep1 = new StepMeta(addSeqPid1, constStepname1, (StepMetaInterface)cnst1);
        transMeta.addStep(addSeqStep1);
        TransHopMeta hi1 = new TransHopMeta(rowGeneratorStep, addSeqStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(constStepname1, 0);
        RowStepCollector endRc = new RowStepCollector();
        si.addRowListener((RowListener)endRc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        List<RowMetaAndData> resultRows1 = endRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
    }
}

