/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvInput3Test
extends TestCase {
    public String writeInputFile() throws IOException {
        String rcode = null;
        File tempFile = File.createTempFile("PDI_tmp", ".tmp");
        tempFile.deleteOnExit();
        rcode = tempFile.getAbsolutePath();
        FileWriter fout = new FileWriter(tempFile);
        fout.write("1;b0;c0;\n");
        fout.write("2;b1;c1;\n");
        fout.write("3;b2;c2;\n");
        fout.close();
        return rcode;
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData(String fileName) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{fileName};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("a", 5), new ValueMeta("b", 2), new ValueMeta("c", 2), new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L), "b0", "c0", "fileName"};
        Object[] r2 = new Object[]{new Long(2L), "b1", "c1", "fileName"};
        Object[] r3 = new Object[]{new Long(3L), "b2", "c2", "fileName"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2, int fileNameColumn) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            CsvInput3Test.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                CsvInput3Test.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                r1[fileNameColumn] = r2[fileNameColumn];
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    CsvInput3Test.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                CsvInput3Test.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testCSVInput1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("csvinput1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String fileName = this.writeInputFile();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String csvInputName = "csv input step";
        CsvInputMeta cim = new CsvInputMeta();
        String csvInputPid = registry.getPluginId(StepPluginType.class, (Object)cim);
        StepMeta csvInputStep = new StepMeta(csvInputPid, csvInputName, (StepMetaInterface)cim);
        transMeta.addStep(csvInputStep);
        TextFileInputField[] fields = new TextFileInputField[3];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new TextFileInputField();
        }
        fields[0].setName("a");
        fields[0].setType(5);
        fields[0].setFormat("");
        fields[0].setLength(-1);
        fields[0].setPrecision(-1);
        fields[0].setCurrencySymbol("");
        fields[0].setDecimalSymbol("");
        fields[0].setGroupSymbol("");
        fields[0].setTrimType(0);
        fields[1].setName("b");
        fields[1].setType(2);
        fields[1].setFormat("");
        fields[1].setLength(-1);
        fields[1].setPrecision(-1);
        fields[1].setCurrencySymbol("");
        fields[1].setDecimalSymbol("");
        fields[1].setGroupSymbol("");
        fields[1].setTrimType(0);
        fields[2].setName("c");
        fields[2].setType(2);
        fields[2].setFormat("");
        fields[2].setLength(-1);
        fields[2].setPrecision(-1);
        fields[2].setCurrencySymbol("");
        fields[2].setDecimalSymbol("");
        fields[2].setGroupSymbol("");
        fields[2].setTrimType(0);
        cim.setIncludingFilename(true);
        cim.setFilename("");
        cim.setFilenameField("filename");
        cim.setDelimiter(";");
        cim.setEnclosure("\"");
        cim.setBufferSize("50000");
        cim.setLazyConversionActive(false);
        cim.setHeaderPresent(false);
        cim.setAddResultFile(false);
        cim.setIncludingFilename(true);
        cim.setRowNumField("");
        cim.setRunningInParallel(false);
        cim.setInputFields(fields);
        TransHopMeta hi = new TransHopMeta(injectorStep, csvInputStep);
        transMeta.addTransHop(hi);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(csvInputStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData(fileName);
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc1.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        this.checkRows(goldenImageRows, resultRows, 3);
    }
}

