/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.detectlastrow;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.detectlastrow.DetectLastRowMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectLastRowStepTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 5), new ValueMeta("field3", 1), new ValueMeta("field5", 4), new ValueMeta("field6", 6)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData(int nrRows) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"KETTLE1", new Long(123L), new Double(10.5), Boolean.TRUE, BigDecimal.valueOf(123.45)};
        Object[] r2 = new Object[]{"KETTLE2", new Long(500L), new Double(20.0), Boolean.FALSE, BigDecimal.valueOf(123.45)};
        Object[] r3 = new Object[]{"KETTLE3", new Long(501L), new Double(21.0), Boolean.FALSE, BigDecimal.valueOf(123.45)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list.subList(0, nrRows);
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 5), new ValueMeta("field3", 1), new ValueMeta("field5", 4), new ValueMeta("field6", 6), new ValueMeta("result", 4)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData(int nrRows) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{"KETTLE1", new Long(123L), new Double(10.5), Boolean.TRUE, BigDecimal.valueOf(123.45), nrRows == 1 ? Boolean.TRUE : Boolean.FALSE};
        Object[] r2 = new Object[]{"KETTLE2", new Long(500L), new Double(20.0), Boolean.FALSE, BigDecimal.valueOf(123.45), nrRows == 2 ? Boolean.TRUE : Boolean.FALSE};
        Object[] r3 = new Object[]{"KETTLE3", new Long(501L), new Double(21.0), Boolean.FALSE, BigDecimal.valueOf(123.45), nrRows == 3 ? Boolean.TRUE : Boolean.FALSE};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list.subList(0, nrRows);
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            DetectLastRowStepTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                DetectLastRowStepTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    DetectLastRowStepTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                DetectLastRowStepTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void detectLastRowStepTest(int nrRows) throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("detectlastrowtest1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String delectLastRowStepname = "detect last row step";
        DetectLastRowMeta dlrm = new DetectLastRowMeta();
        dlrm.setResultFieldName("result");
        String detectLastRowStepPid = registry.getPluginId(StepPluginType.class, (Object)dlrm);
        StepMeta detectLastRowStep = new StepMeta(detectLastRowStepPid, delectLastRowStepname, (StepMetaInterface)dlrm);
        transMeta.addStep(detectLastRowStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, detectLastRowStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(detectLastRowStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(delectLastRowStepname, 0);
        RowStepCollector detectLastRc = new RowStepCollector();
        si.addRowListener((RowListener)detectLastRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData(3);
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = dummyRc1.getRowsRead();
        this.checkRows(resultRows1, inputList);
        List<RowMetaAndData> goldRows = this.createResultData(3);
        List<RowMetaAndData> resultRows2 = detectLastRc.getRowsWritten();
        this.checkRows(resultRows2, goldRows);
    }

    public void testDetectLastRowStep0() throws Exception {
        this.detectLastRowStepTest(0);
    }

    public void testDetectLastRowStep1() throws Exception {
        this.detectLastRowStepTest(1);
    }

    public void testDetectLastRowStep2() throws Exception {
        this.detectLastRowStepTest(2);
    }

    public void testDetectLastRowStep3() throws Exception {
        this.detectLastRowStepTest(3);
    }
}

