/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.excelinput.WorkbookFactory;

public class JxlWorkBookTest
extends TestCase {
    public void testRead() throws Exception {
        KWorkbook workbook = WorkbookFactory.getWorkbook((SpreadSheetType)SpreadSheetType.JXL, (String)"testfiles/sample-file.xls", null);
        int numberOfSheets = workbook.getNumberOfSheets();
        JxlWorkBookTest.assertEquals((int)3, (int)numberOfSheets);
        KSheet sheet1 = workbook.getSheet(0);
        JxlWorkBookTest.assertEquals((String)"Sheet1", (String)sheet1.getName());
        sheet1 = workbook.getSheet("Sheet1");
        JxlWorkBookTest.assertEquals((String)"Sheet1", (String)sheet1.getName());
        JxlWorkBookTest.assertEquals((int)5, (int)sheet1.getRows());
        KCell[] row = sheet1.getRow(2);
        JxlWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        JxlWorkBookTest.assertEquals((Object)"One", (Object)row[1].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        JxlWorkBookTest.assertEquals((Object)new Date(1283817600000L), (Object)row[2].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        JxlWorkBookTest.assertEquals((Object)Double.valueOf("75"), (Object)row[3].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        JxlWorkBookTest.assertEquals((Object)true, (Object)row[4].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        JxlWorkBookTest.assertEquals((Object)Double.valueOf("75"), (Object)row[5].getValue());
        row = sheet1.getRow(3);
        JxlWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        JxlWorkBookTest.assertEquals((Object)"Two", (Object)row[1].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        JxlWorkBookTest.assertEquals((Object)new Date(1283904000000L), (Object)row[2].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        JxlWorkBookTest.assertEquals((Object)Double.valueOf("42"), (Object)row[3].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        JxlWorkBookTest.assertEquals((Object)false, (Object)row[4].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        JxlWorkBookTest.assertEquals((Object)Double.valueOf("117"), (Object)row[5].getValue());
        row = sheet1.getRow(4);
        JxlWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        JxlWorkBookTest.assertEquals((Object)"Three", (Object)row[1].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        JxlWorkBookTest.assertEquals((Object)new Date(1283990400000L), (Object)row[2].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        JxlWorkBookTest.assertEquals((Object)Double.valueOf("93"), (Object)row[3].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        JxlWorkBookTest.assertEquals((Object)true, (Object)row[4].getValue());
        JxlWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        JxlWorkBookTest.assertEquals((Object)Double.valueOf("210"), (Object)row[5].getValue());
        try {
            sheet1.getRow(5);
            throw new Exception("No out of bounds exception thrown when expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            workbook.close();
            return;
        }
    }
}

