/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.excelinput.WorkbookFactory;

public class OdsWorkBookTest
extends TestCase {
    public void testRead() throws Exception {
        KWorkbook workbook = WorkbookFactory.getWorkbook((SpreadSheetType)SpreadSheetType.ODS, (String)"testfiles/sample-file.ods", null);
        int numberOfSheets = workbook.getNumberOfSheets();
        OdsWorkBookTest.assertEquals((int)3, (int)numberOfSheets);
        KSheet sheet1 = workbook.getSheet(0);
        OdsWorkBookTest.assertEquals((String)"Sheet1", (String)sheet1.getName());
        sheet1 = workbook.getSheet("Sheet1");
        OdsWorkBookTest.assertEquals((String)"Sheet1", (String)sheet1.getName());
        OdsWorkBookTest.assertEquals((int)5, (int)sheet1.getRows());
        KCell[] row = sheet1.getRow(2);
        OdsWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        OdsWorkBookTest.assertEquals((Object)"One", (Object)row[1].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        OdsWorkBookTest.assertEquals((Object)new Date(1283817600000L), (Object)row[2].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        OdsWorkBookTest.assertEquals((Object)Double.valueOf("75"), (Object)row[3].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.BOOLEAN_FORMULA, (Object)row[4].getType());
        OdsWorkBookTest.assertEquals((Object)true, (Object)row[4].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        OdsWorkBookTest.assertEquals((Object)Double.valueOf("75"), (Object)row[5].getValue());
        row = sheet1.getRow(3);
        OdsWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        OdsWorkBookTest.assertEquals((Object)"Two", (Object)row[1].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        OdsWorkBookTest.assertEquals((Object)new Date(1283904000000L), (Object)row[2].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        OdsWorkBookTest.assertEquals((Object)Double.valueOf("42"), (Object)row[3].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.BOOLEAN_FORMULA, (Object)row[4].getType());
        OdsWorkBookTest.assertEquals((Object)false, (Object)row[4].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        OdsWorkBookTest.assertEquals((Object)Double.valueOf("117"), (Object)row[5].getValue());
        row = sheet1.getRow(4);
        OdsWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        OdsWorkBookTest.assertEquals((Object)"Three", (Object)row[1].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        OdsWorkBookTest.assertEquals((Object)new Date(1283990400000L), (Object)row[2].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        OdsWorkBookTest.assertEquals((Object)Double.valueOf("93"), (Object)row[3].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.BOOLEAN_FORMULA, (Object)row[4].getType());
        OdsWorkBookTest.assertEquals((Object)true, (Object)row[4].getValue());
        OdsWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        OdsWorkBookTest.assertEquals((Object)Double.valueOf("210"), (Object)row[5].getValue());
        workbook.close();
    }
}

