/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.excelinput.WorkbookFactory;

public class PoiWorkBookTest
extends TestCase {
    public void testRead() throws Exception {
        KWorkbook workbook = WorkbookFactory.getWorkbook((SpreadSheetType)SpreadSheetType.POI, (String)"testfiles/sample-file.xlsx", null);
        int numberOfSheets = workbook.getNumberOfSheets();
        PoiWorkBookTest.assertEquals((int)3, (int)numberOfSheets);
        KSheet sheet1 = workbook.getSheet(0);
        PoiWorkBookTest.assertEquals((String)"Sheet1", (String)sheet1.getName());
        sheet1 = workbook.getSheet("Sheet1");
        PoiWorkBookTest.assertEquals((String)"Sheet1", (String)sheet1.getName());
        PoiWorkBookTest.assertEquals((int)5, (int)sheet1.getRows());
        KCell[] row = sheet1.getRow(2);
        PoiWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        PoiWorkBookTest.assertEquals((Object)"One", (Object)row[1].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        PoiWorkBookTest.assertEquals((Object)new Date(1283817600000L), (Object)row[2].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        PoiWorkBookTest.assertEquals((Object)Double.valueOf("75"), (Object)row[3].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        PoiWorkBookTest.assertEquals((Object)true, (Object)row[4].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        PoiWorkBookTest.assertEquals((Object)Double.valueOf("75"), (Object)row[5].getValue());
        row = sheet1.getRow(3);
        PoiWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        PoiWorkBookTest.assertEquals((Object)"Two", (Object)row[1].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        PoiWorkBookTest.assertEquals((Object)new Date(1283904000000L), (Object)row[2].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        PoiWorkBookTest.assertEquals((Object)Double.valueOf("42"), (Object)row[3].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        PoiWorkBookTest.assertEquals((Object)false, (Object)row[4].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        PoiWorkBookTest.assertEquals((Object)Double.valueOf("117"), (Object)row[5].getValue());
        row = sheet1.getRow(4);
        PoiWorkBookTest.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        PoiWorkBookTest.assertEquals((Object)"Three", (Object)row[1].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        PoiWorkBookTest.assertEquals((Object)new Date(1283990400000L), (Object)row[2].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        PoiWorkBookTest.assertEquals((Object)Double.valueOf("93"), (Object)row[3].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        PoiWorkBookTest.assertEquals((Object)true, (Object)row[4].getValue());
        PoiWorkBookTest.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        PoiWorkBookTest.assertEquals((Object)Double.valueOf("210"), (Object)row[5].getValue());
        try {
            sheet1.getRow(5);
            throw new Exception("No out of bounds exception thrown when expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            workbook.close();
            return;
        }
    }
}

